/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.runtime;

import com.swoval.runtime.Platform;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ShutdownHooks {
    private static final Map<Integer, Hook> hooks;
    private static final AtomicInteger hookID;
    private static final AtomicBoolean shutdown;
    private static final String pid;
    private static final Object lock;

    static boolean isShutdown() {
        return shutdown.get();
    }

    static String getPid() {
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addHook(int n, Runnable runnable) {
        Object object = lock;
        synchronized (object) {
            int n2 = hookID.getAndIncrement();
            hooks.put(n2, new Hook(n, runnable));
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHook(int n) {
        Object object = lock;
        synchronized (object) {
            hooks.remove(n);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                shutdown.set(true);
                ArrayList arrayList = new ArrayList(hooks.values());
                Collections.sort(arrayList);
                for (Hook hook : arrayList) {
                    try {
                        hook.runnable.run();
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                }
            }
        });
        hooks = new LinkedHashMap<Integer, Hook>();
        hookID = new AtomicInteger(0);
        shutdown = new AtomicBoolean(false);
        pid = Platform.isWin() ? "" : ManagementFactory.getRuntimeMXBean().getName().replaceAll("@.*", "");
        lock = new Object();
    }

    private static class Hook
    implements Comparable<Hook> {
        private final int priority;
        private final Runnable runnable;

        private Hook(int n, Runnable runnable) {
            this.priority = n;
            this.runnable = runnable;
        }

        @Override
        public int compareTo(Hook hook) {
            return Integer.compare(this.priority, hook.priority);
        }
    }
}

