/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.engine;

import com.google.common.collect.MinMaxPriorityQueue;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.spellchecker.compress.CompressedDictionary;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.Suggestion;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.EditDistance;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseSpellChecker
implements SpellCheckerEngine {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.engine.BaseSpellChecker");
    private final Transformation transform;
    private final Set<EditableDictionary> dictionaries;
    private final List<Dictionary> bundledDictionaries;
    private final AtomicBoolean myLoadingDictionaries;
    private final List<Pair<Loader, Consumer<? super Dictionary>>> myDictionariesToLoad;
    private final Project myProject;

    BaseSpellChecker(@NotNull Project project) {
        if (project == null) {
            BaseSpellChecker.$$$reportNull$$$0(0);
        }
        this.transform = new Transformation();
        this.dictionaries = new HashSet<EditableDictionary>();
        this.bundledDictionaries = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLoadingDictionaries = new AtomicBoolean(false);
        this.myDictionariesToLoad = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    @Override
    public void loadDictionary(@NotNull Loader loader) {
        if (loader == null) {
            BaseSpellChecker.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.addDictionary(CompressedDictionary.create(loader, this.transform));
        } else {
            this.loadDictionaryAsync(loader, (Consumer<? super Dictionary>)((Consumer)this::addDictionary));
        }
    }

    private void loadDictionaryAsync(@NotNull Loader loader, @NotNull Consumer<? super Dictionary> consumer) {
        if (loader == null) {
            BaseSpellChecker.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            BaseSpellChecker.$$$reportNull$$$0(3);
        }
        if (this.myLoadingDictionaries.compareAndSet(false, true)) {
            LOG.debug("Loading " + loader.getName());
            this.doLoadDictionaryAsync(loader, consumer);
        } else {
            this.queueDictionaryLoad(loader, consumer);
        }
    }

    private void doLoadDictionaryAsync(Loader loader, Consumer<? super Dictionary> consumer) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            LOG.debug("Loading " + loader.getName());
            Application app = ApplicationManager.getApplication();
            app.executeOnPooledThread(() -> {
                if (app.isDisposed()) {
                    return;
                }
                CompressedDictionary dictionary = CompressedDictionary.create(loader, this.transform);
                LOG.debug(loader.getName() + " loaded!");
                consumer.consume((Object)dictionary);
                while (!this.myDictionariesToLoad.isEmpty()) {
                    if (app.isDisposed()) {
                        return;
                    }
                    Pair<Loader, Consumer<? super Dictionary>> nextDictionary = this.myDictionariesToLoad.remove(0);
                    Loader nextDictionaryLoader = (Loader)nextDictionary.getFirst();
                    dictionary = CompressedDictionary.create(nextDictionaryLoader, this.transform);
                    LOG.debug(nextDictionaryLoader.getName() + " loaded!");
                    ((Consumer)nextDictionary.getSecond()).consume((Object)dictionary);
                }
                LOG.debug("Loading finished, restarting daemon...");
                this.myLoadingDictionaries.set(false);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (app.isDisposed()) {
                        return;
                    }
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        DaemonCodeAnalyzer instance;
                        if (!project.isInitialized() || !project.isOpen() || project.isDefault() || (instance = DaemonCodeAnalyzer.getInstance((Project)project)) == null) continue;
                        instance.restart();
                    }
                });
            });
        });
    }

    private void queueDictionaryLoad(Loader loader, Consumer<? super Dictionary> consumer) {
        LOG.debug("Queuing load for: " + loader.getName());
        this.myDictionariesToLoad.add((Pair<Loader, Consumer<? super Dictionary>>)Pair.create((Object)loader, consumer));
    }

    @Override
    public void addModifiableDictionary(@NotNull EditableDictionary dictionary) {
        if (dictionary == null) {
            BaseSpellChecker.$$$reportNull$$$0(4);
        }
        this.dictionaries.add(dictionary);
    }

    @Override
    public void addDictionary(@NotNull Dictionary dictionary) {
        if (dictionary == null) {
            BaseSpellChecker.$$$reportNull$$$0(5);
        }
        this.bundledDictionaries.add(dictionary);
    }

    @Override
    public Transformation getTransformation() {
        return this.transform;
    }

    private static int isCorrect(@NotNull String transformed, @Nullable Collection<? extends Dictionary> dictionaries) {
        if (transformed == null) {
            BaseSpellChecker.$$$reportNull$$$0(6);
        }
        if (dictionaries == null) {
            return -1;
        }
        int errors = 0;
        for (Dictionary dictionary : dictionaries) {
            if (dictionary == null) continue;
            Boolean contains = dictionary.contains(transformed);
            if (contains == null) {
                ++errors;
                continue;
            }
            if (!contains.booleanValue()) continue;
            return 0;
        }
        if (errors == dictionaries.size()) {
            return errors;
        }
        return -1;
    }

    @Override
    public boolean isCorrect(@NotNull String word) {
        if (word == null) {
            BaseSpellChecker.$$$reportNull$$$0(7);
        }
        String transformed = this.transform.transform(word);
        if (this.myLoadingDictionaries.get() || transformed == null) {
            return true;
        }
        int bundled = BaseSpellChecker.isCorrect(transformed, this.bundledDictionaries);
        int user = BaseSpellChecker.isCorrect(transformed, this.dictionaries);
        return bundled == 0 || user == 0 || bundled > 0 && user > 0;
    }

    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull String word, int maxSuggestions, int quality) {
        String transformed;
        if (word == null) {
            BaseSpellChecker.$$$reportNull$$$0(8);
        }
        if ((transformed = this.transform.transform(word)) == null || maxSuggestions < 1) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                BaseSpellChecker.$$$reportNull$$$0(9);
            }
            return list;
        }
        MinMaxPriorityQueue suggestions = MinMaxPriorityQueue.orderedBy(Suggestion::compareTo).maximumSize(maxSuggestions).create();
        for (Dictionary dict : ContainerUtil.concat((Iterable[])new Iterable[]{this.bundledDictionaries, this.dictionaries})) {
            dict.getSuggestions(transformed, (Consumer<String>)((Consumer)arg_0 -> BaseSpellChecker.lambda$getSuggestions$3((Queue)suggestions, transformed, arg_0)));
        }
        if (suggestions.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                BaseSpellChecker.$$$reportNull$$$0(10);
            }
            return list;
        }
        int bestMetrics = ((Suggestion)suggestions.peek()).getMetrics();
        List<String> list = suggestions.stream().filter(i -> bestMetrics - i.getMetrics() < quality).sorted().map(Suggestion::getWord).collect(Collectors.toList());
        if (list == null) {
            BaseSpellChecker.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getVariants(@NotNull String prefix) {
        if (prefix == null) {
            BaseSpellChecker.$$$reportNull$$$0(12);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            BaseSpellChecker.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    public void reset() {
        this.bundledDictionaries.clear();
        this.dictionaries.clear();
    }

    @Override
    public boolean isDictionaryLoad(@NotNull String name) {
        if (name == null) {
            BaseSpellChecker.$$$reportNull$$$0(14);
        }
        return this.getBundledDictionaryByName(name) != null;
    }

    @Override
    public void removeDictionary(@NotNull String name) {
        Dictionary dictionaryByName;
        if (name == null) {
            BaseSpellChecker.$$$reportNull$$$0(15);
        }
        if ((dictionaryByName = this.getBundledDictionaryByName(name)) != null) {
            this.bundledDictionaries.remove(dictionaryByName);
        }
    }

    @Override
    public void removeDictionariesRecursively(@NotNull String directory) {
        if (directory == null) {
            BaseSpellChecker.$$$reportNull$$$0(16);
        }
        List toRemove = ContainerUtil.filter(this.bundledDictionaries, dict -> FileUtil.isAncestor((String)directory, (String)dict.getName(), (boolean)false) && this.isDictionaryLoad(dict.getName()));
        this.bundledDictionaries.removeAll(toRemove);
    }

    @Nullable
    private Dictionary getBundledDictionaryByName(@NotNull String name) {
        if (name == null) {
            BaseSpellChecker.$$$reportNull$$$0(17);
        }
        for (Dictionary dictionary : this.bundledDictionaries) {
            if (!name.equals(dictionary.getName())) continue;
            return dictionary;
        }
        return null;
    }

    private static /* synthetic */ void lambda$getSuggestions$3(Queue suggestions, String transformed, String s) {
        suggestions.add(new Suggestion(s, EditDistance.optimalAlignment((CharSequence)transformed, (CharSequence)s, (boolean)true)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionary";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformed";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/engine/BaseSpellChecker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/engine/BaseSpellChecker";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadDictionary";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadDictionaryAsync";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModifiableDictionary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDictionary";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCorrect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDictionaryLoad";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeDictionary";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeDictionariesRecursively";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBundledDictionaryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

