/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.Function;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartupUiUtil {
    private static String ourSystemLaFClassName;
    private static volatile StyleSheet ourDefaultHtmlKitCss;

    @NotNull
    public static String getSystemLookAndFeelClassName() {
        block7: {
            if (ourSystemLaFClassName != null) {
                String string = ourSystemLaFClassName;
                if (string == null) {
                    StartupUiUtil.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (SystemInfo.isLinux) {
                String string;
                try {
                    String name = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                    Class<?> cls = Class.forName(name);
                    LookAndFeel laf = (LookAndFeel)cls.newInstance();
                    if (!laf.isSupportedLookAndFeel()) break block7;
                    string = ourSystemLaFClassName = name;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string == null) {
                    StartupUiUtil.$$$reportNull$$$0(1);
                }
                return string;
            }
        }
        String string = ourSystemLaFClassName = UIManager.getSystemLookAndFeelClassName();
        if (string == null) {
            StartupUiUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static void initDefaultLaF() throws ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException {
        StartupUiUtil.blockATKWrapper();
        Activity activity = ParallelActivity.PREPARE_APP_INIT.start("init AWT Toolkit");
        Toolkit.getDefaultToolkit();
        activity = activity.endAndStart("init default LaF");
        UIManager.setLookAndFeel(StartupUiUtil.getSystemLookAndFeelClassName());
        activity.end();
    }

    public static void configureHtmlKitStylesheet() {
        if (ourDefaultHtmlKitCss != null) {
            return;
        }
        Activity activity = ParallelActivity.PREPARE_APP_INIT.start("configure html kit");
        HTMLEditorKit kit = new HTMLEditorKit();
        ourDefaultHtmlKitCss = kit.getStyleSheet();
        kit.setStyleSheet(null);
        UIManager.getDefaults().put("javax.swing.JLabel.userStyleSheet", JBHtmlEditorKit.createStyleSheet());
        activity.end();
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    private static void blockATKWrapper() {
        if (!SystemInfo.isLinux || !SystemProperties.getBooleanProperty((String)"linux.jdk.accessibility.atkwrapper.block", (boolean)true)) {
            return;
        }
        if (ScreenReader.isEnabled("org.GNOME.Accessibility.AtkWrapper")) {
            System.setProperty("javax.accessibility.assistive_technologies", "java.lang.Object");
            Logger.getInstance(StartupUiUtil.class).info("org.GNOME.Accessibility.AtkWrapper is blocked, see IDEA-149219");
        }
    }

    static StyleSheet getDefaultHtmlKitCss() {
        return ourDefaultHtmlKitCss;
    }

    public static boolean isJreHiDPI() {
        return JreHiDpiUtil.isJreHiDPI((GraphicsConfiguration)null);
    }

    public static boolean isJreHiDPI(@Nullable Component comp) {
        GraphicsConfiguration gc = comp != null ? comp.getGraphicsConfiguration() : null;
        return JreHiDpiUtil.isJreHiDPI(gc);
    }

    public static boolean isJreHiDPI(@Nullable ScaleContext ctx) {
        return JreHiDpiUtil.isJreHiDPIEnabled() && JBUIScale.isHiDPI(JBUIScale.sysScale(ctx));
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Dimension container, @NotNull Dimension child) {
        if (container == null) {
            StartupUiUtil.$$$reportNull$$$0(3);
        }
        if (child == null) {
            StartupUiUtil.$$$reportNull$$$0(4);
        }
        Point point = StartupUiUtil.getCenterPoint(new Rectangle(container), child);
        if (point == null) {
            StartupUiUtil.$$$reportNull$$$0(5);
        }
        return point;
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Rectangle container, @NotNull Dimension child) {
        if (container == null) {
            StartupUiUtil.$$$reportNull$$$0(6);
        }
        if (child == null) {
            StartupUiUtil.$$$reportNull$$$0(7);
        }
        Point point = new Point(container.x + (container.width - child.width) / 2, container.y + (container.height - child.height) / 2);
        if (point == null) {
            StartupUiUtil.$$$reportNull$$$0(8);
        }
        return point;
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(9);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(10);
        }
        StartupUiUtil.drawImage(g, image, new Rectangle(x, y, -1, -1), null, null, observer);
    }

    @Deprecated
    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, int width, int height, @Nullable ImageObserver observer) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(11);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(12);
        }
        StartupUiUtil.drawImage(g, image, x, y, width, height, null, observer);
    }

    private static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, int width, int height, @Nullable BufferedImageOp op, ImageObserver observer) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(13);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(14);
        }
        Rectangle srcBounds = width >= 0 && height >= 0 ? new Rectangle(x, y, width, height) : null;
        StartupUiUtil.drawImage(g, image, new Rectangle(x, y, width, height), srcBounds, op, observer);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable ImageObserver observer) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(15);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(16);
        }
        StartupUiUtil.drawImage(g, image, dstBounds, null, null, observer);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable ImageObserver observer) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(17);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(18);
        }
        StartupUiUtil.drawImage(g, image, dstBounds, srcBounds, null, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable BufferedImageOp op, @Nullable ImageObserver observer) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(19);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(20);
        }
        int userWidth = ImageUtil.getUserWidth(image);
        int userHeight = ImageUtil.getUserHeight(image);
        int dx = 0;
        int dy = 0;
        int dw = -1;
        int dh = -1;
        if (dstBounds != null) {
            dx = dstBounds.x;
            dy = dstBounds.y;
            dw = dstBounds.width;
            dh = dstBounds.height;
        }
        boolean hasDstSize = dw >= 0 && dh >= 0;
        Graphics invG = null;
        double scale = 1.0;
        if (image instanceof JBHiDPIScaledImage) {
            AffineTransform tx;
            JBHiDPIScaledImage hidpiImage = (JBHiDPIScaledImage)image;
            Image delegate = hidpiImage.getDelegate();
            if (delegate != null) {
                image = delegate;
            }
            if ((scale = hidpiImage.getScale()) == (tx = ((Graphics2D)g).getTransform()).getScaleX()) {
                double gScaleX = tx.getScaleX();
                double gScaleY = tx.getScaleY();
                tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
                tx.translate((double)dx * gScaleX, (double)dy * gScaleY);
                dy = 0;
                dx = 0;
                g = invG = (Graphics2D)g.create();
                ((Graphics2D)invG).setTransform(tx);
            }
        }
        double _scale = scale;
        Function size = size1 -> (int)Math.round((double)size1.intValue() * _scale);
        try {
            if (op != null && image instanceof BufferedImage) {
                image = op.filter((BufferedImage)image, null);
            }
            if (invG != null && hasDstSize) {
                dw = (Integer)size.fun((Object)dw);
                dh = (Integer)size.fun((Object)dh);
            }
            if (srcBounds != null) {
                int sh;
                int sx = (Integer)size.fun((Object)srcBounds.x);
                int sy = (Integer)size.fun((Object)srcBounds.y);
                int sw = srcBounds.width >= 0 ? (Integer)size.fun((Object)srcBounds.width) : (Integer)size.fun((Object)userWidth) - sx;
                int n = sh = srcBounds.height >= 0 ? (Integer)size.fun((Object)srcBounds.height) : (Integer)size.fun((Object)userHeight) - sy;
                if (!hasDstSize) {
                    dw = (Integer)size.fun((Object)userWidth);
                    dh = (Integer)size.fun((Object)userHeight);
                }
                g.drawImage(image, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, observer);
            } else if (hasDstSize) {
                g.drawImage(image, dx, dy, dw, dh, observer);
            } else if (invG == null) {
                g.drawImage(image, dx, dy, userWidth, userHeight, observer);
            } else {
                g.drawImage(image, dx, dy, observer);
            }
        }
        finally {
            if (invG != null) {
                invG.dispose();
            }
        }
    }

    public static void drawImage(@NotNull Graphics g, @NotNull BufferedImage image, @Nullable BufferedImageOp op, int x, int y) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(21);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(22);
        }
        StartupUiUtil.drawImage(g, image, x, y, -1, -1, op, null);
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static void pump() {
        assert (!SwingUtilities.isEventDispatchThread());
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        SwingUtilities.invokeLater(() -> queue.offer(queue));
        try {
            queue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/StartupUiUtil";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemLookAndFeelClassName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/StartupUiUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterPoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCenterPoint";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "drawImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

