/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck.intention;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.shellcheck.ShShellcheckInspection;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DisableInspectionIntention
implements IntentionAction,
LowPriorityAction,
Iconable {
    private static final String FEATURE_ACTION_ID = "DisableInspectionUsed";
    private final String myInspectionCode;
    private final String myMessage;

    public DisableInspectionIntention(String message, String inspectionCode) {
        this.myInspectionCode = inspectionCode;
        this.myMessage = message;
    }

    @NotNull
    public String getText() {
        String string = "Disable inspection " + this.myMessage;
        if (string == null) {
            DisableInspectionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Shell script" == null) {
            DisableInspectionIntention.$$$reportNull$$$0(1);
        }
        return "Shell script";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            DisableInspectionIntention.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            DisableInspectionIntention.$$$reportNull$$$0(3);
        }
        if (file == null) {
            return;
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, it -> {
            ShShellcheckInspection tool = (ShShellcheckInspection)it.getUnwrappedTool("ShellCheck", (PsiElement)file);
            if (tool != null) {
                tool.disableInspection(this.myInspectionCode);
            }
        });
        DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
        ShFeatureUsagesCollector.logFeatureUsage(FEATURE_ACTION_ID);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/shellcheck/intention/DisableInspectionIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/shellcheck/intention/DisableInspectionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

