/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.keePass.MasterKey;
import com.intellij.credentialStore.keePass.MasterKeyFileStorage;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.util.io.PathKt;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011H\u0000\u001a\u0010\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011H\u0000\u001a0\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"DB_FILE_NAME", "", "copyTo", "", "from", "", "Lcom/intellij/credentialStore/CredentialAttributes;", "Lcom/intellij/credentialStore/Credentials;", "store", "Lcom/intellij/credentialStore/CredentialStore;", "generateRandomMasterKey", "Lcom/intellij/credentialStore/keePass/MasterKey;", "masterKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "secureRandom", "Ljava/security/SecureRandom;", "getDefaultKeePassBaseDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getDefaultMasterPasswordFile", "saveDatabase", "dbFile", "db", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "masterKey", "masterKeyStorage", "Lcom/intellij/credentialStore/keePass/MasterKeyFileStorage;", "intellij.platform.credentialStore"})
public final class KeePassCredentialStoreKt {
    @NotNull
    public static final String DB_FILE_NAME = "c.kdbx";

    public static final Path getDefaultKeePassBaseDirectory() {
        return Paths.get(PathManager.getConfigPath(), new String[0]);
    }

    public static final Path getDefaultMasterPasswordFile() {
        return KeePassCredentialStoreKt.getDefaultKeePassBaseDirectory().resolve("c.pwd");
    }

    @NotNull
    public static final MasterKey generateRandomMasterKey(@NotNull EncryptionSpec masterKeyEncryptionSpec, @NotNull SecureRandom secureRandom2) {
        Intrinsics.checkParameterIsNotNull((Object)masterKeyEncryptionSpec, (String)"masterKeyEncryptionSpec");
        Intrinsics.checkParameterIsNotNull((Object)secureRandom2, (String)"secureRandom");
        byte[] bytes = CredentialStoreKt.generateBytes(secureRandom2, 512);
        byte[] byArray = Base64.getEncoder().withoutPadding().encode(bytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getEncoder().withoutPadding().encode(bytes)");
        return new MasterKey(byArray, true, masterKeyEncryptionSpec);
    }

    public static final void saveDatabase(@NotNull Path dbFile, @NotNull KeePassDatabase db, @NotNull MasterKey masterKey, @NotNull MasterKeyFileStorage masterKeyStorage, @NotNull SecureRandom secureRandom2) {
        Intrinsics.checkParameterIsNotNull((Object)dbFile, (String)"dbFile");
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull((Object)masterKey, (String)"masterKey");
        Intrinsics.checkParameterIsNotNull((Object)masterKeyStorage, (String)"masterKeyStorage");
        Intrinsics.checkParameterIsNotNull((Object)secureRandom2, (String)"secureRandom");
        byte[] byArray = masterKey.getValue();
        if (byArray == null) {
            Intrinsics.throwNpe();
        }
        KdbxPassword kdbxPassword = new KdbxPassword(byArray);
        masterKeyStorage.save(masterKey);
        PathKt.writeSafe((Path)dbFile, (Function1)((Function1)new Function1<OutputStream, Unit>(db, kdbxPassword, secureRandom2){
            final /* synthetic */ KeePassDatabase $db;
            final /* synthetic */ KdbxPassword $kdbxPassword;
            final /* synthetic */ SecureRandom $secureRandom;

            public final void invoke(@NotNull OutputStream it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$db.save$intellij_platform_credentialStore(this.$kdbxPassword, it, this.$secureRandom);
            }
            {
                this.$db = keePassDatabase;
                this.$kdbxPassword = kdbxPassword;
                this.$secureRandom = secureRandom2;
                super(1);
            }
        }));
        FileUtilKt.setOwnerPermissions((Path)dbFile);
    }

    public static final void copyTo(@NotNull Map<CredentialAttributes, Credentials> from, @NotNull CredentialStore store) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Map<CredentialAttributes, Credentials> map = from;
        boolean bl = false;
        Iterator<Map.Entry<CredentialAttributes, Credentials>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CredentialAttributes, Credentials> entry;
            Map.Entry<CredentialAttributes, Credentials> entry2 = entry = iterator.next();
            boolean bl2 = false;
            CredentialAttributes k = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Credentials v = entry2.getValue();
            store.set(k, v);
        }
    }
}

