/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.BranchInfo;
import git4idea.branch.GitBranchesCollection;
import git4idea.branch.GitCleanupBranchesAction;
import git4idea.branch.GitCleanupBranchesActionKt;
import git4idea.config.GitSharedSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u001fj\b\u0012\u0004\u0012\u00020\u0002` H\u0002\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"GIT_BRANCH", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lgit4idea/branch/BranchInfo;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "checkBranchesSynchronously", "", "log", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "branchesToCheck", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findExclusiveCommits", "Lgnu/trove/TIntHashSet;", "branchName", "", "repo", "Lgit4idea/repo/GitRepository;", "findMyCommits", "", "", "getAllBranches", "project", "Lcom/intellij/openapi/project/Project;", "isMyBranch", "", "myCommits", "sort", "branches", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "intellij.vcs.git"})
public final class GitCleanupBranchesActionKt {
    private static final Logger LOG;
    private static final DataKey<BranchInfo> GIT_BRANCH;

    /*
     * WARNING - void declaration
     */
    private static final List<BranchInfo> getAllBranches(Project project) {
        void $this$mapTo$iv$iv;
        BranchInfo branchInfo;
        Map.Entry entry;
        Collection collection;
        Object object;
        Iterator<GitRepository> $this$mapTo$iv$iv2;
        GitSharedSettings settings = GitSharedSettings.getInstance(project);
        boolean bl = false;
        Map localMap = new LinkedHashMap();
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
        Iterator<GitRepository> iterator = gitRepositoryManager.getRepositories().iterator();
        while (iterator.hasNext()) {
            GitRepository repo;
            GitRepository gitRepository = repo = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"repo");
            GitBranchesCollection gitBranchesCollection = gitRepository.getBranches();
            Intrinsics.checkExpressionValueIsNotNull((Object)gitBranchesCollection, (String)"repo.branches");
            for (GitLocalBranch branch : gitBranchesCollection.getLocalBranches()) {
                GitRemoteBranch trackedBranch;
                if (!(Intrinsics.areEqual((Object)repo.getCurrentBranch(), (Object)branch) ^ true) || (trackedBranch = branch.findTrackedBranch(repo)) != null && settings.isBranchProtected(trackedBranch.getNameForRemoteOperations())) continue;
                GitLocalBranch gitLocalBranch = branch;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitLocalBranch, (String)"branch");
                ((List)localMap.computeIfAbsent(gitLocalBranch.getName(), getAllBranches.1.INSTANCE)).add(repo);
            }
        }
        Map $this$map$iv = localMap;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        void var9_17 = $this$mapTo$iv$iv2;
        boolean bl2 = false;
        for (Map.Entry item$iv$iv : var9_17.entrySet()) {
            void $dstr$branchName$repos;
            object = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            entry = $dstr$branchName$repos;
            boolean bl4 = false;
            String branchName = (String)entry.getKey();
            entry = $dstr$branchName$repos;
            bl4 = false;
            List repos = (List)entry.getValue();
            branchInfo = new BranchInfo(branchName, true, repos);
            collection.add(branchInfo);
        }
        List local = (List)destination$iv$iv;
        $i$f$map = false;
        Map remoteMap = new LinkedHashMap();
        GitRepositoryManager gitRepositoryManager2 = GitRepositoryManager.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gitRepositoryManager2), (String)"GitRepositoryManager.getInstance(project)");
        $this$mapTo$iv$iv2 = gitRepositoryManager2.getRepositories().iterator();
        while ($this$mapTo$iv$iv2.hasNext()) {
            GitRepository repo;
            GitRepository gitRepository = repo = $this$mapTo$iv$iv2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"repo");
            GitBranchesCollection gitBranchesCollection = gitRepository.getBranches();
            Intrinsics.checkExpressionValueIsNotNull((Object)gitBranchesCollection, (String)"repo.branches");
            Iterator<GitRemoteBranch> $i$f$mapTo2 = gitBranchesCollection.getRemoteBranches().iterator();
            while ($i$f$mapTo2.hasNext()) {
                GitRemoteBranch remoteBranch;
                GitRemoteBranch gitRemoteBranch = remoteBranch = $i$f$mapTo2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRemoteBranch, (String)"remoteBranch");
                if (settings.isBranchProtected(gitRemoteBranch.getNameForRemoteOperations())) continue;
                ((List)remoteMap.computeIfAbsent(remoteBranch.getName(), getAllBranches.2.INSTANCE)).add(repo);
            }
        }
        Map $this$map$iv2 = remoteMap;
        boolean $i$f$map2 = false;
        Map $i$f$mapTo2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo3 = false;
        Iterator iterator2 = $this$mapTo$iv$iv;
        boolean bl5 = false;
        object = iterator2.entrySet().iterator();
        while (object.hasNext()) {
            void $dstr$branchName$repos;
            Map.Entry item$iv$iv;
            entry = item$iv$iv = (Map.Entry)object.next();
            collection = destination$iv$iv2;
            boolean bl6 = false;
            void var17_27 = $dstr$branchName$repos;
            boolean bl7 = false;
            String branchName = (String)var17_27.getKey();
            var17_27 = $dstr$branchName$repos;
            bl7 = false;
            List repos = (List)var17_27.getValue();
            branchInfo = new BranchInfo(branchName, false, repos);
            collection.add(branchInfo);
        }
        List remote = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)local, (Iterable)remote);
    }

    private static final List<BranchInfo> sort(HashSet<BranchInfo> branches2) {
        return CollectionsKt.sortedWith((Iterable)branches2, (Comparator)sort.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<BranchInfo> checkBranchesSynchronously(VcsProjectLog log, Collection<BranchInfo> branchesToCheck, ProgressIndicator indicator) {
        Set<Integer> myCommits = GitCleanupBranchesActionKt.findMyCommits(log);
        if (myCommits == null) {
            return null;
        }
        indicator.setIndeterminate(false);
        boolean bl = false;
        List branches2 = new ArrayList();
        bl = false;
        for (BranchInfo branch : (Iterable)branchesToCheck) {
            void step;
            indicator.setFraction((double)step / (double)branchesToCheck.size());
            for (GitRepository repo : branch.getRepositories()) {
                indicator.checkCanceled();
                if (!GitCleanupBranchesActionKt.isMyBranch(log, branch.getBranchName(), repo, myCommits)) continue;
                branches2.add(branch);
            }
            ++step;
        }
        return branches2;
    }

    @Nullable
    public static final Set<Integer> findMyCommits(@NotNull VcsProjectLog log) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Collection collection = CollectionsKt.listOf((Object)"me");
        VcsLogData vcsLogData = log.getDataManager();
        if (vcsLogData == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogData, (String)"log.dataManager!!");
        VcsLogUserFilter filterByMe = VcsLogFilterObject.fromUserNames((Collection)collection, (VcsLogData)vcsLogData);
        VcsLogData vcsLogData2 = log.getDataManager();
        if (vcsLogData2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogData2, (String)"log.dataManager!!");
        VcsLogIndex vcsLogIndex = vcsLogData2.getIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogIndex, (String)"log.dataManager!!.index");
        IndexDataGetter indexDataGetter = vcsLogIndex.getDataGetter();
        if (indexDataGetter == null) {
            Intrinsics.throwNpe();
        }
        return indexDataGetter.filter(CollectionsKt.listOf((Object)filterByMe));
    }

    private static final boolean isMyBranch(VcsProjectLog log, String branchName, GitRepository repo, Set<Integer> myCommits) {
        TIntHashSet tIntHashSet = GitCleanupBranchesActionKt.findExclusiveCommits(log, branchName, repo);
        if (tIntHashSet == null) {
            return false;
        }
        TIntHashSet exclusiveCommits = tIntHashSet;
        if (exclusiveCommits.isEmpty()) {
            return false;
        }
        for (int commit2 : exclusiveCommits) {
            if (myCommits.contains(commit2)) continue;
            StringBuilder stringBuilder = new StringBuilder().append("Commit ");
            VcsLogData vcsLogData = log.getDataManager();
            if (vcsLogData == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogData, (String)"log.dataManager!!");
            LOG.debug(stringBuilder.append(vcsLogData.getStorage().getCommitId(commit2)).append(" is not mine").toString());
            return false;
        }
        return true;
    }

    private static final TIntHashSet findExclusiveCommits(VcsProjectLog log, String branchName, GitRepository repo) {
        VcsLogData vcsLogData = log.getDataManager();
        if (vcsLogData == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogData, (String)"log.dataManager!!");
        DataPack dataPack = vcsLogData.getDataPack();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataPack, (String)"log.dataManager!!.dataPack");
        DataPack dataPack2 = dataPack;
        PermanentGraph permanentGraph = dataPack2.getPermanentGraph();
        if (permanentGraph == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl<kotlin.Int>");
        }
        PermanentGraphImpl permanentGraph2 = (PermanentGraphImpl)permanentGraph;
        VcsLogData vcsLogData2 = log.getDataManager();
        if (vcsLogData2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogData2, (String)"log.dataManager!!");
        VcsLogStorage vcsLogStorage = vcsLogData2.getStorage();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogStorage, (String)"log.dataManager!!.storage");
        VcsLogStorage storage = vcsLogStorage;
        RefsModel refsModel = dataPack2.getRefsModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)refsModel, (String)"dataPack.refsModel");
        VirtualFile virtualFile = repo.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"repo.root");
        VcsRef vcsRef = DataPackUtilKt.findBranch((RefsModel)refsModel, (String)branchName, (VirtualFile)virtualFile);
        if (vcsRef == null) {
            return null;
        }
        VcsRef ref = vcsRef;
        VcsRefType vcsRefType = ref.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsRefType, (String)"ref.type");
        if (!vcsRefType.isBranch()) {
            return null;
        }
        int branchRefIndex = storage.getCommitIndex(ref.getCommitHash(), ref.getRoot());
        int branchNodeId = permanentGraph2.getPermanentCommitsInfo().getNodeId((Object)branchRefIndex);
        TIntHashSet exclusiveCommits = new TIntHashSet();
        Collection collection = CollectionsKt.listOf((Object)branchNodeId);
        PermanentLinearGraphImpl permanentLinearGraphImpl = permanentGraph2.getLinearGraph();
        Intrinsics.checkExpressionValueIsNotNull((Object)permanentLinearGraphImpl, (String)"permanentGraph.linearGraph");
        new DfsWalk(collection, (LinearGraph)permanentLinearGraphImpl).walk(true, (Function1)new Function1<Integer, Boolean>(permanentGraph2, branchNodeId, branchName, exclusiveCommits){
            final /* synthetic */ PermanentGraphImpl $permanentGraph;
            final /* synthetic */ int $branchNodeId;
            final /* synthetic */ String $branchName;
            final /* synthetic */ TIntHashSet $exclusiveCommits;

            public final boolean invoke(int node) {
                boolean bl;
                LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph((LinearGraph)((LinearGraph)this.$permanentGraph.getLinearGraph()));
                Intrinsics.checkExpressionValueIsNotNull((Object)liteLinearGraph, (String)"LinearGraphUtils.asLiteL\u2026rmanentGraph.linearGraph)");
                ReachableNodes reachableNodes = new ReachableNodes(liteLinearGraph);
                Set set = this.$permanentGraph.getBranchNodeIds();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"permanentGraph.branchNodeIds");
                Set containingBranchesIndexes = reachableNodes.getContainingBranches(node, (Collection)set);
                if (!containingBranchesIndexes.contains(this.$branchNodeId)) {
                    GitCleanupBranchesActionKt.access$getLOG$p().error("The branch " + this.$branchName + " doesn't contain commit reachable from it");
                }
                if (containingBranchesIndexes.size() > 1) {
                    bl = false;
                } else {
                    Object object = this.$permanentGraph.getPermanentCommitsInfo().getCommitId(node);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"permanentGraph.permanent\u2026itsInfo.getCommitId(node)");
                    int commitId = ((Number)object).intValue();
                    this.$exclusiveCommits.add(commitId);
                    bl = true;
                }
                return bl;
            }
            {
                this.$permanentGraph = permanentGraphImpl;
                this.$branchNodeId = n;
                this.$branchName = string;
                this.$exclusiveCommits = tIntHashSet;
                super(1);
            }
        });
        return exclusiveCommits;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitCleanupBranchesAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        DataKey dataKey = DataKey.create((String)"GitBranchKey");
        Intrinsics.checkExpressionValueIsNotNull((Object)dataKey, (String)"DataKey.create<BranchInfo>(\"GitBranchKey\")");
        GIT_BRANCH = dataKey;
    }

    public static final /* synthetic */ List access$getAllBranches(Project project) {
        return GitCleanupBranchesActionKt.getAllBranches(project);
    }

    public static final /* synthetic */ List access$checkBranchesSynchronously(VcsProjectLog log, Collection branchesToCheck, ProgressIndicator indicator) {
        return GitCleanupBranchesActionKt.checkBranchesSynchronously(log, branchesToCheck, indicator);
    }

    public static final /* synthetic */ List access$sort(HashSet branches2) {
        return GitCleanupBranchesActionKt.sort(branches2);
    }

    public static final /* synthetic */ DataKey access$getGIT_BRANCH$p() {
        return GIT_BRANCH;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

