/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.IronPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateBinaryStubsFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(GenerateBinaryStubsFix.class);
    private final String myQualifiedName;
    private final Sdk mySdk;

    @NotNull
    public static Collection<GenerateBinaryStubsFix> generateFixes(@NotNull PyImportStatementBase importStatementBase) {
        QualifiedName qName;
        if (importStatementBase == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(0);
        }
        List<String> names = importStatementBase.getFullyQualifiedObjectNames();
        ArrayList<GenerateBinaryStubsFix> result = new ArrayList<GenerateBinaryStubsFix>(names.size());
        if (importStatementBase instanceof PyFromImportStatement && names.isEmpty() && (qName = ((PyFromImportStatement)importStatementBase).getImportSourceQName()) != null) {
            result.add(new GenerateBinaryStubsFix(importStatementBase, qName.toString()));
        }
        for (String qualifiedName : names) {
            result.add(new GenerateBinaryStubsFix(importStatementBase, qualifiedName));
        }
        ArrayList<GenerateBinaryStubsFix> arrayList = result;
        if (arrayList == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private GenerateBinaryStubsFix(@NotNull PyImportStatementBase importStatementBase, @NotNull String qualifiedName) {
        if (importStatementBase == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(2);
        }
        if (qualifiedName == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(3);
        }
        this.myQualifiedName = qualifiedName;
        this.mySdk = GenerateBinaryStubsFix.getPythonSdk((PsiElement)importStatementBase);
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("sdk.gen.stubs.for.binary.modules", this.myQualifiedName);
        if (string == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Generate binary stubs" == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(5);
        }
        return "Generate binary stubs";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(7);
        }
        PsiFile file = descriptor2.getPsiElement().getContainingFile();
        Task.Backgroundable backgroundable = this.getFixTask(file);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(backgroundable, (ProgressIndicator)new BackgroundableProcessIndicator(backgroundable));
    }

    @NotNull
    public Task.Backgroundable getFixTask(final @NotNull PsiFile fileToRunTaskIn) {
        if (fileToRunTaskIn == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(8);
        }
        final Project project = fileToRunTaskIn.getProject();
        final String folder = fileToRunTaskIn.getContainingDirectory().getVirtualFile().getCanonicalPath();
        Task.Backgroundable backgroundable = new Task.Backgroundable(project, "Generating skeletons for binary module", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                List assemblyRefs = (List)ReadAction.compute(() -> GenerateBinaryStubsFix.this.collectAssemblyReferences(fileToRunTaskIn));
                try {
                    VirtualFile skeletonDir;
                    PySkeletonRefresher refresher = new PySkeletonRefresher(project, null, GenerateBinaryStubsFix.this.mySdk, null, null, folder);
                    if (GenerateBinaryStubsFix.needBinaryList(GenerateBinaryStubsFix.this.myQualifiedName)) {
                        if (!GenerateBinaryStubsFix.this.generateSkeletonsForList(refresher, indicator, folder)) {
                            return;
                        }
                    } else {
                        refresher.generateSkeleton(GenerateBinaryStubsFix.this.myQualifiedName, "", assemblyRefs, (Consumer<Boolean>)Consumer.EMPTY_CONSUMER);
                    }
                    if ((skeletonDir = LocalFileSystem.getInstance().findFileByPath(refresher.getSkeletonsPath())) != null) {
                        skeletonDir.refresh(true, true);
                    }
                }
                catch (InvalidSdkException e) {
                    LOG.error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix$1", "run"));
            }
        };
        if (backgroundable == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(9);
        }
        return backgroundable;
    }

    private boolean generateSkeletonsForList(@NotNull PySkeletonRefresher refresher, ProgressIndicator indicator, @Nullable String currentBinaryFilesPath) throws InvalidSdkException {
        if (refresher == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(10);
        }
        PySkeletonGenerator generator = new PySkeletonGenerator(refresher.getSkeletonsPath(), this.mySdk, currentBinaryFilesPath);
        indicator.setIndeterminate(false);
        String homePath = this.mySdk.getHomePath();
        if (homePath == null) {
            return false;
        }
        GeneralCommandLine cmd = PythonHelper.EXTRA_SYSPATH.newCommandLine(homePath, (List<String>)Lists.newArrayList((Object[])new String[]{this.myQualifiedName}));
        ProcessOutput runResult = PySdkUtil.getProcessOutput(cmd, new File(homePath).getParent(), PythonSdkType.activateVirtualEnv(this.mySdk), 5000);
        if (runResult.getExitCode() == 0 && !runResult.isTimeout()) {
            String extraPath = runResult.getStdout();
            PySkeletonGenerator.ListBinariesResult binaries = generator.listBinaries(this.mySdk, extraPath);
            ArrayList names = Lists.newArrayList(binaries.modules.keySet());
            Collections.sort(names);
            int size = names.size();
            for (int i = 0; i != size; ++i) {
                String name = (String)names.get(i);
                indicator.setFraction((double)i / (double)size);
                if (!GenerateBinaryStubsFix.needBinaryList(name)) continue;
                indicator.setText2(name);
                PySkeletonRefresher.PyBinaryItem item = binaries.modules.get(name);
                String modulePath = item != null ? item.getPath() : "";
                refresher.generateSkeleton(name, modulePath, new ArrayList<String>(), (Consumer<Boolean>)Consumer.EMPTY_CONSUMER);
            }
        }
        return true;
    }

    private static boolean needBinaryList(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(11);
        }
        return qualifiedName.startsWith("gi.repository");
    }

    private List<String> collectAssemblyReferences(PsiFile file) {
        if (!(PythonSdkFlavor.getFlavor(this.mySdk) instanceof IronPythonSdkFlavor)) {
            return Collections.emptyList();
        }
        final ArrayList<String> result = new ArrayList<String>();
        file.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                PyExpression[] args;
                super.visitPyCallExpression(node);
                if (node.isCalleeText("AddReference", "AddReferenceByPartialName", "AddReferenceByName") && (args = node.getArguments()).length == 1 && args[0] instanceof PyStringLiteralExpression) {
                    result.add(((PyStringLiteralExpression)args[0]).getStringValue());
                }
            }
        });
        return result;
    }

    public static boolean isApplicable(@NotNull PyImportStatementBase importStatementBase) {
        if (importStatementBase == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(12);
        }
        if (!(!importStatementBase.getFullyQualifiedObjectNames().isEmpty() || importStatementBase instanceof PyFromImportStatement && ((PyFromImportStatement)importStatementBase).isStarImport())) {
            return false;
        }
        Sdk sdk = GenerateBinaryStubsFix.getPythonSdk((PsiElement)importStatementBase);
        if (sdk == null) {
            return false;
        }
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdk);
        if (flavor instanceof IronPythonSdkFlavor) {
            return true;
        }
        return GenerateBinaryStubsFix.isGtk(importStatementBase);
    }

    private static boolean isGtk(@NotNull PyImportStatementBase importStatementBase) {
        QualifiedName qName;
        if (importStatementBase == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(13);
        }
        return importStatementBase instanceof PyFromImportStatement && (qName = ((PyFromImportStatement)importStatementBase).getImportSourceQName()) != null && qName.matches(new String[]{"gi", "repository"});
    }

    @Nullable
    private static Sdk getPythonSdk(@NotNull PsiElement element) {
        Module module2;
        if (element == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(14);
        }
        return (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null ? null : PythonSdkType.findPythonSdk(module2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatementBase";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToRunTaskIn";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFixes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateFixes";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFixTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateSkeletonsForList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "needBinaryList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isGtk";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPythonSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

