/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.diagnostic.LoadingPhase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KeymapManager {
    public static final String DEFAULT_IDEA_KEYMAP = "$default";
    public static final String MAC_OS_X_KEYMAP = "Mac OS X";
    public static final String MAC_OS_X_10_5_PLUS_KEYMAP = "Mac OS X 10.5+";
    public static final String X_WINDOW_KEYMAP = "Default for XWin";
    public static final String KDE_KEYMAP = "Default for KDE";
    public static final String GNOME_KEYMAP = "Default for GNOME";
    private static volatile KeymapManager INSTANCE;

    @NotNull
    public abstract Keymap getActiveKeymap();

    @Nullable
    public abstract Keymap getKeymap(@NotNull String var1);

    public static KeymapManager getInstance() {
        Application application = ApplicationManager.getApplication();
        if (application == null || !LoadingPhase.isComplete((LoadingPhase)LoadingPhase.CONFIGURATION_STORE_INITIALIZED)) {
            return null;
        }
        KeymapManager instance = INSTANCE;
        if (instance == null) {
            INSTANCE = instance = application.getComponent(KeymapManager.class);
        }
        return instance;
    }

    @Deprecated
    public abstract void addKeymapManagerListener(@NotNull KeymapManagerListener var1);

    @Deprecated
    public abstract void addKeymapManagerListener(@NotNull KeymapManagerListener var1, @NotNull Disposable var2);

    @Deprecated
    public abstract void removeKeymapManagerListener(@NotNull KeymapManagerListener var1);
}

