/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateLanguage;

public class TextMateFileType
extends LanguageFileType
implements PlainTextLikeFileType,
FileTypeIdentifiableByVirtualFile {
    public static final TextMateFileType INSTANCE = new TextMateFileType();

    private TextMateFileType() {
        super((Language)TextMateLanguage.LANGUAGE);
    }

    @NotNull
    public String getName() {
        if ("textmate" == null) {
            TextMateFileType.$$$reportNull$$$0(0);
        }
        return "textmate";
    }

    @NotNull
    public String getDescription() {
        if ("Files supported via TextMate bundles" == null) {
            TextMateFileType.$$$reportNull$$$0(1);
        }
        return "Files supported via TextMate bundles";
    }

    @NotNull
    public String getDefaultExtension() {
        if ("" == null) {
            TextMateFileType.$$$reportNull$$$0(2);
        }
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        if (file == null) {
            TextMateFileType.$$$reportNull$$$0(3);
        }
        CharSequence fileName = file.getNameSequence();
        FileType originalFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (!TextMateFileType.isTypeShouldBeReplacedByTextMateType(originalFileType)) {
            return false;
        }
        return TextMateService.getInstance().getLanguageDescriptorByFileName(fileName) != null;
    }

    private static boolean isTypeShouldBeReplacedByTextMateType(@Nullable FileType registeredType) {
        return registeredType == UnknownFileType.INSTANCE || registeredType == INSTANCE || registeredType == PlainTextFileType.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/TextMateFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/TextMateFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMyFileType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

