/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpPyCondRef;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpLanguageHosts
extends ClassExtension<RegExpLanguageHost> {
    private static final RegExpLanguageHosts INSTANCE = new RegExpLanguageHosts();
    private final DefaultRegExpPropertiesProvider myDefaultProvider = DefaultRegExpPropertiesProvider.getInstance();

    public static RegExpLanguageHosts getInstance() {
        return INSTANCE;
    }

    private RegExpLanguageHosts() {
        super("com.intellij.regExpLanguageHost");
    }

    @Contract(value="null -> null")
    @Nullable
    private static RegExpLanguageHost findRegExpHost(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        PsiElement context = file2.getContext();
        if (context instanceof RegExpLanguageHost) {
            return (RegExpLanguageHost)context;
        }
        if (context != null) {
            return (RegExpLanguageHost)INSTANCE.forClass(context.getClass());
        }
        return null;
    }

    public boolean isRedundantEscape(@NotNull RegExpChar ch, @NotNull String text2) {
        if (ch == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(1);
        }
        if (text2.length() <= 1) {
            return false;
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ch);
        if (host != null) {
            char c2 = text2.charAt(1);
            return !host.characterNeedsEscaping(c2);
        }
        return !"\\]".equals(text2) && !"\\}".equals(text2);
    }

    public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        return host == null || host.supportsInlineOptionFlag(flag, context);
    }

    public boolean supportsExtendedHexCharacter(@Nullable RegExpChar regExpChar) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(regExpChar);
        try {
            return host != null && host.supportsExtendedHexCharacter(regExpChar);
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    public boolean supportsLiteralBackspace(@Nullable RegExpChar regExpChar) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(regExpChar);
        return host != null && host.supportsLiteralBackspace(regExpChar);
    }

    public boolean supportsPropertySyntax(@NotNull PsiElement context) {
        RegExpLanguageHost host;
        if (context == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(2);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(context)) != null && host.supportsPropertySyntax(context);
    }

    public boolean supportsNamedGroupSyntax(@Nullable RegExpGroup group) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group);
        return host != null && host.supportsNamedGroupSyntax(group);
    }

    public boolean supportsNamedGroupRefSyntax(@Nullable RegExpNamedGroupRef ref) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ref);
        try {
            return host != null && host.supportsNamedGroupRefSyntax(ref);
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    public Collection<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        if (host == null) {
            return Collections.emptySet();
        }
        return host.getSupportedNamedGroupTypes(context);
    }

    public boolean isValidGroupName(String name, @Nullable RegExpGroup group) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group);
        return host != null && host.isValidGroupName(name, group);
    }

    public boolean supportsPerl5EmbeddedComments(@Nullable PsiComment comment) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost((PsiElement)comment);
        return host != null && host.supportsPerl5EmbeddedComments();
    }

    public boolean supportsPythonConditionalRefs(@Nullable RegExpPyCondRef condRef) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(condRef);
        return host != null && host.supportsPythonConditionalRefs();
    }

    public boolean supportsPossessiveQuantifiers(@Nullable RegExpElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        return host == null || host.supportsPossessiveQuantifiers();
    }

    public boolean supportsBoundary(@Nullable RegExpBoundary boundary) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(boundary);
        return host == null || host.supportsBoundary(boundary);
    }

    public boolean supportsSimpleClass(@Nullable RegExpSimpleClass simpleClass) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(simpleClass);
        return host == null || host.supportsSimpleClass(simpleClass);
    }

    public boolean isValidCategory(@NotNull PsiElement element, @NotNull String category) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(3);
        }
        if (category == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(4);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element)) != null ? host.isValidCategory(category) : this.myDefaultProvider.isValidCategory(category);
    }

    public boolean isValidPropertyValue(@NotNull PsiElement element, @NotNull String propertyName, @NotNull String propertyValue) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(5);
        }
        if (propertyName == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(6);
        }
        if (propertyValue == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(7);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element)) == null || host.isValidPropertyValue(propertyName, propertyValue);
    }

    public boolean supportsNamedCharacters(@NotNull RegExpNamedCharacter namedCharacter) {
        RegExpLanguageHost host;
        if (namedCharacter == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(8);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(namedCharacter)) != null && host.supportsNamedCharacters(namedCharacter);
    }

    public boolean isValidNamedCharacter(@NotNull RegExpNamedCharacter namedCharacter) {
        RegExpLanguageHost host;
        if (namedCharacter == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(9);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(namedCharacter)) != null && host.isValidNamedCharacter(namedCharacter);
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(RegExpGroup group) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group);
        if (host == null) {
            return RegExpLanguageHost.Lookbehind.FULL;
        }
        return host.supportsLookbehind(group);
    }

    @Nullable
    public Number getQuantifierValue(@NotNull RegExpNumber valueElement) {
        RegExpLanguageHost host;
        if (valueElement == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(10);
        }
        if ((host = RegExpLanguageHosts.findRegExpHost(valueElement)) == null) {
            return Double.valueOf(valueElement.getText());
        }
        return host.getQuantifierValue(valueElement);
    }

    @NotNull
    public String[][] getAllKnownProperties(@NotNull PsiElement element) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(11);
        }
        String[][] stringArray = (host = RegExpLanguageHosts.findRegExpHost(element)) != null ? host.getAllKnownProperties() : this.myDefaultProvider.getAllKnownProperties();
        if (stringArray == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(12);
        }
        return stringArray;
    }

    @NotNull
    public String[][] getAllPropertyValues(@NotNull PsiElement element, @NotNull String propertyName) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(13);
        }
        if (propertyName == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(14);
        }
        String[][] stringArray = (host = RegExpLanguageHosts.findRegExpHost(element)) != null ? host.getAllPropertyValues(propertyName) : RegExpLanguageHost.EMPTY_COMPLETION_ITEMS_ARRAY;
        if (stringArray == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    @Nullable
    String getPropertyDescription(@NotNull PsiElement element, @Nullable String name) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(16);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element)) != null ? host.getPropertyDescription(name) : this.myDefaultProvider.getPropertyDescription(name);
    }

    @NotNull
    String[][] getKnownCharacterClasses(@NotNull PsiElement element) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(17);
        }
        String[][] stringArray = (host = RegExpLanguageHosts.findRegExpHost(element)) != null ? host.getKnownCharacterClasses() : this.myDefaultProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    String[][] getPosixCharacterClasses(@NotNull PsiElement element) {
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(19);
        }
        return this.myDefaultProvider.getPosixCharacterClasses();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedCharacter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/RegExpLanguageHosts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/RegExpLanguageHosts";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKnownProperties";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertyValues";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownCharacterClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRedundantEscape";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportsPropertySyntax";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "supportsNamedCharacters";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValidNamedCharacter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllKnownProperties";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllPropertyValues";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescription";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getKnownCharacterClasses";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPosixCharacterClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

