/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.jediterm.terminal.ui.TerminalPanel;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalEscapeKeyListener {
    private final TerminalPanel myTerminalPanel;
    private final AnAction myTerminalSwitchFocusToEditorAction;
    private boolean myShortcutPressed;

    public TerminalEscapeKeyListener(@NotNull TerminalPanel terminalPanel) {
        if (terminalPanel == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(0);
        }
        this.myShortcutPressed = false;
        this.myTerminalPanel = terminalPanel;
        this.myTerminalSwitchFocusToEditorAction = ActionManager.getInstance().getAction("Terminal.SwitchFocusToEditor");
    }

    public void handleKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(1);
        }
        if (e.getID() == 401) {
            this.myShortcutPressed = this.isMatched(e);
        } else if (e.getID() == 402) {
            if (this.myShortcutPressed && this.isMatched(e)) {
                this.switchFocusToEditorIfSuitable();
            }
            this.myShortcutPressed = false;
        }
    }

    private boolean isMatched(@NotNull KeyEvent e) {
        KeyStroke stroke;
        if (e == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(2);
        }
        return (stroke = this.getKeyStroke()) != null && stroke.getKeyCode() == e.getKeyCode() && stroke.getModifiers() == (e.getModifiers() | e.getModifiersEx());
    }

    @Nullable
    private KeyStroke getKeyStroke() {
        if (this.myTerminalSwitchFocusToEditorAction == null) {
            return null;
        }
        return KeymapUtil.getKeyStroke((ShortcutSet)this.myTerminalSwitchFocusToEditorAction.getShortcutSet());
    }

    private void switchFocusToEditorIfSuitable() {
        DataContext dataContext;
        Project project;
        if (!this.myTerminalPanel.getTerminalTextBuffer().isUsingAlternateBuffer() && (project = (Project)(dataContext = DataManager.getInstance().getDataContext((Component)this.myTerminalPanel)).getData(CommonDataKeys.PROJECT)) != null && !project.isDisposed()) {
            if (TerminalEscapeKeyListener.isTerminalToolWindow((ToolWindow)dataContext.getData(PlatformDataKeys.TOOL_WINDOW)) && !Registry.is((String)"terminal.escape.moves.focus.to.editor")) {
                return;
            }
            ToolWindowManager.getInstance((Project)project).activateEditorComponent();
        }
    }

    private static boolean isTerminalToolWindow(@Nullable ToolWindow toolWindow) {
        return toolWindow instanceof ToolWindowImpl && "Terminal".equals(((ToolWindowImpl)toolWindow).getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/terminal/TerminalEscapeKeyListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleKeyEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isMatched";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

