/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.wizard;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalModuleBuilder<S extends ExternalProjectSettings>
extends ModuleBuilder {
    @NotNull
    private final Icon myIcon;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final S myExternalProjectSettings;

    protected AbstractExternalModuleBuilder(@NotNull ProjectSystemId externalSystemId, @NotNull S externalProjectSettings) {
        if (externalSystemId == null) {
            AbstractExternalModuleBuilder.$$$reportNull$$$0(0);
        }
        if (externalProjectSettings == null) {
            AbstractExternalModuleBuilder.$$$reportNull$$$0(1);
        }
        this.myExternalSystemId = externalSystemId;
        this.myExternalProjectSettings = externalProjectSettings;
        externalProjectSettings.setupNewProjectDefault();
        Icon icon = ExternalSystemUiUtil.getUiAware(externalSystemId).getProjectIcon();
        this.myIcon = icon == null ? super.getNodeIcon() : icon;
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model2) {
        if (project == null) {
            AbstractExternalModuleBuilder.$$$reportNull$$$0(2);
        }
        ExternalProjectsManagerImpl.disableProjectWatcherAutoUpdate(project);
        return super.commitModule(project, model2);
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return this.myExternalSystemId.getReadableName();
    }

    public String getDescription() {
        return ExternalSystemBundle.message((String)"module.type.description", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
    }

    public Icon getNodeIcon() {
        return this.myIcon;
    }

    @NotNull
    public S getExternalProjectSettings() {
        S s = this.myExternalProjectSettings;
        if (s == null) {
            AbstractExternalModuleBuilder.$$$reportNull$$$0(3);
        }
        return s;
    }

    @Nullable
    public Project createProject(String name, String path) {
        Project project = super.createProject(name, path);
        if (project != null) {
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalModuleBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalModuleBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "commitModule";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

