/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.StringEscapesTokenTypes;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class ToggleCaseAction
extends TextComponentEditorAction {
    public ToggleCaseAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            Ref toLowerCase = new Ref((Object)Boolean.FALSE);
            Handler.runForCaret(editor, caret, c2 -> {
                if (!c2.hasSelection()) {
                    c2.selectWordAtCaret(true);
                }
                int selectionStartOffset = c2.getSelectionStart();
                int selectionEndOffset = c2.getSelectionEnd();
                String originalText = editor.getDocument().getText(new TextRange(selectionStartOffset, selectionEndOffset));
                if (!originalText.equals(Handler.toCase(editor, selectionStartOffset, selectionEndOffset, true))) {
                    toLowerCase.set((Object)Boolean.TRUE);
                }
            });
            Handler.runForCaret(editor, caret, c2 -> {
                VisualPosition caretPosition = c2.getVisualPosition();
                int selectionStartOffset = c2.getSelectionStart();
                int selectionEndOffset = c2.getSelectionEnd();
                VisualPosition selectionStartPosition = c2.getSelectionStartPosition();
                VisualPosition selectionEndPosition = c2.getSelectionEndPosition();
                c2.removeSelection();
                editor.getDocument().replaceString(selectionStartOffset, selectionEndOffset, (CharSequence)Handler.toCase(editor, selectionStartOffset, selectionEndOffset, (Boolean)toLowerCase.get()));
                c2.moveToVisualPosition(caretPosition);
                c2.setSelection(selectionStartPosition, selectionStartOffset, selectionEndPosition, selectionEndOffset);
            });
        }

        private static void runForCaret(Editor editor, Caret caret, CaretAction action2) {
            if (caret == null) {
                editor.getCaretModel().runForEachCaret(action2);
            } else {
                action2.perform(caret);
            }
        }

        private static String toCase(Editor editor, int startOffset, int endOffset, boolean lower) {
            EditorHighlighter highlighter;
            CharSequence text2 = editor.getDocument().getImmutableCharSequence();
            if (editor instanceof EditorEx) {
                highlighter = ((EditorEx)editor).getHighlighter();
            } else {
                highlighter = new EmptyEditorHighlighter(null);
                highlighter.setText(text2);
            }
            HighlighterIterator iterator = highlighter.createIterator(startOffset);
            StringBuilder builder2 = new StringBuilder(endOffset - startOffset);
            while (!iterator.atEnd()) {
                int start2 = Handler.trim(iterator.getStart(), startOffset, endOffset);
                int end = Handler.trim(iterator.getEnd(), startOffset, endOffset);
                CharSequence fragment = text2.subSequence(start2, end);
                builder2.append(iterator.getTokenType() == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN ? fragment : (lower ? fragment.toString().toLowerCase(Locale.getDefault()) : fragment.toString().toUpperCase(Locale.getDefault())));
                if (end == endOffset) break;
                iterator.advance();
            }
            return builder2.toString();
        }

        private static int trim(int value, int lowerLimit, int upperLimit) {
            return Math.min(upperLimit, Math.max(lowerLimit, value));
        }
    }
}

