/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileDocumentManagerImpl
extends FileDocumentManager {
    private static final Key<VirtualFile> MOCK_VIRTUAL_FILE_KEY = Key.create((String)"MockVirtualFile");
    private final Function<? super CharSequence, ? extends Document> myFactory;
    @Nullable
    private final Key<Document> myCachedDocumentKey;
    private static final Key<Document> MOCK_DOC_KEY = Key.create((String)"MOCK_DOC_KEY");

    public MockFileDocumentManagerImpl(Function<? super CharSequence, ? extends Document> factory, @Nullable Key<Document> cachedDocumentKey) {
        this.myFactory = factory;
        this.myCachedDocumentKey = cachedDocumentKey;
    }

    private static boolean isBinaryWithoutDecompiler(VirtualFile file2) {
        FileType ft = file2.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) == null;
    }

    public Document getDocument(@NotNull VirtualFile file2) {
        Document document;
        if (file2 == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(0);
        }
        if ((document = (Document)file2.getUserData(MOCK_DOC_KEY)) == null) {
            if (file2.isDirectory() || MockFileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                return null;
            }
            CharSequence text2 = LoadTextUtil.loadText(file2);
            document = (Document)this.myFactory.fun((Object)text2);
            document.putUserData(MOCK_VIRTUAL_FILE_KEY, (Object)file2);
            document = (Document)file2.putUserDataIfAbsent(MOCK_DOC_KEY, (Object)document);
        }
        return document;
    }

    public Document getCachedDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.myCachedDocumentKey != null) {
            return (Document)file2.getUserData(this.myCachedDocumentKey);
        }
        return null;
    }

    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(2);
        }
        return (VirtualFile)document.getUserData(MOCK_VIRTUAL_FILE_KEY);
    }

    public void saveAllDocuments() {
    }

    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(3);
        }
    }

    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public Document[] getUnsavedDocuments() {
        if (Document.EMPTY_ARRAY == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(5);
        }
        return Document.EMPTY_ARRAY;
    }

    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(6);
        }
        return false;
    }

    public boolean isFileModified(@NotNull VirtualFile file2) {
        if (file2 == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(7);
        }
        return false;
    }

    public boolean isPartialPreviewOfALargeFile(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(8);
        }
        return false;
    }

    public void reloadFromDisk(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(9);
        }
    }

    public void reloadFiles(VirtualFile ... files2) {
        if (files2 == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(10);
        }
    }

    @NotNull
    public String getLineSeparator(VirtualFile file2, Project project) {
        if ("" == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(11);
        }
        return "";
    }

    public boolean requestWriting(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(12);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockFileDocumentManagerImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockFileDocumentManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentAsIs";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentUnsaved";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFileModified";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPartialPreviewOfALargeFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reloadFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

