/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.internal.statistic.collectors.fus.project.ProjectFsStatsCollector;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.project.ProjectKt;
import com.intellij.ui.GuiUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import java.io.FileNotFoundException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class StartupManagerImpl
extends StartupManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.impl.StartupManagerImpl");
    private static final long EDT_WARN_THRESHOLD_IN_NANO = TimeUnit.MILLISECONDS.toNanos(100L);
    private final Object myLock;
    private final Deque<Runnable> myPreStartupActivities;
    private final Deque<Runnable> myStartupActivities;
    private final Deque<Runnable> myDumbAwarePostStartupActivities;
    private final Deque<Runnable> myNotDumbAwarePostStartupActivities;
    private boolean myPostStartupActivitiesPassed;
    private volatile boolean myPreStartupActivitiesPassed;
    private volatile boolean myStartupActivitiesPassed;
    private final Project myProject;
    private boolean myInitialRefreshScheduled;
    private ScheduledFuture<?> myBackgroundPostStartupScheduledFuture;

    public StartupManagerImpl(@NotNull Project project) {
        if (project == null) {
            StartupManagerImpl.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myPreStartupActivities = new ArrayDeque<Runnable>();
        this.myStartupActivities = new ArrayDeque<Runnable>();
        this.myDumbAwarePostStartupActivities = new ArrayDeque<Runnable>();
        this.myNotDumbAwarePostStartupActivities = new ArrayDeque<Runnable>();
        this.myProject = project;
    }

    private void checkNonDefaultProject() {
        LOG.assertTrue(!this.myProject.isDefault(), (Object)"Please don't register startup activities for the default project: they won't ever be run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPreStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(1);
        }
        this.checkNonDefaultProject();
        LOG.assertTrue(!this.myPreStartupActivitiesPassed, (Object)"Registering pre startup activity that will never be run");
        Object object = this.myLock;
        synchronized (object) {
            this.myPreStartupActivities.add(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(2);
        }
        this.checkNonDefaultProject();
        LOG.assertTrue(!this.myStartupActivitiesPassed, (Object)"Registering startup activity that will never be run");
        Object object = this.myLock;
        synchronized (object) {
            this.myStartupActivities.add(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerPostStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(3);
        }
        this.checkNonDefaultProject();
        if (this.myPostStartupActivitiesPassed) {
            LOG.error("Registering post-startup activity that will never be run: disposed=" + this.myProject.isDisposed() + "; open=" + this.myProject.isOpen() + "; passed=" + this.myStartupActivitiesPassed);
        }
        Deque<Runnable> list2 = DumbService.isDumbAware((Object)runnable2) ? this.myDumbAwarePostStartupActivities : this.myNotDumbAwarePostStartupActivities;
        Object object = this.myLock;
        synchronized (object) {
            list2.add(runnable2);
        }
    }

    @Override
    public boolean startupActivityPassed() {
        return this.myStartupActivitiesPassed;
    }

    @Override
    public synchronized boolean postStartupActivityPassed() {
        return this.myPostStartupActivitiesPassed;
    }

    public void runStartupActivities() {
        ApplicationManager.getApplication().runReadAction(() -> {
            AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Running Startup Activities");
            try {
                this.runActivities(this.myPreStartupActivities, "project pre-startup");
                StartupManagerImpl startupManagerImpl = this;
                synchronized (startupManagerImpl) {
                    this.myPreStartupActivitiesPassed = true;
                }
                this.runActivities(this.myStartupActivities, "project startup");
                startupManagerImpl = this;
                synchronized (startupManagerImpl) {
                    this.myStartupActivitiesPassed = true;
                }
            }
            finally {
                token.finish();
            }
        });
    }

    public void runPostStartupActivitiesFromExtensions() {
        Activity activity;
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        Activity dumbAwareActivity = StartUpMeasurer.start((String)"project post-startup dumb-aware activities");
        AtomicReference<Object> edtActivity = new AtomicReference<Object>();
        AtomicBoolean uiFreezeWarned = new AtomicBoolean();
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        AtomicInteger counter = new AtomicInteger();
        StartupActivity.POST_STARTUP_ACTIVITY.processWithPluginDescriptor((extension, pluginDescriptor) -> {
            if (DumbService.isDumbAware((Object)extension)) {
                this.runActivity(uiFreezeWarned, (StartupActivity)extension, (PluginDescriptor)pluginDescriptor);
            } else {
                if (edtActivity.get() == null) {
                    edtActivity.set(StartUpMeasurer.start((String)"project post-startup edt activities"));
                }
                counter.incrementAndGet();
                dumbService.runWhenSmart(() -> {
                    Activity activity;
                    this.runActivity(uiFreezeWarned, (StartupActivity)extension, (PluginDescriptor)pluginDescriptor);
                    if (counter.decrementAndGet() == 0 && (activity = (Activity)edtActivity.getAndSet(null)) != null) {
                        activity.end();
                    }
                });
            }
        });
        if (counter.get() == 0 && (activity = (Activity)edtActivity.getAndSet(null)) != null) {
            activity.end();
        }
        dumbAwareActivity.end();
        snapshot.logResponsivenessSinceCreation("Post-startup activities under progress");
    }

    private void runActivity(@NotNull AtomicBoolean uiFreezeWarned, @NotNull StartupActivity extension, @NotNull PluginDescriptor pluginDescriptor) {
        Application app;
        if (uiFreezeWarned == null) {
            StartupManagerImpl.$$$reportNull$$$0(4);
        }
        if (extension == null) {
            StartupManagerImpl.$$$reportNull$$$0(5);
        }
        if (pluginDescriptor == null) {
            StartupManagerImpl.$$$reportNull$$$0(6);
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        try {
            extension.runActivity(this.myProject);
        }
        catch (ServiceNotReadyException e) {
            LOG.error((Throwable)new Exception((Throwable)((Object)e)));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        long duration = ParallelActivity.POST_STARTUP_ACTIVITY.record(startTime, extension.getClass(), null, pluginId);
        if (duration > EDT_WARN_THRESHOLD_IN_NANO && !(app = ApplicationManager.getApplication()).isUnitTestMode() && app.isDispatchThread() && uiFreezeWarned.compareAndSet(false, true)) {
            LOG.info("Some post-startup activities freeze UI for noticeable time. Please consider making them DumbAware to run them in background under modal progress, or just making them faster to speed up project opening.");
        }
    }

    public void runPostStartupActivities() {
        if (this.postStartupActivityPassed()) {
            return;
        }
        final Application app = ApplicationManager.getApplication();
        if (!app.isHeadlessEnvironment()) {
            this.checkFsSanity();
            this.checkProjectRoots();
        }
        this.runActivities(this.myDumbAwarePostStartupActivities, "project dumb post-startup");
        final DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        dumbService.runWhenSmart(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List dumbUnaware;
                app.assertIsDispatchThread();
                StartupManagerImpl.this.runActivities(StartupManagerImpl.this.myDumbAwarePostStartupActivities, "project dumb post-startup");
                while (!(dumbUnaware = StartupManagerImpl.this.takeDumbUnawareStartupActivities()).isEmpty()) {
                    for (Runnable activity : dumbUnaware) {
                        dumbService.runWhenSmart(() -> StartupManagerImpl.runActivity(activity));
                    }
                }
                if (dumbService.isDumb()) {
                    dumbService.runWhenSmart((Runnable)this);
                } else {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        StartupManagerImpl.this.myPostStartupActivitiesPassed = true;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<Runnable> takeDumbUnawareStartupActivities() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myNotDumbAwarePostStartupActivities.isEmpty()) {
            List<Runnable> list2 = Collections.emptyList();
            // MONITOREXIT : object
            if (list2 != null) return list2;
            StartupManagerImpl.$$$reportNull$$$0(7);
            return list2;
        }
        ArrayList<Runnable> result2 = new ArrayList<Runnable>(this.myNotDumbAwarePostStartupActivities);
        this.myNotDumbAwarePostStartupActivities.clear();
        ArrayList<Runnable> arrayList = result2;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        StartupManagerImpl.$$$reportNull$$$0(8);
        return arrayList;
    }

    public void scheduleInitialVfsRefresh() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed() || this.myInitialRefreshScheduled) {
                return;
            }
            this.myInitialRefreshScheduled = true;
            ProjectRootManagerEx.getInstanceEx((Project)this.myProject).markRootsForRefresh();
            Application app = ApplicationManager.getApplication();
            if (!app.isCommandLine()) {
                final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
                final MessageBusConnection connection = app.getMessageBus().connect();
                connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

                    public void afterProjectClosed(@NotNull Project project) {
                        if (project == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (project != StartupManagerImpl.this.myProject) {
                            return;
                        }
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/startup/impl/StartupManagerImpl$2", "afterProjectClosed"));
                    }
                });
            } else {
                VirtualFileManager.getInstance().syncRefresh();
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private void checkFsSanity() {
        try {
            String path = this.myProject.getProjectFilePath();
            if (path == null || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)path, (boolean)true)) {
                return;
            }
            if (ProjectKt.isDirectoryBased(this.myProject)) {
                path = PathUtil.getParentPath((String)path);
            }
            boolean expected = SystemInfo.isFileSystemCaseSensitive;
            boolean actual = FileUtil.isFileSystemCaseSensitive((String)path);
            LOG.info(path + " case-sensitivity: expected=" + expected + " actual=" + actual);
            if (actual != expected) {
                int prefix = expected ? 1 : 0;
                String title = ApplicationBundle.message((String)"fs.case.sensitivity.mismatch.title", (Object[])new Object[0]);
                String text2 = ApplicationBundle.message((String)"fs.case.sensitivity.mismatch.message", (Object[])new Object[]{prefix});
                Notifications.Bus.notify((Notification)new Notification("System Messages", title, text2, NotificationType.WARNING, NotificationListener.URL_OPENING_LISTENER), (Project)this.myProject);
            }
            ProjectFsStatsCollector.caseSensitivity(this.myProject, actual);
        }
        catch (FileNotFoundException e) {
            LOG.warn((Throwable)e);
        }
    }

    private void checkProjectRoots() {
        VirtualFile[] roots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
        if (roots.length == 0) {
            return;
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (!(fs instanceof LocalFileSystemImpl)) {
            return;
        }
        FileWatcher watcher = ((LocalFileSystemImpl)fs).getFileWatcher();
        if (!watcher.isOperational()) {
            ProjectFsStatsCollector.watchedRoots(this.myProject, -1);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            LOG.debug("FW/roots waiting started");
            while (true) {
                if (this.myProject.isDisposed()) {
                    return;
                }
                if (!watcher.isSettingRoots()) break;
                TimeoutUtil.sleep((long)10L);
            }
            LOG.debug("FW/roots waiting finished");
            Collection<String> manualWatchRoots = watcher.getManualWatchRoots();
            int pctNonWatched = 0;
            if (!manualWatchRoots.isEmpty()) {
                SmartList nonWatched = new SmartList();
                for (VirtualFile root : roots) {
                    if (!(root.getFileSystem() instanceof LocalFileSystem)) continue;
                    String rootPath = root.getPath();
                    for (String manualWatchRoot : manualWatchRoots) {
                        if (!FileUtil.isAncestor((String)manualWatchRoot, (String)rootPath, (boolean)false)) continue;
                        nonWatched.add(rootPath);
                    }
                }
                if (!nonWatched.isEmpty()) {
                    String message = ApplicationBundle.message((String)"watcher.non.watchable.project", (Object[])new Object[0]);
                    watcher.notifyOnFailure(message, null);
                    LOG.info("unwatched roots: " + nonWatched);
                    LOG.info("manual watches: " + manualWatchRoots);
                    pctNonWatched = (int)(100.0 * (double)nonWatched.size() / (double)roots.length);
                }
            }
            ProjectFsStatsCollector.watchedRoots(this.myProject, pctNonWatched);
        });
    }

    public void startCacheUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        try {
            DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                dumbService.queueTask(new DumbModeTask(){

                    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        StartupManagerImpl.this.scheduleInitialVfsRefresh();
                    }

                    public String toString() {
                        return "initial refresh";
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/startup/impl/StartupManagerImpl$3", "performInDumbMode"));
                    }
                });
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActivities(@NotNull Deque<? extends Runnable> activities, @NotNull String phaseName) {
        if (activities == null) {
            StartupManagerImpl.$$$reportNull$$$0(9);
        }
        if (phaseName == null) {
            StartupManagerImpl.$$$reportNull$$$0(10);
        }
        Activity activity = StartUpMeasurer.start((String)phaseName);
        while (true) {
            Runnable runnable2;
            Object object = this.myLock;
            synchronized (object) {
                runnable2 = activities.pollFirst();
            }
            if (runnable2 == null) break;
            long startTime = StartUpMeasurer.getCurrentTime();
            ClassLoader loader = runnable2.getClass().getClassLoader();
            String pluginId = loader instanceof PluginClassLoader ? ((PluginClassLoader)((Object)loader)).getPluginId().getIdString() : "com.intellij";
            StartupManagerImpl.runActivity(runnable2);
            ParallelActivity.POST_STARTUP_ACTIVITY.record(startTime, runnable2.getClass(), null, pluginId);
        }
        activity.end();
    }

    public void scheduleBackgroundPostStartupActivities() {
        this.myBackgroundPostStartupScheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, () -> {
            for (StartupActivity activity : StartupActivity.BACKGROUND_POST_STARTUP_ACTIVITY.getIterable()) {
                activity.runActivity(this.myProject);
            }
        }), 5L, TimeUnit.SECONDS);
    }

    public void dispose() {
        if (this.myBackgroundPostStartupScheduledFuture != null) {
            this.myBackgroundPostStartupScheduledFuture.cancel(false);
        }
    }

    public static void runActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(11);
        }
        ProgressManager.checkCanceled();
        try {
            runnable2.run();
        }
        catch (ServiceNotReadyException e) {
            LOG.error((Throwable)new Exception((Throwable)((Object)e)));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable ex) {
            LOG.error(ex);
        }
    }

    public void runWhenProjectIsInitialized(@NotNull Runnable action2) {
        Application application;
        if (action2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(12);
        }
        if ((application = ApplicationManager.getApplication()) == null) {
            return;
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            StartupManagerImpl startupManagerImpl = this;
            synchronized (startupManagerImpl) {
                boolean initialized;
                boolean bl = initialized = this.myProject.isInitialized() || this.myProject.isDefault() || this.myPostStartupActivitiesPassed && application.isUnitTestMode();
                if (!initialized) {
                    this.registerPostStartupActivity(action2);
                    return;
                }
            }
            action2.run();
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareForNextTest() {
        Object object = this.myLock;
        synchronized (object) {
            this.myPreStartupActivities.clear();
            this.myStartupActivities.clear();
            this.myDumbAwarePostStartupActivities.clear();
            this.myNotDumbAwarePostStartupActivities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkCleared() {
        try {
            Object object = this.myLock;
            synchronized (object) {
                assert (this.myStartupActivities.isEmpty()) : "Activities: " + this.myStartupActivities;
                assert (this.myDumbAwarePostStartupActivities.isEmpty()) : "DumbAware Post Activities: " + this.myDumbAwarePostStartupActivities;
                assert (this.myNotDumbAwarePostStartupActivities.isEmpty()) : "Post Activities: " + this.myNotDumbAwarePostStartupActivities;
                assert (this.myPreStartupActivities.isEmpty()) : "Pre Activities: " + this.myPreStartupActivities;
            }
        }
        finally {
            this.prepareForNextTest();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiFreezeWarned";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/startup/impl/StartupManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activities";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phaseName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/startup/impl/StartupManagerImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "takeDumbUnawareStartupActivities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerPreStartupActivity";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerStartupActivity";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerPostStartupActivity";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runActivities";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runWhenProjectIsInitialized";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

