/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleConfigurable;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldLinesLikeThis
extends DumbAwareAction {
    @Nullable
    private static String getSingleLineSelection(@NotNull Editor editor) {
        String selection;
        if (editor == null) {
            FoldLinesLikeThis.$$$reportNull$$$0(0);
        }
        SelectionModel model2 = editor.getSelectionModel();
        Document document = editor.getDocument();
        if (!model2.hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            if (offset <= document.getTextLength()) {
                int lineNumber = document.getLineNumber(offset);
                String line2 = document.getText().substring(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)).trim();
                if (StringUtil.isNotEmpty((String)line2)) {
                    return line2;
                }
            }
            return null;
        }
        int start2 = model2.getSelectionStart();
        int end = model2.getSelectionEnd();
        if (document.getLineNumber(start2) == document.getLineNumber(end) && StringUtil.isNotEmpty((String)(selection = document.getText().substring(start2, end).trim()))) {
            return selection;
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FoldLinesLikeThis.$$$reportNull$$$0(1);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        boolean enabled = e.getData(LangDataKeys.CONSOLE_VIEW) != null && editor != null && FoldLinesLikeThis.getSingleLineSelection(editor) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FoldLinesLikeThis.$$$reportNull$$$0(2);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        assert (editor != null);
        final String selection = FoldLinesLikeThis.getSingleLineSelection(editor);
        assert (selection != null);
        ShowSettingsUtil.getInstance().editConfigurable(editor.getProject(), (Configurable)new ConsoleConfigurable(){

            @Override
            protected boolean editFoldingsOnly() {
                return true;
            }

            @Override
            public void reset() {
                super.reset();
                UIUtil.invokeLaterIfNeeded(() -> this.addRule(selection));
            }
        });
        ConsoleView consoleView = (ConsoleView)e.getData(LangDataKeys.CONSOLE_VIEW);
        if (consoleView instanceof ConsoleViewImpl) {
            ((ConsoleViewImpl)consoleView).foldImmediately();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/console/FoldLinesLikeThis";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSingleLineSelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

