/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.BlackListPanelKt;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.SwingActionLink;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/codeInsight/hints/BlackListDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "myEditor", "Lcom/intellij/ui/EditorTextField;", "getMyEditor", "()Lcom/intellij/ui/EditorTextField;", "setMyEditor", "(Lcom/intellij/ui/EditorTextField;)V", "myPatternsAreValid", "", "createBlacklistPanel", "Ljavax/swing/JPanel;", "createCenterPanel", "Ljavax/swing/JComponent;", "createResetPanel", "doOKAction", "", "setLanguageBlacklistToDefault", "storeBlackListDiff", "text", "", "updateOkEnabled", "editorTextField", "intellij.platform.lang.impl"})
public final class BlackListDialog
extends DialogWrapper {
    @NotNull
    public EditorTextField myEditor;
    private boolean myPatternsAreValid;
    @NotNull
    private final Language language;

    @NotNull
    public final EditorTextField getMyEditor() {
        EditorTextField editorTextField = this.myEditor;
        if (editorTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEditor");
        }
        return editorTextField;
    }

    public final void setMyEditor(@NotNull EditorTextField editorTextField) {
        Intrinsics.checkParameterIsNotNull((Object)editorTextField, (String)"<set-?>");
        this.myEditor = editorTextField;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.createBlacklistPanel(this.language);
    }

    private final JPanel createBlacklistPanel(Language language) {
        InlayParameterHintsProvider provider;
        InlayParameterHintsProvider inlayParameterHintsProvider = provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Intrinsics.checkExpressionValueIsNotNull((Object)inlayParameterHintsProvider, (String)"provider");
        if (!inlayParameterHintsProvider.isBlackListSupported()) {
            return null;
        }
        String blackList = BlackListPanelKt.access$getLanguageBlackList(language);
        EditorTextField editorTextField = BlackListPanelKt.access$createBlacklistEditorField(blackList);
        editorTextField.addDocumentListener(new DocumentListener(this, editorTextField){
            final /* synthetic */ BlackListDialog this$0;
            final /* synthetic */ EditorTextField $editorTextField;

            public void documentChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                BlackListDialog.access$updateOkEnabled(this.this$0, this.$editorTextField);
            }
            {
                this.this$0 = $outer;
                this.$editorTextField = $captured_local_variable$1;
            }
        });
        this.updateOkEnabled(editorTextField);
        this.myEditor = editorTextField;
        JPanel blacklistPanel = new JPanel();
        JComponent resetPanel = this.createResetPanel(language);
        resetPanel.setAlignmentX(0.0f);
        blacklistPanel.add(resetPanel);
        blacklistPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        editorTextField.setAlignmentX(0.0f);
        blacklistPanel.add((Component)((Object)editorTextField));
        BoxLayout layout = new BoxLayout(blacklistPanel, 1);
        blacklistPanel.setLayout(layout);
        JBLabel explanation = new JBLabel(BlackListPanelKt.access$getBlacklistExplanationHTML(language));
        explanation.setAlignmentX(0.0f);
        blacklistPanel.add((Component)explanation);
        JBLabel label2 = BlackListPanelKt.access$createBlacklistDependencyInfoLabel(language);
        if (label2 != null) {
            label2.setAlignmentX(0.0f);
            blacklistPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            blacklistPanel.add((Component)label2);
        }
        return blacklistPanel;
    }

    private final JComponent createResetPanel(Language language) {
        SwingActionLink link2 = new SwingActionLink((Action)new AbstractAction(this, language, "Reset"){
            final /* synthetic */ BlackListDialog this$0;
            final /* synthetic */ Language $language;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                BlackListDialog.access$setLanguageBlacklistToDefault(this.this$0, this.$language);
            }
            {
                this.this$0 = $outer;
                this.$language = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add((Component)link2);
        Box box2 = box;
        Intrinsics.checkExpressionValueIsNotNull((Object)box2, (String)"box");
        return box2;
    }

    private final void setLanguageBlacklistToDefault(Language language) {
        InlayParameterHintsProvider provider;
        InlayParameterHintsProvider inlayParameterHintsProvider = provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (inlayParameterHintsProvider == null) {
            Intrinsics.throwNpe();
        }
        Set set = inlayParameterHintsProvider.getDefaultBlackList();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"provider!!.defaultBlackList");
        Set defaultBlacklist = set;
        EditorTextField editorTextField = this.myEditor;
        if (editorTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEditor");
        }
        editorTextField.setText(StringUtil.join((Collection)defaultBlacklist, (String)"\n"));
    }

    private final void updateOkEnabled(EditorTextField editorTextField) {
        String string = editorTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"editorTextField.text");
        String text2 = string;
        List<Integer> invalidLines = HintUtilsKt.getBlackListInvalidLineNumbers(text2);
        this.myPatternsAreValid = invalidLines.isEmpty();
        Action action2 = this.getOKAction();
        Intrinsics.checkExpressionValueIsNotNull((Object)action2, (String)"okAction");
        action2.setEnabled(this.myPatternsAreValid);
        Editor editor = editorTextField.getEditor();
        if (editor != null) {
            BlackListPanelKt.access$highlightErrorLines(invalidLines, editor);
        }
    }

    protected void doOKAction() {
        super.doOKAction();
        EditorTextField editorTextField = this.myEditor;
        if (editorTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEditor");
        }
        String string = editorTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myEditor.text");
        String blacklist = string;
        this.storeBlackListDiff(this.language, blacklist);
    }

    /*
     * WARNING - void declaration
     */
    private final void storeBlackListDiff(Language language, String text2) {
        InlayParameterHintsProvider provider;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)text2, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String e = (String)element$iv$iv;
            boolean bl = false;
            String $this$trim$iv = e;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            CharSequence charSequence = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            boolean bl4 = false;
            if (!(!(charSequence.length() == 0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set updatedBlackList = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        InlayParameterHintsProvider inlayParameterHintsProvider = provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Intrinsics.checkExpressionValueIsNotNull((Object)inlayParameterHintsProvider, (String)"provider");
        Set set = inlayParameterHintsProvider.getDefaultBlackList();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"provider.defaultBlackList");
        Set defaultBlackList = set;
        Diff diff = Diff.Builder.build(defaultBlackList, updatedBlackList);
        ParameterNameHintsSettings.Companion.getInstance().setBlackListDiff(HintUtilsKt.getLanguageForSettingKey(language), diff);
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    public BlackListDialog(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        super(null);
        this.language = language;
        this.myPatternsAreValid = true;
        this.setTitle("Parameter Name Hints Blacklist");
        this.init();
    }

    public static final /* synthetic */ void access$updateOkEnabled(BlackListDialog $this, EditorTextField editorTextField) {
        $this.updateOkEnabled(editorTextField);
    }

    public static final /* synthetic */ void access$setLanguageBlacklistToDefault(BlackListDialog $this, Language language) {
        $this.setLanguageBlacklistToDefault(language);
    }
}

