/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class StreamGobbler
extends InputStream {
    private InputStream is;
    private final GobblerThread t;
    private final Object synchronizer = new Object();
    private boolean isEOF = false;
    private boolean isClosed = false;
    private IOException exception = null;
    private byte[] buffer = new byte[2048];
    private int read_pos = 0;
    private int write_pos = 0;

    public StreamGobbler(InputStream is) {
        this.is = is;
        this.t = new GobblerThread();
        this.t.setDaemon(true);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
            while (this.read_pos == this.write_pos) {
                if (this.exception != null) {
                    throw this.exception;
                }
                if (this.isEOF) {
                    return -1;
                }
                try {
                    this.synchronizer.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
            int b = this.buffer[this.read_pos++] & 0xFF;
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
            return this.write_pos - this.read_pos;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.isEOF = true;
            this.synchronizer.notifyAll();
            this.is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0 || off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
            while (this.read_pos == this.write_pos) {
                if (this.exception != null) {
                    throw this.exception;
                }
                if (this.isEOF) {
                    return -1;
                }
                try {
                    this.synchronizer.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
            int avail = this.write_pos - this.read_pos;
            avail = avail > len ? len : avail;
            System.arraycopy(this.buffer, this.read_pos, b, off, avail);
            this.read_pos += avail;
            return avail;
        }
    }

    static /* synthetic */ byte[] access$302(StreamGobbler x0, byte[] x1) {
        x0.buffer = x1;
        return x1;
    }

    class GobblerThread
    extends Thread {
        GobblerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] buff = new byte[8192];
            try {
                while (true) {
                    int avail = StreamGobbler.this.is.read(buff);
                    Object object = StreamGobbler.this.synchronizer;
                    synchronized (object) {
                        if (avail <= 0) {
                            StreamGobbler.this.isEOF = true;
                            StreamGobbler.this.synchronizer.notifyAll();
                            return;
                        }
                        int space_available = StreamGobbler.this.buffer.length - StreamGobbler.this.write_pos;
                        if (space_available < avail) {
                            int unread_size = StreamGobbler.this.write_pos - StreamGobbler.this.read_pos;
                            int need_space = unread_size + avail;
                            byte[] new_buffer = StreamGobbler.this.buffer;
                            if (need_space > StreamGobbler.this.buffer.length) {
                                int inc = need_space / 3;
                                inc = inc < 256 ? 256 : inc;
                                inc = inc > 8192 ? 8192 : inc;
                                new_buffer = new byte[need_space + inc];
                            }
                            if (unread_size > 0) {
                                System.arraycopy(StreamGobbler.this.buffer, StreamGobbler.this.read_pos, new_buffer, 0, unread_size);
                            }
                            StreamGobbler.access$302(StreamGobbler.this, new_buffer);
                            StreamGobbler.this.read_pos = 0;
                            StreamGobbler.this.write_pos = unread_size;
                        }
                        System.arraycopy(buff, 0, StreamGobbler.this.buffer, StreamGobbler.this.write_pos, avail);
                        StreamGobbler.this.write_pos = StreamGobbler.this.write_pos + avail;
                        StreamGobbler.this.synchronizer.notifyAll();
                    }
                }
            }
            catch (IOException e) {
                Object object = StreamGobbler.this.synchronizer;
                synchronized (object) {
                    StreamGobbler.this.exception = e;
                    StreamGobbler.this.synchronizer.notifyAll();
                    return;
                }
            }
        }
    }
}

