/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.Ignored;
import com.intellij.openapi.vcs.IgnoredCheckResult;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsIgnoreChecker;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImplKt;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl;", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ignoreRefreshQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getIgnoreRefreshQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "checkConfigurationVcsIgnored", "Lcom/intellij/openapi/vcs/IgnoredCheckResult;", "configurationFileName", "", "checkProjectNotDefault", "", "configurationNameToFileName", "configurationName", "getCheckerForFile", "Lcom/intellij/openapi/vcs/VcsIgnoreChecker;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isPotentiallyIgnoredFile", "", "isRunConfigurationVcsIgnored", "removeConfigurationFromVcsIgnore", "removeRunConfigurationFromVcsIgnore", "Companion", "intellij.platform.vcs.impl"})
public final class VcsIgnoreManagerImpl
implements VcsIgnoreManager {
    @NotNull
    private final MergingUpdateQueue ignoreRefreshQueue;
    private final Project project;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final MergingUpdateQueue getIgnoreRefreshQueue() {
        return this.ignoreRefreshQueue;
    }

    public boolean isRunConfigurationVcsIgnored(@NotNull String configurationName) {
        Intrinsics.checkParameterIsNotNull((Object)configurationName, (String)"configurationName");
        try {
            Function0 checkForIgnore2;
            String configurationFileName = this.configurationNameToFileName(configurationName);
            Function0 function0 = checkForIgnore2 = (Function0)new Function0<Boolean>(this, configurationFileName){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $configurationFileName;

                public final boolean invoke() {
                    return VcsIgnoreManagerImpl.access$checkConfigurationVcsIgnored(this.this$0, VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$configurationFileName) instanceof Ignored;
                }
                {
                    this.this$0 = vcsIgnoreManagerImpl;
                    this.$configurationFileName = string;
                    super(0);
                }
            };
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0(function0), "Checking configuration " + configurationName + " for ignore...", false, this.project);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ProgressManager.getInsta\u2026          false, project)");
            return (Boolean)object;
        }
        catch (IOException e) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)e);
            return false;
        }
    }

    public void removeRunConfigurationFromVcsIgnore(@NotNull String configurationName) {
        Intrinsics.checkParameterIsNotNull((Object)configurationName, (String)"configurationName");
        try {
            Function0 removeFromIgnore2;
            Function0 function0 = removeFromIgnore2 = (Function0)new Function0<Unit>(this, configurationName){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $configurationName;

                public final void invoke() {
                    VcsIgnoreManagerImpl.access$removeConfigurationFromVcsIgnore(this.this$0, VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$configurationName);
                }
                {
                    this.this$0 = vcsIgnoreManagerImpl;
                    this.$configurationName = string;
                    super(0);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0(function0), "Removing configuration " + configurationName + " from ignore...", false, this.project);
        }
        catch (IOException io) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)io);
        }
    }

    public boolean isPotentiallyIgnoredFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean $i$f$runReadAction = false;
        return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(this, file){
            final /* synthetic */ VcsIgnoreManagerImpl this$0;
            final /* synthetic */ VirtualFile $file$inlined;
            {
                this.this$0 = vcsIgnoreManagerImpl;
                this.$file$inlined = virtualFile;
            }

            public final T compute() {
                boolean bl;
                block3: {
                    boolean bl2 = false;
                    if (VcsIgnoreManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                        bl = false;
                    } else {
                        FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.$file$inlined);
                        ExtensionPointName extensionPointName = IgnoredFileProvider.IGNORE_FILE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"IgnoredFileProvider.IGNORE_FILE");
                        Object[] objectArray = extensionPointName.getExtensions();
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"IgnoredFileProvider.IGNORE_FILE.extensions");
                        Object[] $this$any$iv = objectArray;
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            IgnoredFileProvider it = (IgnoredFileProvider)element$iv;
                            boolean bl3 = false;
                            if (!it.isIgnoredFile(VcsIgnoreManagerImpl.access$getProject$p(this.this$0), filePath)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return (T)Boolean.valueOf(bl);
            }
        });
    }

    private final void removeConfigurationFromVcsIgnore(Project project, String configurationName) {
        VirtualFile virtualFile;
        if (ProjectKt.isDirectoryBased((Project)project)) {
            String string = ProjectKt.getStateStore((Project)project).getProjectConfigDir();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((virtualFile = VfsUtil.findFile((Path)Paths.get(string, new String[0]), (boolean)true)) == null) {
                Intrinsics.throwNpe();
            }
        } else {
            virtualFile = project.getProjectFile();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"if (project.isDirectoryB\u2026ect.projectFile!!\n      }");
        VirtualFile projectFileOrConfigDir = virtualFile;
        VirtualFile virtualFile2 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectFileOrConfigDir);
        if (virtualFile2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"VcsUtil.getVcsRootFor(pr\u2026ileOrConfigDir) ?: return");
        VirtualFile projectVcsRoot = virtualFile2;
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)projectVcsRoot);
        if (vcs == null) {
            VcsIgnoreManagerImplKt.access$getLOG$p().debug("Cannot get VCS for root " + projectVcsRoot.getPath());
            return;
        }
        IgnoredFileContentProvider ignoreContentProvider = VcsImplUtil.findIgnoredFileContentProvider(project, vcs);
        if (ignoreContentProvider == null) {
            VcsIgnoreManagerImplKt.access$getLOG$p().debug("Cannot get ignore content provider for vcs " + vcs.getName());
            return;
        }
        IgnoredCheckResult checkResult = this.checkConfigurationVcsIgnored(project, configurationName);
        if (checkResult instanceof Ignored) {
            File ignoreFile = ((Ignored)checkResult).getIgnoreFile();
            FileUtil.appendToFile((File)ignoreFile, (String)ignoreContentProvider.buildUnignoreContent(((Ignored)checkResult).getMatchedPattern()));
        }
    }

    private final IgnoredCheckResult checkConfigurationVcsIgnored(Project project, String configurationFileName) {
        VcsIgnoreChecker vcsIgnoreChecker;
        if (ProjectKt.isDirectoryBased((Project)project)) {
            String string = ProjectKt.getStateStore((Project)project).getProjectConfigDir();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(string, new String[0]), (boolean)true);
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VfsUtil.findFile(Paths.g\u2026jectConfigDir!!), true)!!");
            VirtualFile projectConfigDir = virtualFile;
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)projectConfigDir);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"virtualToIoFile(projectConfigDir)");
            File checkForIgnore2 = FilesKt.resolve((File)FilesKt.resolve((File)file, (String)"runConfigurations"), (String)(configurationFileName + "*.xml"));
            VirtualFile virtualFile2 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectConfigDir);
            if (virtualFile2 == null) {
                return (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"VcsUtil.getVcsRootFor(pr\u2026Dir) ?: return NotIgnored");
            VirtualFile vcsRootForIgnore = virtualFile2;
            vcsIgnoreChecker = this.getCheckerForFile(project, projectConfigDir);
            if (vcsIgnoreChecker == null || (vcsIgnoreChecker = vcsIgnoreChecker.isFilePatternIgnored(vcsRootForIgnore, PathUtil.toSystemIndependentName((String)checkForIgnore2.getPath()))) == null) {
                vcsIgnoreChecker = (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
        } else {
            VirtualFile virtualFile = project.getProjectFile();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"project.projectFile!!");
            VirtualFile projectFile = virtualFile;
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)projectFile);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"virtualToIoFile(projectFile)");
            File checkForIgnore3 = file;
            VirtualFile virtualFile3 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectFile);
            if (virtualFile3 == null) {
                return (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"VcsUtil.getVcsRootFor(pr\u2026ile) ?: return NotIgnored");
            VirtualFile vcsRootForIgnore = virtualFile3;
            vcsIgnoreChecker = this.getCheckerForFile(project, projectFile);
            if (vcsIgnoreChecker == null || (vcsIgnoreChecker = vcsIgnoreChecker.isIgnored(vcsRootForIgnore, checkForIgnore3)) == null) {
                vcsIgnoreChecker = (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
        }
        return vcsIgnoreChecker;
    }

    private final VcsIgnoreChecker getCheckerForFile(Project project, VirtualFile file) {
        Object v3;
        block2: {
            AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)file);
            if (abstractVcs == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"VcsUtil.getVcsFor(project, file) ?: return null");
            AbstractVcs vcs = abstractVcs;
            List list = VcsIgnoreChecker.EXTENSION_POINT_NAME.getExtensionList((AreaInstance)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"VcsIgnoreChecker.EXTENSI\u2026getExtensionList(project)");
            Iterable iterable = list;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                VcsIgnoreChecker checker = (VcsIgnoreChecker)t;
                boolean bl3 = false;
                VcsIgnoreChecker vcsIgnoreChecker = checker;
                Intrinsics.checkExpressionValueIsNotNull((Object)vcsIgnoreChecker, (String)"checker");
                if (!Intrinsics.areEqual((Object)vcsIgnoreChecker.getSupportedVcs(), (Object)vcs.getKeyInstanceMethod())) continue;
                v3 = t;
                break block2;
            }
            v3 = null;
        }
        return v3;
    }

    private final String configurationNameToFileName(String configurationName) {
        return (String)Scheme_implKt.getOLD_NAME_CONVERTER().invoke((Object)configurationName);
    }

    private final void checkProjectNotDefault(Project project) {
        if (project.isDefault()) {
            throw (Throwable)new UnsupportedOperationException("Default project not supported");
        }
    }

    public VcsIgnoreManagerImpl(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.checkProjectNotDefault(this.project);
        this.ignoreRefreshQueue = new MergingUpdateQueue("VcsIgnoreUpdate", 500, true, null, (Disposable)this.project, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public static final /* synthetic */ IgnoredCheckResult access$checkConfigurationVcsIgnored(VcsIgnoreManagerImpl $this, Project project, String configurationFileName) {
        return $this.checkConfigurationVcsIgnored(project, configurationFileName);
    }

    public static final /* synthetic */ Project access$getProject$p(VcsIgnoreManagerImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$removeConfigurationFromVcsIgnore(VcsIgnoreManagerImpl $this, Project project, String configurationName) {
        $this.removeConfigurationFromVcsIgnore(project, configurationName);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl$Companion;", "", "()V", "getInstanceImpl", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @NotNull
        public final VcsIgnoreManagerImpl getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            VcsIgnoreManager vcsIgnoreManager = VcsIgnoreManager.getInstance((Project)project);
            if (vcsIgnoreManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl");
            }
            return (VcsIgnoreManagerImpl)vcsIgnoreManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

