/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graph2.GeomUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageNote
extends AbstractEntityImage
implements Stencil {
    private final HtmlColor noteBackgroundColor;
    private final HtmlColor borderColor;
    private final double shadowing;
    private final int marginX1 = 6;
    private final int marginX2 = 15;
    private final int marginY = 5;
    private final boolean withShadow;
    private final ISkinParam skinParam;
    private final TextBlock textBlock;
    private Line opaleLine;
    private Shape shape;
    private Shape other;

    public EntityImageNote(ILeaf entity, ISkinParam skinParam) {
        super(entity, EntityImageNote.getSkin(EntityImageNote.getISkinParam(skinParam, entity), entity));
        this.skinParam = EntityImageNote.getISkinParam(skinParam, entity);
        this.withShadow = this.getSkinParam().shadowing(this.getEntity().getStereotype());
        Display strings = entity.getDisplay();
        Rose rose = new Rose();
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(skinParam.getCurrentStyleBuilder());
            this.noteBackgroundColor = entity.getColors(this.getSkinParam()).getColor(ColorType.BACK) == null ? style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet()) : entity.getColors(this.getSkinParam()).getColor(ColorType.BACK);
            this.borderColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
            this.shadowing = style.value(PName.Shadowing).asDouble();
        } else {
            this.shadowing = skinParam.shadowing(this.getEntity().getStereotype()) ? 4.0 : 0.0;
            this.noteBackgroundColor = entity.getColors(this.getSkinParam()).getColor(ColorType.BACK) == null ? rose.getHtmlColor(this.getSkinParam(), ColorParam.noteBackground) : entity.getColors(this.getSkinParam()).getColor(ColorType.BACK);
            this.borderColor = SkinParamUtils.getColor(this.getSkinParam(), null, ColorParam.noteBorder);
        }
        this.textBlock = strings.size() == 1 && strings.get(0).length() == 0 ? new TextBlockEmpty() : new BodyEnhanced2(strings, FontParam.NOTE, this.getSkinParam(), HorizontalAlignment.LEFT, new FontConfiguration(this.getSkinParam(), FontParam.NOTE, null), this.getSkinParam().wrapWidth());
    }

    private static ISkinParam getISkinParam(ISkinParam skinParam, IEntity entity) {
        if (entity.getColors(skinParam) != null) {
            return entity.getColors(skinParam).mute(skinParam);
        }
        return skinParam;
    }

    static ISkinParam getSkin(ISkinParam skinParam, IEntity entity) {
        Stereotype stereotype = entity.getStereotype();
        HtmlColor back = entity.getColors(skinParam).getColor(ColorType.BACK);
        if (back != null) {
            return new SkinParamBackcolored(skinParam, back);
        }
        back = EntityImageNote.getColorStatic(skinParam, ColorParam.noteBackground, stereotype);
        if (back != null) {
            return new SkinParamBackcolored(skinParam, back);
        }
        return skinParam;
    }

    private static HtmlColor getColorStatic(ISkinParam skinParam, ColorParam colorParam, Stereotype stereo) {
        Rose rose = new Rose();
        return rose.getHtmlColor(skinParam, stereo, colorParam);
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getTextWidth(stringBounder);
        return result;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder);
    }

    private Dimension2D getSize(StringBounder stringBounder, TextBlock textBlock) {
        return textBlock.calculateDimension(stringBounder);
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = this.getSize(stringBounder, textBlock);
        return size.getHeight() + 10.0;
    }

    protected final TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected final double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = this.getSize(stringBounder, textBlock);
        return size.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + 6.0 + 15.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double height = this.getPreferredHeight(stringBounder);
        double width = this.getPreferredWidth(stringBounder);
        return new Dimension2DDouble(width, height);
    }

    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    public final void drawU(UGraphic ug) {
        Url url = this.getEntity().getUrl99();
        if (url != null) {
            ug.startUrl(url);
        }
        UGraphic ug2 = UGraphicStencil.create(ug, this, new UStroke());
        if (this.opaleLine == null || !this.opaleLine.isOpale()) {
            this.drawNormal(ug2);
        } else {
            StringBounder stringBounder = ug.getStringBounder();
            DotPath path = this.opaleLine.getDotPath();
            path.moveSvek(-this.shape.getMinX(), -this.shape.getMinY());
            Point2D p1 = path.getStartPoint();
            Point2D p2 = path.getEndPoint();
            double textWidth = this.getTextWidth(stringBounder);
            double textHeight = this.getTextHeight(stringBounder);
            Point2D.Double center = new Point2D.Double(textWidth / 2.0, textHeight / 2.0);
            if (p1.distance(center) > p2.distance(center)) {
                path = path.reverse();
                p1 = path.getStartPoint();
            }
            Direction strategy = this.getOpaleStrategy(textWidth, textHeight, p1);
            Point2D pp1 = path.getStartPoint();
            Point2D pp2 = path.getEndPoint();
            Point2D newRefpp2 = EntityImageNote.move(pp2, this.shape.getMinX(), this.shape.getMinY());
            Point2D projection = EntityImageNote.move(this.other.projection(newRefpp2, stringBounder), -this.shape.getMinX(), -this.shape.getMinY());
            Opale opale = new Opale(this.shadowing, this.borderColor, this.noteBackgroundColor, this.textBlock, true);
            opale.setRoundCorner(this.getRoundCorner());
            opale.setOpale(strategy, pp1, projection);
            UGraphic stroked = this.applyStroke(ug2);
            opale.drawU(Colors.applyStroke(stroked, this.getEntity().getColors(this.skinParam)));
        }
        if (url != null) {
            ug.closeAction();
        }
    }

    private double getRoundCorner() {
        return this.skinParam.getRoundCorner(CornerParam.DEFAULT, null);
    }

    private static Point2D move(Point2D pt, double dx, double dy) {
        return new Point2D.Double(pt.getX() + dx, pt.getY() + dy);
    }

    private void drawNormal(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        UPath polygon = Opale.getPolygonNormal(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), this.getRoundCorner());
        if (this.withShadow) {
            polygon.setDeltaShadow(4.0);
        }
        ug = ug.apply(new UChangeBackColor(this.noteBackgroundColor)).apply(new UChangeColor(this.borderColor));
        UGraphic stroked = this.applyStroke(ug);
        stroked.draw(polygon);
        ug.draw(Opale.getCorner(this.getTextWidth(stringBounder), this.getRoundCorner()));
        this.getTextBlock().drawU(ug.apply(new UTranslate(6.0, 5.0)));
    }

    private UGraphic applyStroke(UGraphic ug) {
        UStroke stroke = this.skinParam.getThickness(LineParam.noteBorder, null);
        if (stroke == null) {
            return ug;
        }
        return ug.apply(stroke);
    }

    private Direction getOpaleStrategy(double width, double height, Point2D pt) {
        double d1 = GeomUtils.getOrthoDistance(new Line2D.Double(width, 0.0, width, height), pt);
        double d2 = GeomUtils.getOrthoDistance(new Line2D.Double(0.0, height, width, height), pt);
        double d3 = GeomUtils.getOrthoDistance(new Line2D.Double(0.0, 0.0, 0.0, height), pt);
        double d4 = GeomUtils.getOrthoDistance(new Line2D.Double(0.0, 0.0, width, 0.0), pt);
        if (d3 <= d1 && d3 <= d2 && d3 <= d4) {
            return Direction.LEFT;
        }
        if (d1 <= d2 && d1 <= d3 && d1 <= d4) {
            return Direction.RIGHT;
        }
        if (d4 <= d1 && d4 <= d2 && d4 <= d3) {
            return Direction.UP;
        }
        if (d2 <= d1 && d2 <= d3 && d2 <= d4) {
            return Direction.DOWN;
        }
        return null;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public void setOpaleLine(Line line, Shape shape, Shape other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.opaleLine = line;
        this.shape = shape;
        this.other = other;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

