/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityCircleCrowfoot
extends Extremity {
    private final Point2D contact;
    private final double angle;
    private final double radius = 4.0;

    @Override
    public Point2D somePoint() {
        return this.contact;
    }

    public ExtremityCircleCrowfoot(Point2D p1, double angle) {
        this.contact = new Point2D.Double(p1.getX(), p1.getY());
        this.angle = this.manageround(angle + 1.5707963267948966);
    }

    @Override
    public void drawU(UGraphic ug) {
        int xWing = 8;
        int yAperture = 6;
        AffineTransform rotate = AffineTransform.getRotateInstance(this.angle);
        Point2D.Double middle = new Point2D.Double(0.0, 0.0);
        Point2D.Double left = new Point2D.Double(0.0, -6.0);
        Point2D.Double base = new Point2D.Double(-8.0, 0.0);
        Point2D.Double right = new Point2D.Double(0.0, 6.0);
        Point2D.Double circleBase = new Point2D.Double(-14.0, 0.0);
        rotate.transform(left, left);
        rotate.transform(base, base);
        rotate.transform(right, right);
        rotate.transform(circleBase, circleBase);
        ExtremityCircleCrowfoot.drawLine(ug, this.contact.getX(), this.contact.getY(), base, left);
        ExtremityCircleCrowfoot.drawLine(ug, this.contact.getX(), this.contact.getY(), base, right);
        ExtremityCircleCrowfoot.drawLine(ug, this.contact.getX(), this.contact.getY(), base, middle);
        ug.apply(new UTranslate(this.contact.getX() + ((Point2D)circleBase).getX() - 4.0, this.contact.getY() + ((Point2D)circleBase).getY() - 4.0)).draw(new UEllipse(8.0, 8.0));
    }

    private static void drawLine(UGraphic ug, double x, double y, Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

