/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.pdfsam.ui.io.BaseRememberingLatestChooser;
import org.pdfsam.ui.io.SetLatestDirectoryEvent;
import org.sejda.eventstudio.StaticStudio;

public class RememberingLatestFileChooserWrapper
extends BaseRememberingLatestChooser {
    private FileChooser wrapped = new FileChooser();

    public RememberingLatestFileChooserWrapper() {
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    final void setTitle(String value) {
        this.wrapped.setTitle(value);
    }

    @Override
    public final void setInitialDirectory(File value) {
        this.wrapped.setInitialDirectory(value);
    }

    public final void setInitialFileName(String value) {
        this.wrapped.setInitialFileName(value);
    }

    public List<File> showOpenMultipleDialog(Window ownerWindow) {
        this.sanitizeInitialDirectory();
        List selected = this.wrapped.showOpenMultipleDialog(ownerWindow);
        if (selected != null && !selected.isEmpty()) {
            this.notifyNewLatestDirectory((File)selected.get(0));
        }
        return selected;
    }

    private void sanitizeInitialDirectory() {
        if (Optional.ofNullable(this.wrapped.getInitialDirectory()).map(File::toPath).filter(f -> !Files.isDirectory(f, new LinkOption[0])).isPresent()) {
            this.wrapped.setInitialDirectory(null);
        }
    }

    public File showDialog(OpenType type) {
        return this.showDialog(null, type);
    }

    public File showDialog(Window ownerWindow, OpenType type) {
        File selected = null;
        switch (type) {
            case SAVE: {
                this.sanitizeInitialDirectory();
                selected = this.wrapped.showSaveDialog(ownerWindow);
                break;
            }
            default: {
                this.sanitizeInitialDirectory();
                selected = this.wrapped.showOpenDialog(ownerWindow);
            }
        }
        this.notifyNewLatestDirectory(selected);
        return selected;
    }

    private void notifyNewLatestDirectory(File selected) {
        if (selected != null && selected.isFile()) {
            StaticStudio.eventStudio().broadcast((Object)new SetLatestDirectoryEvent(selected.getParentFile()));
        }
    }

    ObservableList<FileChooser.ExtensionFilter> getExtensionFilters() {
        return this.wrapped.getExtensionFilters();
    }

    public static enum OpenType {
        OPEN,
        SAVE;

    }
}

