/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Experimental;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

@Experimental
public class OpenNMTRule
extends Rule {
    private static final String defaultServerUrl = "http://127.0.0.1:7784/translator/translate";
    private final String serverUrl;
    private final ObjectMapper mapper = new ObjectMapper();

    public OpenNMTRule(String serverUrl) {
        this.serverUrl = serverUrl;
        this.setDefaultOff();
    }

    public OpenNMTRule() {
        this(defaultServerUrl);
    }

    @Override
    public String getId() {
        return "OPENNMT_RULE";
    }

    @Override
    public String getDescription() {
        return "Get corrections from an OpenNMT server (beta)";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        URL url;
        String json = this.createJson(sentence);
        HttpURLConnection conn = this.postToServer(json, url = new URL(this.serverUrl));
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            InputStream inputStr = conn.getInputStream();
            JsonNode response = this.mapper.readTree(inputStr);
            String translation = response.get(0).get(0).get("tgt").textValue();
            if (translation.contains("<unk>")) {
                throw new RuntimeException("'<unk>' found in translation - please start the OpenNMT server with the -replace_unk option");
            }
            translation = this.detokenize(translation);
            String cleanTranslation = translation.replaceAll(" ([.,;:])", "$1");
            String sentenceText = sentence.getText();
            if (!cleanTranslation.trim().equals(sentenceText.trim())) {
                ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
                int from = this.getLeftWordBoundary(sentenceText, this.getFirstDiffPosition(sentenceText, cleanTranslation));
                int to = this.getRightWordBoundary(sentenceText, this.getLastDiffPosition(sentenceText, cleanTranslation));
                int replacementTo = this.getRightWordBoundary(cleanTranslation, this.getLastDiffPosition(cleanTranslation, sentenceText));
                String message = "OpenNMT suggests that this might(!) be better phrased differently, please check.";
                RuleMatch ruleMatch = new RuleMatch(this, sentence, from, to, message);
                ruleMatch.setSuggestedReplacement(cleanTranslation.substring(from, replacementTo));
                ruleMatches.add(ruleMatch);
                return this.toRuleMatchArray(ruleMatches);
            }
            return new RuleMatch[0];
        }
        InputStream inputStr = conn.getErrorStream();
        String error = CharStreams.toString((Readable)new InputStreamReader(inputStr, Charsets.UTF_8));
        throw new RuntimeException("Got error " + responseCode + " from " + url + ": " + error);
    }

    private String detokenize(String translation) {
        return translation.replaceAll(" 's", "'s").replaceAll(" ' s", "'s").replaceAll(" ' t", "'t").replace(" .", ".").replace(" ,", ",");
    }

    int getFirstDiffPosition(String text1, String text2) {
        for (int i = 0; i < text1.length(); ++i) {
            if (i < text2.length()) {
                if (text1.charAt(i) == text2.charAt(i)) continue;
                return i;
            }
            return i;
        }
        if (text1.length() != text2.length()) {
            return text1.length();
        }
        return -1;
    }

    int getLastDiffPosition(String text1, String text2) {
        StringBuilder reverse1 = new StringBuilder(text1.trim()).reverse();
        StringBuilder reverse2 = new StringBuilder(text2.trim()).reverse();
        int revDiffPos = this.getFirstDiffPosition(reverse1.toString(), reverse2.toString());
        if (revDiffPos != -1) {
            return text1.length() - revDiffPos;
        }
        return -1;
    }

    int getLeftWordBoundary(String text, int pos) {
        while (pos >= 1 && Character.isAlphabetic(text.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    int getRightWordBoundary(String text, int pos) {
        while (pos >= 0 && pos < text.length() && Character.isAlphabetic(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private String createJson(AnalyzedSentence sentence) throws JsonProcessingException {
        ArrayNode list = this.mapper.createArrayNode();
        ObjectNode node = list.addObject();
        node.put("src", sentence.getText());
        return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)list);
    }

    @NotNull
    private HttpURLConnection postToServer(String json, URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        try (DataOutputStream dos = new DataOutputStream(conn.getOutputStream());){
            dos.write(json.getBytes("utf-8"));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not connect OpenNMT server at " + url);
        }
        return conn;
    }
}

