/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ThemeManager;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;
import org.keycloak.theme.ThemeSelectorProvider;

public class DefaultThemeManager
implements ThemeManager {
    private KeycloakSession session;

    public DefaultThemeManager(KeycloakSession session) {
        this.session = session;
    }

    public Theme getTheme(Theme.Type type) throws IOException {
        String name = ((ThemeSelectorProvider)this.session.getProvider(ThemeSelectorProvider.class)).getThemeName(type);
        return this.getTheme(name, type);
    }

    public Theme getTheme(String name, Theme.Type type) throws IOException {
        return ((ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending")).getTheme(name, type);
    }

    public Set<String> nameSet(Theme.Type type) {
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        return themeProvider.nameSet(type);
    }
}

