/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class FunctionalService<T, V>
implements Service {
    private static final Logger LOGGER = Logger.getLogger(FunctionalService.class);
    private final Consumer<V> consumer;
    private final Function<T, V> mapper;
    private final Supplier<T> factory;
    private final Consumer<T> destroyer;
    private volatile T value;

    public FunctionalService(Consumer<V> consumer, Function<T, V> mapper, Supplier<T> factory) {
        this(consumer, mapper, factory, new Consumer<T>(){

            @Override
            public void accept(T value) {
            }
        });
    }

    public FunctionalService(Consumer<V> consumer, Function<T, V> mapper, Supplier<T> factory, Consumer<T> destroyer) {
        this.consumer = consumer;
        this.mapper = mapper;
        this.factory = factory;
        this.destroyer = destroyer;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.value = this.factory.get();
            this.consumer.accept(this.mapper.apply(this.value));
        }
        catch (Error | RuntimeException e) {
            throw new StartException(e);
        }
    }

    public void stop(StopContext context) {
        try {
            this.destroyer.accept(this.value);
        }
        catch (Error | RuntimeException e) {
            LOGGER.warn((Object)e.getLocalizedMessage(), e);
        }
        finally {
            this.value = null;
        }
    }
}

