/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.javaee.spec;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;

public class LifecycleCallbacksMetaData
extends ArrayList<LifecycleCallbackMetaData> {
    private static final long serialVersionUID = -3843612778667898679L;

    public List<Method> getOrderedCallbacks(Class<?> defaultClass) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        Class[] parameterTypes = new Class[]{};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String className = null;
        String methodName = null;
        try {
            HashSet callbacksSet = new HashSet();
            LinkedList<Method> methods = new LinkedList<Method>();
            for (LifecycleCallbackMetaData callback : this) {
                className = callback.getClassName();
                methodName = callback.getMethodName();
                Class<?> lifecycleClass = className == null ? defaultClass : cl.loadClass(className);
                if (!callbacksSet.add(lifecycleClass)) continue;
                Method method = lifecycleClass.getDeclaredMethod(methodName, parameterTypes);
                boolean added = false;
                for (int i = 0; i < methods.size(); ++i) {
                    Method m = methods.get(i);
                    Class<?> methodClass = m.getDeclaringClass();
                    if (lifecycleClass.isAssignableFrom(methodClass)) {
                        methods.add(i, method);
                        added = true;
                        break;
                    }
                    if (methodClass.isAssignableFrom(lifecycleClass) || lifecycleClass != defaultClass && !lifecycleClass.isAssignableFrom(defaultClass)) continue;
                    methods.add(i, method);
                    added = true;
                    break;
                }
                if (added) continue;
                methods.add(method);
            }
            return methods;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load class for callback method " + methodName + ": " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to get callback method in class " + className + ": " + methodName, e);
        }
    }
}

