/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.query.jpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.grails.datastore.mapping.model.AbstractPersistentEntity;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.AssociationCriteria;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.query.jpa.JpaQueryInfo;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public class JpaQueryBuilder {
    private static final String DISTINCT_CLAUSE = "DISTINCT ";
    private static final String SELECT_CLAUSE = "SELECT ";
    private static final String AS_CLAUSE = " AS ";
    private static final String FROM_CLAUSE = " FROM ";
    private static final String ORDER_BY_CLAUSE = " ORDER BY ";
    private static final String WHERE_CLAUSE = " WHERE ";
    private static final char COMMA = ',';
    private static final char CLOSE_BRACKET = ')';
    private static final char OPEN_BRACKET = '(';
    private static final char SPACE = ' ';
    private static final char QUESTIONMARK = '?';
    private static final char DOT = '.';
    public static final String NOT_CLAUSE = " NOT";
    public static final String LOGICAL_AND = " AND ";
    public static final String UPDATE_CLAUSE = "UPDATE ";
    public static final String DELETE_CLAUSE = "DELETE ";
    public static final String LOGICAL_OR = " OR ";
    private static final Map<Class, QueryHandler> queryHandlers = new HashMap<Class, QueryHandler>();
    public static final String PARAMETER_NAME_PREFIX = "p";
    private static final String PARAMETER_PREFIX = ":p";
    private PersistentEntity entity;
    private Query.Junction criteria;
    private Query.ProjectionList projectionList = new Query.ProjectionList();
    private List<Query.Order> orders = Collections.emptyList();
    private String logicalName;
    private ConversionService conversionService = new GenericConversionService();
    private boolean hibernateCompatible;

    public JpaQueryBuilder(QueryableCriteria criteria) {
        this(criteria.getPersistentEntity(), criteria.getCriteria());
    }

    public JpaQueryBuilder(PersistentEntity entity, List<Query.Criterion> criteria) {
        this(entity, new Query.Conjunction(criteria));
    }

    public JpaQueryBuilder(PersistentEntity entity, List<Query.Criterion> criteria, Query.ProjectionList projectionList) {
        this(entity, new Query.Conjunction(criteria), projectionList);
    }

    public JpaQueryBuilder(PersistentEntity entity, List<Query.Criterion> criteria, Query.ProjectionList projectionList, List<Query.Order> orders) {
        this(entity, new Query.Conjunction(criteria), projectionList, orders);
    }

    public JpaQueryBuilder(PersistentEntity entity, Query.Junction criteria) {
        this.entity = entity;
        this.criteria = criteria;
        this.logicalName = entity.getDecapitalizedName();
    }

    public JpaQueryBuilder(PersistentEntity entity, Query.Junction criteria, Query.ProjectionList projectionList) {
        this(entity, criteria);
        this.projectionList = projectionList;
    }

    public JpaQueryBuilder(PersistentEntity entity, Query.Junction criteria, Query.ProjectionList projectionList, List<Query.Order> orders) {
        this(entity, criteria, projectionList);
        this.orders = orders;
    }

    public void setHibernateCompatible(boolean hibernateCompatible) {
        this.hibernateCompatible = hibernateCompatible;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public JpaQueryInfo buildUpdate(Map<String, Object> propertiesToUpdate) {
        if (propertiesToUpdate.isEmpty()) {
            throw new InvalidDataAccessResourceUsageException("No properties specified to update");
        }
        StringBuilder queryString = new StringBuilder(UPDATE_CLAUSE).append(this.entity.getName()).append(' ').append(this.logicalName);
        ArrayList parameters = new ArrayList();
        this.buildUpdateStatement(queryString, propertiesToUpdate, parameters, this.hibernateCompatible);
        StringBuilder whereClause = new StringBuilder();
        this.buildWhereClause(this.entity, this.criteria, queryString, whereClause, this.logicalName, false, parameters);
        return new JpaQueryInfo(queryString.toString(), parameters);
    }

    public JpaQueryInfo buildDelete() {
        StringBuilder queryString = new StringBuilder(DELETE_CLAUSE).append(this.entity.getName()).append(' ').append(this.logicalName);
        StringBuilder whereClause = new StringBuilder();
        List parameters = this.buildWhereClause(this.entity, this.criteria, queryString, whereClause, this.logicalName, false);
        return new JpaQueryInfo(queryString.toString(), parameters);
    }

    public JpaQueryInfo buildSelect() {
        StringBuilder queryString = new StringBuilder(SELECT_CLAUSE);
        this.buildSelectClause(queryString);
        StringBuilder whereClause = new StringBuilder();
        List parameters = null;
        if (!this.criteria.isEmpty()) {
            parameters = this.buildWhereClause(this.entity, this.criteria, queryString, whereClause, this.logicalName, true);
        }
        this.appendOrder(queryString, this.logicalName);
        return new JpaQueryInfo(queryString.toString(), parameters);
    }

    private void buildSelectClause(StringBuilder queryString) {
        Query.ProjectionList projectionList = this.projectionList;
        String logicalName = this.logicalName;
        PersistentEntity entity = this.entity;
        JpaQueryBuilder.buildSelect(queryString, projectionList.getProjectionList(), logicalName, entity);
        queryString.append(FROM_CLAUSE).append(entity.getName()).append(AS_CLAUSE).append(logicalName);
    }

    private static void buildSelect(StringBuilder queryString, List<Query.Projection> projectionList, String logicalName, PersistentEntity entity) {
        if (projectionList.isEmpty()) {
            queryString.append(DISTINCT_CLAUSE).append(logicalName);
        } else {
            Iterator<Query.Projection> i = projectionList.iterator();
            while (i.hasNext()) {
                Query.Projection projection = i.next();
                if (projection instanceof Query.CountProjection) {
                    queryString.append("COUNT(").append(logicalName).append(')');
                } else if (projection instanceof Query.IdProjection) {
                    queryString.append(logicalName).append('.').append(entity.getIdentity().getName());
                } else if (projection instanceof Query.PropertyProjection) {
                    Query.PropertyProjection pp = (Query.PropertyProjection)projection;
                    if (projection instanceof Query.AvgProjection) {
                        queryString.append("AVG(").append(logicalName).append('.').append(pp.getPropertyName()).append(')');
                    } else if (projection instanceof Query.SumProjection) {
                        queryString.append("SUM(").append(logicalName).append('.').append(pp.getPropertyName()).append(')');
                    } else if (projection instanceof Query.MinProjection) {
                        queryString.append("MIN(").append(logicalName).append('.').append(pp.getPropertyName()).append(')');
                    } else if (projection instanceof Query.MaxProjection) {
                        queryString.append("MAX(").append(logicalName).append('.').append(pp.getPropertyName()).append(')');
                    } else if (projection instanceof Query.CountDistinctProjection) {
                        queryString.append("COUNT(DISTINCT ").append(logicalName).append('.').append(pp.getPropertyName()).append(')');
                    } else {
                        queryString.append(logicalName).append('.').append(pp.getPropertyName());
                    }
                }
                if (!i.hasNext()) continue;
                queryString.append(',');
            }
        }
    }

    public static int appendCriteriaForOperator(StringBuilder q, String logicalName, String name, int position, String operator, boolean hibernateCompatible) {
        q.append(logicalName).append('.').append(name).append(operator).append(PARAMETER_PREFIX).append(++position);
        return position;
    }

    protected static int handleSubQuery(PersistentEntity entity, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible, Query.SubqueryCriterion equalsAll, String comparisonExpression) {
        String name = equalsAll.getProperty();
        JpaQueryBuilder.validateProperty(entity, name, Query.In.class);
        QueryableCriteria subquery = equalsAll.getValue();
        whereClause.append(logicalName).append('.').append(name).append(comparisonExpression);
        JpaQueryBuilder.buildSubQuery(q, whereClause, position, parameters, conversionService, allowJoins, hibernateCompatible, subquery);
        whereClause.append(')');
        return position;
    }

    protected static void buildSubQuery(StringBuilder q, StringBuilder whereClause, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible, QueryableCriteria subquery) {
        PersistentEntity associatedEntity = subquery.getPersistentEntity();
        String associatedEntityName = associatedEntity.getName();
        String associatedEntityLogicalName = associatedEntity.getDecapitalizedName() + position;
        whereClause.append(SELECT_CLAUSE);
        JpaQueryBuilder.buildSelect(whereClause, subquery.getProjections(), associatedEntityLogicalName, associatedEntity);
        whereClause.append(FROM_CLAUSE).append(associatedEntityName).append(' ').append(associatedEntityLogicalName).append(WHERE_CLAUSE);
        List<Query.Criterion> criteria = subquery.getCriteria();
        for (Query.Criterion subCriteria : criteria) {
            QueryHandler queryHandler = queryHandlers.get(subCriteria.getClass());
            queryHandler.handle(associatedEntity, subCriteria, q, whereClause, associatedEntityLogicalName, position, parameters, conversionService, allowJoins, hibernateCompatible);
        }
    }

    private static int handleAssociationCriteria(StringBuilder query, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, Association<?> association, Query.Junction associationCriteria, List<Query.Criterion> associationCriteriaList, boolean hibernateCompatible) {
        if (association instanceof ToOne) {
            String associationName = association.getName();
            logicalName = logicalName + '.' + associationName;
            return JpaQueryBuilder.buildWhereClauseForCriterion(association.getAssociatedEntity(), associationCriteria, query, whereClause, logicalName, associationCriteriaList, position, parameters, conversionService, allowJoins, hibernateCompatible);
        }
        if (association != null) {
            String associationName = association.getName();
            String joinType = " INNER JOIN ";
            query.append(joinType).append(logicalName).append('.').append(associationName).append(' ').append(associationName);
            return JpaQueryBuilder.buildWhereClauseForCriterion(association.getAssociatedEntity(), associationCriteria, query, whereClause, associationName, associationCriteriaList, position, parameters, conversionService, allowJoins, hibernateCompatible);
        }
        return position;
    }

    private void buildUpdateStatement(StringBuilder queryString, Map<String, Object> propertiesToUpdate, List parameters, boolean hibernateCompatible) {
        queryString.append(' ').append("SET");
        TreeSet<String> keys = new TreeSet<String>(propertiesToUpdate.keySet());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String propertyName = (String)iterator.next();
            PersistentProperty prop = this.entity.getPropertyByName(propertyName);
            if (prop == null) {
                throw new InvalidDataAccessResourceUsageException("Property '" + propertyName + "' of class '" + this.entity.getName() + "' specified in update does not exist");
            }
            parameters.add(propertiesToUpdate.get(propertyName));
            queryString.append(' ').append(this.logicalName).append('.').append(propertyName).append('=');
            queryString.append(PARAMETER_PREFIX).append(parameters.size());
            if (!iterator.hasNext()) continue;
            queryString.append(',');
        }
    }

    private static void appendPropertyComparison(StringBuilder q, String logicalName, String propertyName, String otherProperty, String operator) {
        q.append(logicalName).append('.').append(propertyName).append(operator).append(logicalName).append('.').append(otherProperty);
    }

    private static PersistentProperty validateProperty(PersistentEntity entity, String name, Class criterionType) {
        PersistentProperty prop;
        PersistentProperty identity = entity.getIdentity();
        if (identity != null && identity.getName().equals(name)) {
            return identity;
        }
        PersistentProperty[] compositeIdentity = ((AbstractPersistentEntity)entity).getCompositeIdentity();
        if (compositeIdentity != null) {
            for (PersistentProperty property : compositeIdentity) {
                if (!property.getName().equals(name)) continue;
                return property;
            }
        }
        if ((prop = entity.getPropertyByName(name)) == null) {
            throw new InvalidDataAccessResourceUsageException("Cannot use [" + criterionType.getSimpleName() + "] criterion on non-existent property: " + name);
        }
        return prop;
    }

    private List buildWhereClause(PersistentEntity entity, Query.Junction criteria, StringBuilder q, StringBuilder whereClause, String logicalName, boolean allowJoins) {
        ArrayList parameters = new ArrayList();
        return this.buildWhereClause(entity, criteria, q, whereClause, logicalName, allowJoins, parameters);
    }

    private List buildWhereClause(PersistentEntity entity, Query.Junction criteria, StringBuilder q, StringBuilder whereClause, String logicalName, boolean allowJoins, List parameters) {
        if (!criteria.isEmpty()) {
            int position = parameters.size();
            List<Query.Criterion> criterionList = criteria.getCriteria();
            whereClause.append(WHERE_CLAUSE);
            if (criteria instanceof Query.Negation) {
                whereClause.append(NOT_CLAUSE);
            }
            whereClause.append('(');
            position = JpaQueryBuilder.buildWhereClauseForCriterion(entity, criteria, q, whereClause, logicalName, criterionList, position, parameters, this.conversionService, allowJoins, this.hibernateCompatible);
            q.append(whereClause.toString());
            q.append(')');
        }
        return parameters;
    }

    protected void appendOrder(StringBuilder queryString, String logicalName) {
        if (!this.orders.isEmpty()) {
            queryString.append(ORDER_BY_CLAUSE);
            for (Query.Order order : this.orders) {
                queryString.append(logicalName).append('.').append(order.getProperty()).append(' ').append(order.getDirection().toString()).append(' ');
            }
        }
    }

    static int buildWhereClauseForCriterion(PersistentEntity entity, Query.Junction criteria, StringBuilder q, StringBuilder whereClause, String logicalName, List<Query.Criterion> criterionList, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
        Iterator<Query.Criterion> iterator = criterionList.iterator();
        while (iterator.hasNext()) {
            Query.Criterion criterion = iterator.next();
            String operator = criteria instanceof Query.Conjunction ? LOGICAL_AND : LOGICAL_OR;
            QueryHandler qh = queryHandlers.get(criterion.getClass());
            if (qh != null) {
                position = qh.handle(entity, criterion, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible);
            } else if (criterion instanceof AssociationCriteria) {
                if (!allowJoins) {
                    throw new InvalidDataAccessResourceUsageException("Joins cannot be used in a DELETE or UPDATE operation");
                }
                AssociationCriteria ac = (AssociationCriteria)((Object)criterion);
                Association association = ac.getAssociation();
                List<Query.Criterion> associationCriteriaList = ac.getCriteria();
                JpaQueryBuilder.handleAssociationCriteria(q, whereClause, logicalName, position, parameters, conversionService, allowJoins, association, new Query.Conjunction(), associationCriteriaList, hibernateCompatible);
            } else {
                throw new InvalidDataAccessResourceUsageException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
            }
            if (!iterator.hasNext()) continue;
            whereClause.append(operator);
        }
        return position;
    }

    static {
        queryHandlers.put(AssociationQuery.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                if (!allowJoins) {
                    throw new InvalidDataAccessResourceUsageException("Joins cannot be used in a DELETE or UPDATE operation");
                }
                AssociationQuery aq = (AssociationQuery)criterion;
                Association<?> association = aq.getAssociation();
                Query.Junction associationCriteria = aq.getCriteria();
                List<Query.Criterion> associationCriteriaList = associationCriteria.getCriteria();
                return JpaQueryBuilder.handleAssociationCriteria(q, whereClause, logicalName, position, parameters, conversionService, allowJoins, association, associationCriteria, associationCriteriaList, hibernateCompatible);
            }
        });
        queryHandlers.put(Query.Negation.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                whereClause.append(JpaQueryBuilder.NOT_CLAUSE).append('(');
                Query.Negation negation = (Query.Negation)criterion;
                position = JpaQueryBuilder.buildWhereClauseForCriterion(entity, negation, q, whereClause, logicalName, negation.getCriteria(), position, parameters, conversionService, allowJoins, hibernateCompatible);
                whereClause.append(')');
                return position;
            }
        });
        queryHandlers.put(Query.Conjunction.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                whereClause.append('(');
                Query.Conjunction conjunction = (Query.Conjunction)criterion;
                position = JpaQueryBuilder.buildWhereClauseForCriterion(entity, conjunction, q, whereClause, logicalName, conjunction.getCriteria(), position, parameters, conversionService, allowJoins, hibernateCompatible);
                whereClause.append(')');
                return position;
            }
        });
        queryHandlers.put(Query.Disjunction.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                whereClause.append('(');
                Query.Disjunction disjunction = (Query.Disjunction)criterion;
                position = JpaQueryBuilder.buildWhereClauseForCriterion(entity, disjunction, q, whereClause, logicalName, disjunction.getCriteria(), position, parameters, conversionService, allowJoins, hibernateCompatible);
                whereClause.append(')');
                return position;
            }
        });
        queryHandlers.put(Query.Equals.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.Equals eq = (Query.Equals)criterion;
                String name = eq.getProperty();
                PersistentProperty prop = JpaQueryBuilder.validateProperty(entity, name, Query.Equals.class);
                Class<?> propType = prop.getType();
                position = JpaQueryBuilder.appendCriteriaForOperator(whereClause, logicalName, name, position, "=", hibernateCompatible);
                parameters.add(conversionService.convert(eq.getValue(), propType));
                return position;
            }
        });
        queryHandlers.put(Query.EqualsProperty.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.EqualsProperty eq = (Query.EqualsProperty)criterion;
                String propertyName = eq.getProperty();
                String otherProperty = eq.getOtherProperty();
                JpaQueryBuilder.validateProperty(entity, propertyName, Query.EqualsProperty.class);
                JpaQueryBuilder.validateProperty(entity, otherProperty, Query.EqualsProperty.class);
                JpaQueryBuilder.appendPropertyComparison(whereClause, logicalName, propertyName, otherProperty, "=");
                return position;
            }
        });
        queryHandlers.put(Query.NotEqualsProperty.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.PropertyComparisonCriterion eq = (Query.PropertyComparisonCriterion)criterion;
                String propertyName = eq.getProperty();
                String otherProperty = eq.getOtherProperty();
                JpaQueryBuilder.validateProperty(entity, propertyName, Query.NotEqualsProperty.class);
                JpaQueryBuilder.validateProperty(entity, otherProperty, Query.NotEqualsProperty.class);
                JpaQueryBuilder.appendPropertyComparison(whereClause, logicalName, propertyName, otherProperty, "!=");
                return position;
            }
        });
        queryHandlers.put(Query.GreaterThanProperty.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.PropertyComparisonCriterion eq = (Query.PropertyComparisonCriterion)criterion;
                String propertyName = eq.getProperty();
                String otherProperty = eq.getOtherProperty();
                JpaQueryBuilder.validateProperty(entity, propertyName, Query.GreaterThanProperty.class);
                JpaQueryBuilder.validateProperty(entity, otherProperty, Query.GreaterThanProperty.class);
                JpaQueryBuilder.appendPropertyComparison(whereClause, logicalName, propertyName, otherProperty, ">");
                return position;
            }
        });
        queryHandlers.put(Query.GreaterThanEqualsProperty.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.PropertyComparisonCriterion eq = (Query.PropertyComparisonCriterion)criterion;
                String propertyName = eq.getProperty();
                String otherProperty = eq.getOtherProperty();
                JpaQueryBuilder.validateProperty(entity, propertyName, Query.GreaterThanEqualsProperty.class);
                JpaQueryBuilder.validateProperty(entity, otherProperty, Query.GreaterThanEqualsProperty.class);
                JpaQueryBuilder.appendPropertyComparison(whereClause, logicalName, propertyName, otherProperty, ">=");
                return position;
            }
        });
        queryHandlers.put(Query.LessThanProperty.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.PropertyComparisonCriterion eq = (Query.PropertyComparisonCriterion)criterion;
                String propertyName = eq.getProperty();
                String otherProperty = eq.getOtherProperty();
                JpaQueryBuilder.validateProperty(entity, propertyName, Query.LessThanProperty.class);
                JpaQueryBuilder.validateProperty(entity, otherProperty, Query.LessThanProperty.class);
                JpaQueryBuilder.appendPropertyComparison(whereClause, logicalName, propertyName, otherProperty, "<");
                return position;
            }
        });
        queryHandlers.put(Query.LessThanEqualsProperty.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.PropertyComparisonCriterion eq = (Query.PropertyComparisonCriterion)criterion;
                String propertyName = eq.getProperty();
                String otherProperty = eq.getOtherProperty();
                JpaQueryBuilder.validateProperty(entity, propertyName, Query.LessThanEqualsProperty.class);
                JpaQueryBuilder.validateProperty(entity, otherProperty, Query.LessThanEqualsProperty.class);
                JpaQueryBuilder.appendPropertyComparison(whereClause, logicalName, propertyName, otherProperty, "<=");
                return position;
            }
        });
        queryHandlers.put(Query.IsNull.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.IsNull isNull = (Query.IsNull)criterion;
                String name = isNull.getProperty();
                JpaQueryBuilder.validateProperty(entity, name, Query.IsNull.class);
                whereClause.append(logicalName).append('.').append(name).append(" IS NULL ");
                return position;
            }
        });
        queryHandlers.put(Query.IsNotNull.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.IsNotNull isNotNull = (Query.IsNotNull)criterion;
                String name = isNotNull.getProperty();
                JpaQueryBuilder.validateProperty(entity, name, Query.IsNotNull.class);
                whereClause.append(logicalName).append('.').append(name).append(" IS NOT NULL ");
                return position;
            }
        });
        queryHandlers.put(Query.IsEmpty.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.IsEmpty isEmpty = (Query.IsEmpty)criterion;
                String name = isEmpty.getProperty();
                JpaQueryBuilder.validateProperty(entity, name, Query.IsEmpty.class);
                whereClause.append(logicalName).append('.').append(name).append(" IS EMPTY ");
                return position;
            }
        });
        queryHandlers.put(Query.IsNotEmpty.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.IsNotEmpty isNotEmpty = (Query.IsNotEmpty)criterion;
                String name = isNotEmpty.getProperty();
                JpaQueryBuilder.validateProperty(entity, name, Query.IsNotEmpty.class);
                whereClause.append(logicalName).append('.').append(name).append(" IS EMPTY ");
                return position;
            }
        });
        queryHandlers.put(Query.IsNotNull.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.IsNotNull isNotNull = (Query.IsNotNull)criterion;
                String name = isNotNull.getProperty();
                JpaQueryBuilder.validateProperty(entity, name, Query.IsNotNull.class);
                whereClause.append(logicalName).append('.').append(name).append(" IS NOT NULL ");
                return position;
            }
        });
        queryHandlers.put(Query.IdEquals.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.IdEquals eq = (Query.IdEquals)criterion;
                PersistentProperty prop = entity.getIdentity();
                Class<?> propType = prop.getType();
                position = JpaQueryBuilder.appendCriteriaForOperator(whereClause, logicalName, prop.getName(), position, "=", hibernateCompatible);
                parameters.add(conversionService.convert(eq.getValue(), propType));
                return position;
            }
        });
        queryHandlers.put(Query.NotEquals.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.NotEquals eq = (Query.NotEquals)criterion;
                String name = eq.getProperty();
                PersistentProperty prop = JpaQueryBuilder.validateProperty(entity, name, Query.NotEquals.class);
                Class<?> propType = prop.getType();
                position = JpaQueryBuilder.appendCriteriaForOperator(whereClause, logicalName, name, position, " != ", hibernateCompatible);
                parameters.add(conversionService.convert(eq.getValue(), propType));
                return position;
            }
        });
        queryHandlers.put(Query.GreaterThan.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.GreaterThan eq = (Query.GreaterThan)criterion;
                String name = eq.getProperty();
                PersistentProperty prop = JpaQueryBuilder.validateProperty(entity, name, Query.GreaterThan.class);
                Class<?> propType = prop.getType();
                position = JpaQueryBuilder.appendCriteriaForOperator(whereClause, logicalName, name, position, " > ", hibernateCompatible);
                parameters.add(conversionService.convert(eq.getValue(), propType));
                return position;
            }
        });
        queryHandlers.put(Query.LessThanEquals.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.LessThanEquals eq = (Query.LessThanEquals)criterion;
                String name = eq.getProperty();
                PersistentProperty prop = JpaQueryBuilder.validateProperty(entity, name, Query.LessThanEquals.class);
                Class<?> propType = prop.getType();
                position = JpaQueryBuilder.appendCriteriaForOperator(whereClause, logicalName, name, position, " <= ", hibernateCompatible);
                parameters.add(conversionService.convert(eq.getValue(), propType));
                return position;
            }
        });
        queryHandlers.put(Query.GreaterThanEquals.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.GreaterThanEquals eq = (Query.GreaterThanEquals)criterion;
                String name = eq.getProperty();
                PersistentProperty prop = JpaQueryBuilder.validateProperty(entity, name, Query.GreaterThanEquals.class);
                Class<?> propType = prop.getType();
                position = JpaQueryBuilder.appendCriteriaForOperator(whereClause, logicalName, name, position, " >= ", hibernateCompatible);
                parameters.add(conversionService.convert(eq.getValue(), propType));
                return position;
            }
        });
        queryHandlers.put(Query.Between.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.Between between = (Query.Between)criterion;
                Object from = between.getFrom();
                Object to = between.getTo();
                String name = between.getProperty();
                PersistentProperty prop = JpaQueryBuilder.validateProperty(entity, name, Query.Between.class);
                Class<?> propType = prop.getType();
                String qualifiedName = logicalName + '.' + name;
                whereClause.append('(').append(qualifiedName).append(" >= ").append(JpaQueryBuilder.PARAMETER_PREFIX).append(++position);
                whereClause.append(JpaQueryBuilder.LOGICAL_AND).append(qualifiedName).append(" <= ").append(JpaQueryBuilder.PARAMETER_PREFIX).append(++position).append(')');
                parameters.add(conversionService.convert(from, propType));
                parameters.add(conversionService.convert(to, propType));
                return position;
            }
        });
        queryHandlers.put(Query.LessThan.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.LessThan eq = (Query.LessThan)criterion;
                String name = eq.getProperty();
                PersistentProperty prop = JpaQueryBuilder.validateProperty(entity, name, Query.LessThan.class);
                Class<?> propType = prop.getType();
                position = JpaQueryBuilder.appendCriteriaForOperator(whereClause, logicalName, name, position, " < ", hibernateCompatible);
                parameters.add(conversionService.convert(eq.getValue(), propType));
                return position;
            }
        });
        queryHandlers.put(Query.Like.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.Like eq = (Query.Like)criterion;
                String name = eq.getProperty();
                PersistentProperty prop = JpaQueryBuilder.validateProperty(entity, name, Query.Like.class);
                Class<?> propType = prop.getType();
                position = JpaQueryBuilder.appendCriteriaForOperator(whereClause, logicalName, name, position, " like ", hibernateCompatible);
                parameters.add(conversionService.convert(eq.getValue(), propType));
                return position;
            }
        });
        queryHandlers.put(Query.ILike.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.ILike eq = (Query.ILike)criterion;
                String name = eq.getProperty();
                PersistentProperty prop = JpaQueryBuilder.validateProperty(entity, name, Query.ILike.class);
                Class<?> propType = prop.getType();
                whereClause.append("lower(").append(logicalName).append('.').append(name).append(")").append(" like lower(").append(JpaQueryBuilder.PARAMETER_PREFIX).append(++position).append(")");
                parameters.add(conversionService.convert(eq.getValue(), propType));
                return position;
            }
        });
        queryHandlers.put(Query.In.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.In inQuery = (Query.In)criterion;
                String name = inQuery.getProperty();
                PersistentProperty prop = JpaQueryBuilder.validateProperty(entity, name, Query.In.class);
                Class<?> propType = prop.getType();
                whereClause.append(logicalName).append('.').append(name).append(" IN (");
                QueryableCriteria subquery = inQuery.getSubquery();
                if (subquery != null) {
                    JpaQueryBuilder.buildSubQuery(q, whereClause, position, parameters, conversionService, allowJoins, hibernateCompatible, subquery);
                } else {
                    Iterator i = inQuery.getValues().iterator();
                    while (i.hasNext()) {
                        Object val = i.next();
                        whereClause.append(JpaQueryBuilder.PARAMETER_PREFIX);
                        whereClause.append(++position);
                        if (i.hasNext()) {
                            whereClause.append(',');
                        }
                        parameters.add(conversionService.convert(val, propType));
                    }
                }
                whereClause.append(')');
                return position;
            }
        });
        queryHandlers.put(Query.NotIn.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.NotIn notIn = (Query.NotIn)criterion;
                String comparisonExpression = " NOT IN (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, notIn, comparisonExpression);
            }
        });
        queryHandlers.put(Query.EqualsAll.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.EqualsAll equalsAll = (Query.EqualsAll)criterion;
                String comparisonExpression = " = ALL (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, equalsAll, comparisonExpression);
            }
        });
        queryHandlers.put(Query.NotEqualsAll.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.SubqueryCriterion equalsAll = (Query.SubqueryCriterion)criterion;
                String comparisonExpression = " != ALL (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, equalsAll, comparisonExpression);
            }
        });
        queryHandlers.put(Query.GreaterThanAll.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.SubqueryCriterion equalsAll = (Query.SubqueryCriterion)criterion;
                String comparisonExpression = " > ALL (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, equalsAll, comparisonExpression);
            }
        });
        queryHandlers.put(Query.GreaterThanSome.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.SubqueryCriterion equalsAll = (Query.SubqueryCriterion)criterion;
                String comparisonExpression = " > SOME (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, equalsAll, comparisonExpression);
            }
        });
        queryHandlers.put(Query.GreaterThanEqualsAll.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.SubqueryCriterion equalsAll = (Query.SubqueryCriterion)criterion;
                String comparisonExpression = " >= ALL (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, equalsAll, comparisonExpression);
            }
        });
        queryHandlers.put(Query.GreaterThanEqualsSome.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.SubqueryCriterion equalsAll = (Query.SubqueryCriterion)criterion;
                String comparisonExpression = " >= SOME (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, equalsAll, comparisonExpression);
            }
        });
        queryHandlers.put(Query.LessThanAll.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.SubqueryCriterion subqueryCriterion = (Query.SubqueryCriterion)criterion;
                String comparisonExpression = " < ALL (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, subqueryCriterion, comparisonExpression);
            }
        });
        queryHandlers.put(Query.LessThanSome.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.SubqueryCriterion subqueryCriterion = (Query.SubqueryCriterion)criterion;
                String comparisonExpression = " < SOME (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, subqueryCriterion, comparisonExpression);
            }
        });
        queryHandlers.put(Query.LessThanEqualsAll.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.SubqueryCriterion subqueryCriterion = (Query.SubqueryCriterion)criterion;
                String comparisonExpression = " <= ALL (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, subqueryCriterion, comparisonExpression);
            }
        });
        queryHandlers.put(Query.LessThanEqualsSome.class, new QueryHandler(){

            @Override
            public int handle(PersistentEntity entity, Query.Criterion criterion, StringBuilder q, StringBuilder whereClause, String logicalName, int position, List parameters, ConversionService conversionService, boolean allowJoins, boolean hibernateCompatible) {
                Query.SubqueryCriterion subqueryCriterion = (Query.SubqueryCriterion)criterion;
                String comparisonExpression = " <= SOME (";
                return JpaQueryBuilder.handleSubQuery(entity, q, whereClause, logicalName, position, parameters, conversionService, allowJoins, hibernateCompatible, subqueryCriterion, comparisonExpression);
            }
        });
    }

    private static interface QueryHandler {
        public int handle(PersistentEntity var1, Query.Criterion var2, StringBuilder var3, StringBuilder var4, String var5, int var6, List var7, ConversionService var8, boolean var9, boolean var10);
    }
}

