/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DetachedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedVariantResultSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentResultSerializer
implements Serializer<ResolvedGraphComponent> {
    private final ModuleVersionIdentifierSerializer idSerializer;
    private final ComponentSelectionReasonSerializer reasonSerializer;
    private final ComponentIdentifierSerializer componentIdSerializer;
    private final ResolvedVariantResultSerializer resolvedVariantResultSerializer;

    public ComponentResultSerializer(ImmutableModuleIdentifierFactory moduleIdentifierFactory, ResolvedVariantResultSerializer resolvedVariantResultSerializer) {
        this.idSerializer = new ModuleVersionIdentifierSerializer(moduleIdentifierFactory);
        this.resolvedVariantResultSerializer = resolvedVariantResultSerializer;
        this.reasonSerializer = new ComponentSelectionReasonSerializer();
        this.componentIdSerializer = new ComponentIdentifierSerializer();
    }

    void reset() {
        this.resolvedVariantResultSerializer.reset();
    }

    public ResolvedGraphComponent read(Decoder decoder) throws IOException {
        long resultId = decoder.readSmallLong();
        ModuleVersionIdentifier id = this.idSerializer.read(decoder);
        ComponentSelectionReason reason = this.reasonSerializer.read(decoder);
        ComponentIdentifier componentId = this.componentIdSerializer.read(decoder);
        List<ResolvedVariantResult> resolvedVariants = this.readResolvedVariants(decoder);
        String repositoryName = decoder.readNullableString();
        return new DetachedComponentResult(resultId, id, reason, componentId, resolvedVariants, repositoryName);
    }

    private List<ResolvedVariantResult> readResolvedVariants(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)this.resolvedVariantResultSerializer.read(decoder));
        }
        return builder.build();
    }

    public void write(Encoder encoder, ResolvedGraphComponent value) throws IOException {
        encoder.writeSmallLong(value.getResultId().longValue());
        this.idSerializer.write(encoder, value.getModuleVersion());
        this.reasonSerializer.write(encoder, value.getSelectionReason());
        this.componentIdSerializer.write(encoder, value.getComponentId());
        this.writeSelectedVariantDetails(encoder, value.getResolvedVariants());
        encoder.writeNullableString((CharSequence)value.getRepositoryName());
    }

    private void writeSelectedVariantDetails(Encoder encoder, List<ResolvedVariantResult> variants) throws IOException {
        encoder.writeSmallInt(variants.size());
        for (ResolvedVariantResult variant : variants) {
            this.resolvedVariantResultSerializer.write(encoder, variant);
        }
    }
}

