/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Arrays;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.internal.classpath.ClassPath;

public class DependencyClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;
    private final PluginModuleRegistry pluginModuleRegistry;
    private ClassPath gradleApi;

    public DependencyClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.pluginModuleRegistry = pluginModuleRegistry;
    }

    @Override
    public ClassPath findClassPath(String name) {
        if (name.equals(DependencyFactory.ClassPathNotation.GRADLE_API.name())) {
            return this.gradleApi();
        }
        if (name.equals(DependencyFactory.ClassPathNotation.GRADLE_TEST_KIT.name())) {
            return this.gradleTestKit();
        }
        if (name.equals(DependencyFactory.ClassPathNotation.LOCAL_GROOVY.name())) {
            return this.localGroovy();
        }
        if (name.equals(DependencyFactory.ClassPathNotation.GRADLE_KOTLIN_DSL.name())) {
            return this.gradleKotlinDsl();
        }
        return null;
    }

    private ClassPath gradleApi() {
        if (this.gradleApi == null) {
            this.gradleApi = this.initGradleApi();
        }
        return this.gradleApi;
    }

    private ClassPath initGradleApi() {
        ClassPath classpath = ClassPath.EMPTY;
        for (String moduleName : Arrays.asList("gradle-worker-processes", "gradle-core", "gradle-workers", "gradle-dependency-management", "gradle-plugin-use", "gradle-tooling-api")) {
            classpath = classpath.plus(this.moduleRegistry.getModule(moduleName).getAllRequiredModulesClasspath());
        }
        for (Module pluginModule : this.pluginModuleRegistry.getApiModules()) {
            classpath = classpath.plus(pluginModule.getClasspath());
        }
        return classpath;
    }

    private ClassPath gradleTestKit() {
        return this.moduleRegistry.getModule("gradle-test-kit").getClasspath();
    }

    private ClassPath localGroovy() {
        return this.moduleRegistry.getExternalModule("groovy-all").getClasspath();
    }

    private ClassPath gradleKotlinDsl() {
        return this.moduleRegistry.getModule("gradle-kotlin-dsl").getAllRequiredModulesClasspath();
    }
}

