/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.regex.Pattern;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.ui.dialogs.DialogsMessages;
import org.eclipse.cdt.ui.dialogs.IInputStatusValidator;
import org.eclipse.cdt.ui.dialogs.InputStatusDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class RegularExpressionStatusDialog
extends InputStatusDialog {
    private static final IInputStatusValidator fValidator = new IInputStatusValidator(){

        @Override
        public IStatus isValid(String newText) {
            StatusInfo status = new StatusInfo();
            if (newText.length() == 0) {
                status.setWarning(DialogsMessages.RegularExpression_EmptyPattern);
            } else {
                try {
                    Pattern.compile(newText);
                }
                catch (Exception e) {
                    status.setError(e.getMessage().split("[\n\r]", 2)[0]);
                }
            }
            return status;
        }
    };

    public RegularExpressionStatusDialog(Shell shell, String initialValue) {
        super(shell, DialogsMessages.RegularExpression_Validate, DialogsMessages.RegularExpression_Enter, initialValue, fValidator);
    }

    public RegularExpressionStatusDialog(Shell shell, String dialogTitle, String dialogMessage, String initialValue) {
        super(shell, dialogTitle, dialogMessage, initialValue, fValidator);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        new ContentAssistCommandAdapter((Control)this.getText(), (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new FindReplaceDocumentAdapterContentProposalProvider(true), null, null, true);
        this.setHelpAvailable(false);
        return control;
    }

    public void create() {
        super.create();
        if (this.getValue().length() > 0) {
            this.validateInput();
        }
    }
}

