/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public abstract class CRefactoringDescriptor
extends RefactoringDescriptor {
    public static final String FILE_NAME = "fileName";
    public static final String SELECTION = "selection";
    protected Map<String, String> arguments;

    public CRefactoringDescriptor(String id, String project, String description, String comment, int flags, Map<String, String> arguments) {
        super(id, project, description, comment, flags);
        this.arguments = arguments;
    }

    public Map<String, String> getParameterMap() {
        return this.arguments;
    }

    public abstract CRefactoring createRefactoring(RefactoringStatus var1) throws CoreException;

    public CRefactoringContext createRefactoringContext(RefactoringStatus status) throws CoreException {
        CRefactoring refactoring = this.createRefactoring(status);
        if (refactoring == null) {
            return null;
        }
        return new CRefactoringContext(refactoring);
    }

    protected ISelection getSelection() throws CoreException {
        String[] selectStrings = this.arguments.get(SELECTION).split(",");
        if (selectStrings.length < 2) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", Messages.CRefactoringDescriptor_illegal_selection));
        }
        int offset = Integer.parseInt(selectStrings[0]);
        int length = Integer.parseInt(selectStrings[1]);
        TextSelection selection = new TextSelection(offset, length);
        return selection;
    }

    protected ICProject getCProject() throws CoreException {
        String projectName = this.getProject();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ICProject cProject = CoreModel.getDefault().create(project);
        if (cProject == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", NLS.bind((String)Messages.CRefactoringDescriptor_unknown_project, (Object)projectName)));
        }
        return cProject;
    }

    protected IFile getFile() throws CoreException {
        try {
            String filename = this.arguments.get(FILE_NAME);
            return ResourceLookup.selectFileForLocationURI((URI)new URI(filename), (IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProject()));
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", e.getMessage(), (Throwable)e));
        }
    }

    protected ITranslationUnit getTranslationUnit() throws CoreException {
        try {
            String filename = this.arguments.get(FILE_NAME);
            return CoreModelUtil.findTranslationUnitForLocation((URI)new URI(filename), (ICProject)this.getCProject());
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", e.getMessage(), (Throwable)e));
        }
    }
}

