/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.gis.GisTransformUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class ShowSRIDDialog
extends BaseDialog {
    private static final Log log = Log.getLog(ShowSRIDDialog.class);
    private static final String DIALOG_ID = "DBeaver.ShowSRIDDialog";
    private int selectedSRID;

    public ShowSRIDDialog(Shell shell, int defCRS) {
        super(shell, "Select Coordinate Reference System (CRS) Identifier", null);
        this.selectedSRID = defCRS;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        try {
            CoordinateReferenceSystem crs = GisTransformUtils.getCRSFactory().getCRS("EPSG:" + this.selectedSRID);
            Group crsGroup = UIUtils.createControlGroup((Composite)dialogArea, (String)"CRS details", (int)2, (int)0, (int)0);
            crsGroup.setLayoutData((Object)new GridData(1808));
            UIUtils.createLabelText((Composite)crsGroup, (String)"SRID", (String)String.valueOf(this.selectedSRID), (int)2056);
            UIUtils.createLabelText((Composite)crsGroup, (String)"Name", (String)crs.getName(), (int)2056);
            UIUtils.createLabelText((Composite)crsGroup, (String)"Coordinate System", (String)crs.getCoordinateSystem().toString(), (int)2056);
            UIUtils.createLabelText((Composite)crsGroup, (String)"Projection", (String)(crs.getProjection() == null ? "N/A" : crs.getProjection().toString()), (int)2056);
            UIUtils.createLabelText((Composite)crsGroup, (String)"Type", (String)(crs.getType() == null ? "N/A" : crs.getType().toString()), (int)2056);
            Text wktText = UIUtils.createLabelText((Composite)crsGroup, (String)"WKT", (String)crs.toWKT(), (int)2634);
            GridData gd = new GridData(1808);
            gd.heightHint = UIUtils.getFontHeight((Control)wktText) * 15;
            gd.widthHint = UIUtils.getFontHeight((Control)wktText) * 40;
            wktText.setLayoutData((Object)gd);
        }
        catch (CRSException e) {
            DBWorkbench.getPlatformUI().showError("CRS error", "Error reading SRID " + this.selectedSRID + " details", (Throwable)e);
        }
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

