/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskRegistry;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.ProjectMetadata;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.task.TaskRunJob;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class TaskManagerImpl
implements DBTTaskManager {
    public static final String TEMPORARY_ID = "#temp";
    private static final Log log = Log.getLog(TaskManagerImpl.class);
    public static final String CONFIG_FILE = "tasks.json";
    public static final String TASK_STATS_FOLDER = "task-stats";
    private static Gson CONFIG_GSON = new GsonBuilder().setLenient().serializeNulls().setPrettyPrinting().create();
    static final SimpleDateFormat systemDateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.ENGLISH);
    private final ProjectMetadata projectMetadata;
    private final List<TaskImpl> tasks = new ArrayList<TaskImpl>();
    private File statisticsFolder;

    public TaskManagerImpl(ProjectMetadata projectMetadata) {
        this.projectMetadata = projectMetadata;
        this.statisticsFolder = new File(projectMetadata.getWorkspace().getMetadataFolder(), TASK_STATS_FOLDER);
        this.loadConfiguration();
    }

    @NotNull
    public DBTTaskRegistry getRegistry() {
        return TaskRegistry.getInstance();
    }

    @NotNull
    public DBPProject getProject() {
        return this.projectMetadata;
    }

    @NotNull
    public DBTTask[] getAllTasks() {
        return this.tasks.toArray(new DBTTask[0]);
    }

    @Nullable
    public DBTTask getTaskById(@NotNull String id) {
        for (DBTTask dBTTask : this.tasks) {
            if (!id.equals(dBTTask.getId())) continue;
            return dBTTask;
        }
        return null;
    }

    @Nullable
    public DBTTask getTaskByName(@NotNull String name) {
        for (DBTTask dBTTask : this.tasks) {
            if (!name.equals(dBTTask.getName())) continue;
            return dBTTask;
        }
        return null;
    }

    @NotNull
    public DBTTaskType[] getExistingTaskTypes() {
        LinkedHashSet<DBTTaskType> result = new LinkedHashSet<DBTTaskType>();
        for (DBTTask dBTTask : this.tasks) {
            result.add(dBTTask.getType());
        }
        return result.toArray(new DBTTaskType[0]);
    }

    @NotNull
    public DBTTask[] getAllTaskByType(DBTTaskType task) {
        ArrayList<DBTTask> result = new ArrayList<DBTTask>();
        for (DBTTask dBTTask : this.tasks) {
            if (dBTTask.getType() != task) continue;
            result.add(dBTTask);
        }
        return result.toArray(new DBTTask[0]);
    }

    @NotNull
    public DBTTask createTask(@NotNull DBTTaskType taskDescriptor, @NotNull String label, @Nullable String description, @NotNull Map<String, Object> properties) throws DBException {
        if (this.getTaskByName(label) != null) {
            throw new DBException("Task with name '" + label + "' already exists");
        }
        Date createTime = new Date();
        String id = UUID.randomUUID().toString();
        TaskImpl task = new TaskImpl(this.projectMetadata, taskDescriptor, id, label, description, createTime, createTime);
        task.setProperties(properties);
        return task;
    }

    @NotNull
    public DBTTask createTemporaryTask(@NotNull DBTTaskType type, @NotNull String label) {
        return new TaskImpl(this.getProject(), type, TEMPORARY_ID, label, label, new Date(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaskConfiguration(@NotNull DBTTask task) throws DBException {
        if (TEMPORARY_ID.equals(task.getId())) {
            return;
        }
        DBTTask prevTask = this.getTaskByName(task.getName());
        if (prevTask != null && prevTask != task) {
            throw new DBException("Task with name '" + task.getName() + "' already exists");
        }
        boolean newTask = false;
        List<TaskImpl> list = this.tasks;
        synchronized (list) {
            if (!this.tasks.contains(task)) {
                this.tasks.add((TaskImpl)task);
                newTask = true;
            }
        }
        this.saveConfiguration();
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent(task, newTask ? DBTTaskEvent.Action.TASK_ADD : DBTTaskEvent.Action.TASK_UPDATE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTaskConfiguration(@NotNull DBTTask task) {
        List<TaskImpl> list = this.tasks;
        synchronized (list) {
            this.tasks.remove(task);
        }
        this.saveConfiguration();
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent(task, DBTTaskEvent.Action.TASK_REMOVE));
    }

    @NotNull
    public File getStatisticsFolder() {
        return this.statisticsFolder;
    }

    public Job runTask(@NotNull DBTTask task, @NotNull DBTTaskExecutionListener listener, @NotNull Map<String, Object> options) {
        TaskRunJob runJob = new TaskRunJob((TaskImpl)task, Locale.getDefault(), listener);
        runJob.schedule();
        return runJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        IFile configFile = this.getConfigFile(false);
        if (!configFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = configFile.getContents();){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (InputStreamReader configReader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    Map jsonMap = JSONUtils.parseMap((Gson)CONFIG_GSON, (Reader)configReader);
                    for (Map.Entry taskMap : jsonMap.entrySet()) {
                        Map taskJSON = (Map)taskMap.getValue();
                        try {
                            String id = (String)taskMap.getKey();
                            String task = JSONUtils.getString((Map)taskJSON, (String)"task");
                            String label = CommonUtils.toString((Object)JSONUtils.getString((Map)taskJSON, (String)"label"), (String)id);
                            String description = JSONUtils.getString((Map)taskJSON, (String)"description");
                            Date createTime = systemDateFormat.parse(JSONUtils.getString((Map)taskJSON, (String)"createTime"));
                            Date updateTime = systemDateFormat.parse(JSONUtils.getString((Map)taskJSON, (String)"updateTime"));
                            Map state = JSONUtils.getObject((Map)taskJSON, (String)"state");
                            DBTTaskType taskDescriptor = this.getRegistry().getTaskType(task);
                            if (taskDescriptor == null) {
                                log.error((Object)("Can't find task descriptor " + task));
                                continue;
                            }
                            TaskImpl taskConfig = new TaskImpl(this.projectMetadata, taskDescriptor, id, label, description, createTime, updateTime);
                            taskConfig.setProperties(state);
                            List<TaskImpl> list = this.tasks;
                            synchronized (list) {
                                this.tasks.add(taskConfig);
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)"Error parsing task configuration", (Throwable)e);
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading tasks configuration", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfiguration() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFile configFile = this.getConfigFile(true);
        try {
            if (configFile.exists()) {
                ContentUtils.makeFileBackup((IFile)configFile);
            }
            if (this.tasks.isEmpty()) {
                configFile.delete(true, false, (IProgressMonitor)monitor);
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error processing config file", (Throwable)e);
        }
        ByteArrayOutputStream dsConfigBuffer = new ByteArrayOutputStream(10000);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dsConfigBuffer, StandardCharsets.UTF_8);){
                Throwable throwable2 = null;
                Object var8_14 = null;
                try (JsonWriter jsonWriter = CONFIG_GSON.newJsonWriter((Writer)osw);){
                    List<TaskImpl> list = this.tasks;
                    synchronized (list) {
                        this.serializeTasks((DBRProgressMonitor)new DefaultProgressMonitor((IProgressMonitor)monitor), jsonWriter);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            return;
        }
        ByteArrayInputStream ifs = new ByteArrayInputStream(dsConfigBuffer.toByteArray());
        try {
            if (!configFile.exists()) {
                configFile.create((InputStream)ifs, true, (IProgressMonitor)monitor);
                configFile.setHidden(true);
            } else {
                configFile.setContents((InputStream)ifs, true, false, (IProgressMonitor)monitor);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error saving configuration to a file " + configFile.getFullPath()), (Throwable)e);
        }
    }

    private void serializeTasks(DBRProgressMonitor monitor, JsonWriter jsonWriter) throws IOException {
        jsonWriter.setIndent("\t");
        jsonWriter.beginObject();
        for (TaskImpl task : this.tasks) {
            jsonWriter.name(task.getId());
            jsonWriter.beginObject();
            JSONUtils.field((JsonWriter)jsonWriter, (String)"task", (String)task.getType().getId());
            JSONUtils.field((JsonWriter)jsonWriter, (String)"label", (String)task.getName());
            JSONUtils.field((JsonWriter)jsonWriter, (String)"description", (String)task.getDescription());
            JSONUtils.field((JsonWriter)jsonWriter, (String)"createTime", (String)systemDateFormat.format(task.getCreateTime()));
            JSONUtils.field((JsonWriter)jsonWriter, (String)"updateTime", (String)systemDateFormat.format(task.getUpdateTime()));
            JSONUtils.serializeProperties((JsonWriter)jsonWriter, (String)"state", task.getProperties());
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
    }

    private IFile getConfigFile(boolean create) {
        return this.projectMetadata.getMetadataFolder(create).getFile(CONFIG_FILE);
    }
}

