import * as LSP from 'vscode-languageserver';
/**
 * The BashServer glues together the separate components to implement
 * the various parts of the Language Server Protocol.
 */
export default class BashServer {
    /**
     * Initialize the server based on a connection to the client and the protocols
     * initialization parameters.
     */
    static initialize(connection: LSP.Connection, { rootPath }: LSP.InitializeParams): Promise<BashServer>;
    private executables;
    private analyzer;
    private documents;
    private connection;
    private constructor();
    /**
     * Register handlers for the events from the Language Server Protocol that we
     * care about.
     */
    register(connection: LSP.Connection): void;
    /**
     * The parts of the Language Server Protocol that we are currently supporting.
     */
    capabilities(): LSP.ServerCapabilities;
    private getWordAtPoint;
    private onHover;
    private onDefinition;
    private onDocumentSymbol;
    private onDocumentHighlight;
    private onReferences;
    private onCompletion;
    private onCompletionResolve;
}
