/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.Size;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XItemEventBroadcaster;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.HelpIds;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.IRenderer;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.PropertySetHelper;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.event.XActionListenerAdapter;
import java.util.ArrayList;
import javax.swing.ListModel;

public class ButtonList
implements XItemEventBroadcaster,
XActionListener {
    private XFixedText lblImageText;
    private XButton btnBack;
    private XButton btnNext;
    private XFixedText lblCounter;
    private XControl[] m_aButtons;
    private boolean benabled = true;
    private UnoDialog2 oUnoDialog;
    private Size gap = new Size(4, 4);
    private int cols = 4;
    private int rows = 3;
    private Size m_aButtonSize = new Size(20, 20);
    private Size pos;
    private boolean showButtons = true;
    private Short step;
    private static final boolean refreshOverNull = true;
    private static final int imageTextLines = 1;
    private boolean rowSelect = false;
    public int tabIndex;
    private String m_aControlName = "il";
    private int m_nCurrentSelection = -1;
    private int pageStart = 0;
    public int helpURL = 0;
    private IRenderer renderer;
    private ListModel listModel;
    private IRenderer counterRenderer = new SimpleCounterRenderer();
    private static final int LINE_HEIGHT = 8;
    private Integer m_aButtonHeight;
    private Integer m_aButtonWidth;
    private Short m_tabIndex;
    private transient ArrayList<XItemListener> m_aItemListenerList;

    public void setName(String _sName) {
        this.m_aControlName = _sName;
    }

    public void setButtonSize(Size imageSize) {
        this.m_aButtonSize = imageSize;
    }

    public void disposing(EventObject arg0) {
    }

    public void create(UnoDialog2 dialog) {
        this.oUnoDialog = dialog;
        int imageTextHeight = 8;
        int nXPos = this.pos.Width + 1;
        int nYPos = this.pos.Height + (this.m_aButtonSize.Height + this.gap.Height) * this.rows + this.gap.Height;
        int nWidth = this.cols * (this.m_aButtonSize.Width + this.gap.Width) + this.gap.Width - 2;
        this.lblImageText = dialog.insertLabel(this.m_aControlName + "_imageText", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", PropertyNames.PROPERTY_WIDTH}, new Object[]{imageTextHeight, PropertyNames.EMPTY_STRING, "(1)", nXPos, nYPos, this.step, (short)0, Boolean.FALSE, nWidth});
        if (this.showButtons) {
            String[] pNames1 = new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", PropertyNames.PROPERTY_WIDTH};
            Integer btnSize = 14;
            this.btnBack = dialog.insertButton(this.m_aControlName + "_btnBack", new XActionListenerAdapter(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ButtonList.this.prevPage();
                }
            }, pNames1, new Object[]{btnSize, HelpIds.getHelpIdString(this.helpURL++), this.pos.Width, this.pos.Height + (this.m_aButtonSize.Height + this.gap.Height) * this.rows + this.gap.Height + imageTextHeight + 1, this.step, (short)(this.tabIndex + 1), Boolean.TRUE, btnSize});
            this.btnNext = dialog.insertButton(this.m_aControlName + "_btnNext", new XActionListenerAdapter(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ButtonList.this.nextPage();
                }
            }, pNames1, new Object[]{btnSize, HelpIds.getHelpIdString(this.helpURL++), this.pos.Width + (this.m_aButtonSize.Width + this.gap.Width) * this.cols + this.gap.Width - btnSize + 1, this.pos.Height + (this.m_aButtonSize.Height + this.gap.Height) * this.rows + this.gap.Height + imageTextHeight + 1, this.step, (short)(this.tabIndex + 2), Boolean.TRUE, btnSize});
            this.lblCounter = dialog.insertLabel(this.m_aControlName + "_lblCounter", pNames1, new Object[]{8, PropertyNames.EMPTY_STRING, this.pos.Width + btnSize + 1, this.pos.Height + (this.m_aButtonSize.Height + this.gap.Height) * this.rows + this.gap.Height + imageTextHeight + (btnSize - 8) / 2, this.step, (short)0, Boolean.FALSE, this.cols * (this.m_aButtonSize.Width + this.gap.Width) + this.gap.Width - 2 * btnSize - 1});
            Helper.setUnoPropertyValue(this.getModel(this.lblCounter), PropertyNames.PROPERTY_ALIGN, (short)1);
            Helper.setUnoPropertyValue(this.getModel(this.btnBack), PropertyNames.PROPERTY_LABEL, "<");
            Helper.setUnoPropertyValue(this.getModel(this.btnNext), PropertyNames.PROPERTY_LABEL, ">");
        }
        this.m_tabIndex = (short)this.tabIndex;
        this.m_aButtons = new XControl[this.rows * this.cols];
        this.m_aButtonHeight = this.m_aButtonSize.Height;
        this.m_aButtonWidth = this.m_aButtonSize.Width;
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                XControl aControl;
                XButton aButton = this.createButton(dialog, r, c);
                this.m_aButtons[r * this.cols + c] = aControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)aButton);
            }
        }
        this.refreshImages();
    }

    private XButton createButton(UnoDialog2 dialog, int _row, int _col) {
        String sButtonName = this.m_aControlName + "_button" + (_row * this.cols + _col);
        int nButtonX = this.getButtonPosX(_col);
        int nButtonY = this.getButtonPosY(_row);
        XButton aButton = dialog.insertImageButton(sButtonName, this, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", "Toggle", PropertyNames.PROPERTY_WIDTH}, new Object[]{this.m_aButtonHeight, HelpIds.getHelpIdString(this.helpURL++), nButtonX, nButtonY, this.step, this.m_tabIndex, Boolean.TRUE, Boolean.TRUE, this.m_aButtonWidth});
        XWindow win = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)aButton);
        win.setEnable(true);
        win.setVisible(true);
        return aButton;
    }

    private int getButtonPosX(int _col) {
        return this.pos.Width + _col * (this.m_aButtonSize.Width + this.gap.Width) + this.gap.Width;
    }

    private int getButtonPosY(int _row) {
        return this.pos.Height + _row * (this.m_aButtonSize.Height + this.gap.Height) + this.gap.Height;
    }

    private void refreshImages() {
        int i;
        if (this.showButtons) {
            this.refreshCounterText();
        }
        for (i = 0; i < this.m_aButtons.length; ++i) {
            this.setVisible(this.m_aButtons[i], false);
        }
        for (i = 0; i < this.m_aButtons.length; ++i) {
            String oResource = this.getObjectFor(i);
            if (oResource == null) continue;
            this.oUnoDialog.getPeerConfiguration().setImageUrl(this.m_aButtons[i].getModel(), oResource);
            boolean bTabStop = Boolean.TRUE;
            Helper.setUnoPropertyValue(this.m_aButtons[i].getModel(), "Tabstop", bTabStop);
            this.setVisible(this.m_aButtons[i], true);
        }
    }

    private void refreshCounterText() {
        Helper.setUnoPropertyValue(this.getModel(this.lblCounter), PropertyNames.PROPERTY_LABEL, this.counterRenderer.render(new Counter(this.pageStart + 1, this.pageEnd(), this.listModel.getSize())));
    }

    private int pageEnd() {
        int i = this.pageStart + this.cols * this.rows;
        if (i > this.listModel.getSize() - 1) {
            return this.listModel.getSize();
        }
        return i;
    }

    private void setVisible(Object control, boolean visible) {
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)control);
        xWindow.setVisible(visible);
    }

    private String getObjectFor(int i) {
        int ii = this.getIndexFor(i);
        if (this.listModel.getSize() <= ii) {
            return null;
        }
        return (String)this.listModel.getElementAt(ii);
    }

    private int getIndexFor(int i) {
        return this.pageStart + i;
    }

    public synchronized void addItemListener(XItemListener listener) {
        if (this.m_aItemListenerList == null) {
            this.m_aItemListenerList = new ArrayList();
        }
        this.m_aItemListenerList.add(listener);
    }

    public synchronized void removeItemListener(XItemListener listener) {
        if (this.m_aItemListenerList != null) {
            this.m_aItemListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireItemSelected() {
        ArrayList list;
        ButtonList buttonList = this;
        synchronized (buttonList) {
            if (this.m_aItemListenerList == null) {
                return;
            }
            list = (ArrayList)this.m_aItemListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((XItemListener)list.get(i)).itemStateChanged(null);
        }
    }

    private ListModel getListModel() {
        return this.listModel;
    }

    public int getSelected() {
        return this.m_nCurrentSelection;
    }

    public void setCols(int i) {
        this.cols = i;
    }

    public void setGap(Size size) {
        this.gap = size;
    }

    public void setListModel(ListModel model) {
        this.listModel = model;
    }

    public void setStep(Short short1) {
        this.step = short1;
    }

    private void setPageStart(int i) {
        if (i == this.pageStart) {
            return;
        }
        this.pageStart = i;
        this.enableButtons();
        this.refreshImages();
    }

    public void setPos(Size _size) {
        this.pos = _size;
    }

    public void setRenderer(IRenderer _renderer) {
        this.renderer = _renderer;
    }

    public void setRows(int i) {
        this.rows = i;
    }

    public void setSelected(int i) {
        if (this.rowSelect && i >= 0) {
            i = i / this.cols * this.cols;
        }
        if (this.m_nCurrentSelection == i) {
            return;
        }
        this.m_nCurrentSelection = i;
        this.refreshImageText();
        this.refreshSelection();
        this.fireItemSelected();
    }

    private void refreshImageText() {
        Object item = this.m_nCurrentSelection >= 0 ? this.getListModel().getElementAt(this.m_nCurrentSelection) : null;
        String sText = item != null ? PropertyNames.SPACE + this.renderer.render(item) : "";
        Helper.setUnoPropertyValue(this.getModel(this.lblImageText), PropertyNames.PROPERTY_LABEL, sText);
    }

    public void setShowButtons(boolean b) {
        this.showButtons = b;
    }

    private void nextPage() {
        if (this.pageStart < this.getListModel().getSize() - this.rows * this.cols) {
            this.setPageStart(this.pageStart + this.rows * this.cols);
        }
    }

    private void prevPage() {
        if (this.pageStart == 0) {
            return;
        }
        int i = this.pageStart - this.rows * this.cols;
        if (i < 0) {
            i = 0;
        }
        this.setPageStart(i);
    }

    private void enableButtons() {
        this.enable(this.btnNext, this.pageStart + this.rows * this.cols < this.listModel.getSize());
        this.enable(this.btnBack, this.pageStart > 0);
    }

    private void enable(Object control, Boolean enable) {
        Helper.setUnoPropertyValue(this.getModel(control), PropertyNames.PROPERTY_ENABLED, enable);
    }

    private Object getModel(Object control) {
        return ((XControl)UnoRuntime.queryInterface(XControl.class, (Object)control)).getModel();
    }

    public boolean isenabled() {
        return this.benabled;
    }

    public void setenabled(boolean b) {
        for (int i = 0; i < this.m_aButtons.length; ++i) {
            UnoDialog2.setEnabled((Object)this.m_aButtons[i], b);
        }
        UnoDialog2.setEnabled((Object)this.lblImageText, b);
        if (this.showButtons) {
            UnoDialog2.setEnabled((Object)this.btnBack, b);
            UnoDialog2.setEnabled((Object)this.btnNext, b);
            UnoDialog2.setEnabled((Object)this.lblCounter, b);
        }
        this.benabled = b;
    }

    private void refreshSelection() {
        for (int i = 0; i < this.m_aButtons.length; ++i) {
            if (this.m_aButtons[i] == null) continue;
            XControlModel xModel = (XControlModel)UnoDialog2.getModel(this.m_aButtons[i]);
            PropertySetHelper aHelper = new PropertySetHelper(xModel);
            if (i == this.m_nCurrentSelection) {
                boolean one = true;
                aHelper.setPropertyValueDontThrow(PropertyNames.PROPERTY_STATE, (short)1);
                continue;
            }
            boolean zero = false;
            aHelper.setPropertyValueDontThrow(PropertyNames.PROPERTY_STATE, (short)0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String sControlName;
        String sButton;
        int nButton;
        int index;
        XControlModel xModel = (XControlModel)UnoDialog2.getModel(actionEvent.Source);
        PropertySetHelper aHelper = new PropertySetHelper(xModel);
        int nState = aHelper.getPropertyValueAsInteger(PropertyNames.PROPERTY_STATE, -1);
        if (nState == 0) {
            aHelper.setPropertyValueDontThrow(PropertyNames.PROPERTY_STATE, (short)1);
        }
        if ((index = this.getIndexFor(nButton = Integer.parseInt(sButton = (sControlName = aHelper.getPropertyValueAsString(PropertyNames.PROPERTY_NAME, PropertyNames.EMPTY_STRING)).substring(7 + this.m_aControlName.length())))) < this.listModel.getSize()) {
            this.setSelected(index);
        }
    }

    private static class Counter {
        private int start;
        private int end;
        private int max;

        private Counter(int start_, int end_, int max_) {
            this.start = start_;
            this.end = end_;
            this.max = max_;
        }
    }

    private static class SimpleCounterRenderer
    implements IRenderer {
        private SimpleCounterRenderer() {
        }

        @Override
        public String render(Object counter) {
            return PropertyNames.EMPTY_STRING + ((Counter)counter).start + ".." + ((Counter)counter).end + "/" + ((Counter)counter).max;
        }
    }
}

