/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.ByteArrayOutputStream;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.tools.jcore.ClassWriter;
import sun.jvm.hotspot.utilities.SystemDictionaryHelper;

public class ProcImageClassLoader
extends ClassLoader {
    public ProcImageClassLoader(ClassLoader parent) {
        super(parent);
    }

    public ProcImageClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InstanceKlass klass = SystemDictionaryHelper.findInstanceKlass(className);
            ClassWriter cw = new ClassWriter(klass, bos);
            cw.write();
            byte[] buf = bos.toByteArray();
            return this.defineClass(className, buf, 0, buf.length);
        }
        catch (Exception e) {
            throw (ClassNotFoundException)new ClassNotFoundException().initCause(e);
        }
    }
}

