/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxAbsoluteInputCapabilities;
import com.sun.glass.ui.monocle.LinuxEventBuffer;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import java.security.AccessController;
import java.util.Arrays;

class LinuxTouchTransform {
    private LinuxInputDevice device;
    private int[] axes = new int[2];
    private double[] translates = new double[2];
    private double[] scalars = new double[2];
    private boolean flipXY;
    private int[] mins = new int[2];
    private int[] maxs = new int[2];

    LinuxTouchTransform(LinuxInputDevice linuxInputDevice) {
        this.device = linuxInputDevice;
        Arrays.fill(this.axes, -1);
        String string = linuxInputDevice.getProduct();
        AccessController.doPrivileged(() -> {
            this.flipXY = Boolean.getBoolean("monocle.input." + string + ".flipXY");
            return null;
        });
    }

    int getValue(LinuxEventBuffer linuxEventBuffer) {
        int n;
        short s = linuxEventBuffer.getEventCode();
        int n2 = linuxEventBuffer.getEventValue();
        for (n = 0; n < this.axes.length && this.axes[n] != -1; ++n) {
            if (this.axes[n] != s) continue;
            return this.transform(n, n2);
        }
        if (n == this.axes.length) {
            this.axes = Arrays.copyOf(this.axes, this.axes.length * 2);
            Arrays.fill(this.axes, n + 1, this.axes.length - 1, -1);
            this.translates = Arrays.copyOf(this.translates, this.translates.length * 2);
            this.scalars = Arrays.copyOf(this.scalars, this.scalars.length * 2);
            this.mins = Arrays.copyOf(this.mins, this.mins.length * 2);
            this.maxs = Arrays.copyOf(this.maxs, this.maxs.length * 2);
        }
        this.initTransform(s, n);
        return this.transform(n, n2);
    }

    int getAxis(LinuxEventBuffer linuxEventBuffer) {
        short s = linuxEventBuffer.getEventCode();
        if (this.flipXY) {
            switch (s) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
                case 53: {
                    return 54;
                }
                case 54: {
                    return 53;
                }
            }
            return s;
        }
        return s;
    }

    private void initTransform(int n, int n2) {
        String string;
        double d;
        switch (n) {
            case 0: 
            case 53: {
                d = NativePlatformFactory.getNativePlatform().getScreen().getWidth();
                string = "X";
                break;
            }
            case 1: 
            case 54: {
                d = NativePlatformFactory.getNativePlatform().getScreen().getHeight();
                string = "Y";
                break;
            }
            default: {
                this.translates[n2] = 0.0;
                this.scalars[n2] = 1.0;
                return;
            }
        }
        LinuxAbsoluteInputCapabilities linuxAbsoluteInputCapabilities = this.device.getAbsoluteInputCapabilities(n);
        String string2 = this.device.getProduct();
        AccessController.doPrivileged(() -> {
            int n2 = Integer.getInteger("monocle.input." + string2 + ".min" + string, linuxAbsoluteInputCapabilities.getMinimum());
            int n3 = Integer.getInteger("monocle.input." + string2 + ".max" + string, linuxAbsoluteInputCapabilities.getMaximum());
            this.translates[n] = -n2;
            this.scalars[n] = d / (double)(n3 - n2);
            return null;
        });
    }

    private int transform(int n, int n2) {
        return (int)Math.round(((double)n2 + this.translates[n]) * this.scalars[n]);
    }
}

