/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging.filelogs;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.FileLog;
import net.sourceforge.jnlp.util.logging.SingleStreamLogger;

public final class LogBasedFileLog
implements SingleStreamLogger {
    private final Logger impl;
    private final FileHandler fh;

    public LogBasedFileLog(String fileName, boolean append) {
        this(fileName, fileName, append);
    }

    public LogBasedFileLog(String loggerName, String fileName, boolean append) {
        try {
            File futureFile = new File(fileName);
            if (!futureFile.exists()) {
                FileUtils.createRestrictedFile(futureFile, true);
            }
            this.fh = new FileHandler(fileName, append);
            this.fh.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + "\n";
                }
            });
            this.impl = Logger.getLogger(loggerName);
            this.impl.setLevel(Level.ALL);
            this.impl.addHandler(this.fh);
            this.log(FileLog.getHeadlineHeader().toString() + " log-based impl.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void log(String s) {
        this.impl.log(Level.FINE, s);
    }

    @Override
    public void close() {
        this.fh.close();
    }
}

