"use strict";
// -----------------------
// WARNING - DO NOT modify the "is" methods of the TypeGuards class directly. It is code generated by createTypeGuardsUtility.ts
//
// Note: This file is excluded from code coverage reports because it's automatically maintained (low risk).
// -----------------------
Object.defineProperty(exports, "__esModule", { value: true });
var typescript_1 = require("../typescript");
/**
 * Type guards for checking the type of a node.
 */
var TypeGuards = /** @class */ (function () {
    function TypeGuards() {
    }
    /**
     * Gets if the node has an expression.
     * @param node - Node to check.
     */
    TypeGuards.hasExpression = function (node) {
        // this method is manually maintained
        if (node.getExpression == null)
            return false;
        return node.getExpression() != null;
    };
    /**
     * Gets if the node has a name.
     * @param node - Node to check.
     */
    TypeGuards.hasName = function (node) {
        // this method is manually maintained
        if (node.getName == null)
            return false;
        return typeof node.getName() === "string";
    };
    /**
     * Gets if the node has a body.
     * @param node - Node to check.
     */
    TypeGuards.hasBody = function (node) {
        // this method is manually maintained
        if (node.getBody == null)
            return false;
        return node.getBody() != null;
    };
    /**
     * Gets if the node is an AbstractableNode.
     * @param node - Node to check.
     */
    TypeGuards.isAbstractableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is an AmbientableNode.
     * @param node - Node to check.
     */
    TypeGuards.isAmbientableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.EnumDeclaration:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.VariableStatement:
            case typescript_1.SyntaxKind.TypeAliasDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is an AnyKeyword.
     * @param node - Node to check.
     */
    TypeGuards.isAnyKeyword = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.AnyKeyword;
    };
    /**
     * Gets if the node is an ArgumentedNode.
     * @param node - Node to check.
     */
    TypeGuards.isArgumentedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.CallExpression:
            case typescript_1.SyntaxKind.NewExpression:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is an ArrayLiteralExpression.
     * @param node - Node to check.
     */
    TypeGuards.isArrayLiteralExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ArrayLiteralExpression;
    };
    /**
     * Gets if the node is an ArrayTypeNode.
     * @param node - Node to check.
     */
    TypeGuards.isArrayTypeNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ArrayType;
    };
    /**
     * Gets if the node is an ArrowFunction.
     * @param node - Node to check.
     */
    TypeGuards.isArrowFunction = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ArrowFunction;
    };
    /**
     * Gets if the node is an AsExpression.
     * @param node - Node to check.
     */
    TypeGuards.isAsExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.AsExpression;
    };
    /**
     * Gets if the node is an AsyncableNode.
     * @param node - Node to check.
     */
    TypeGuards.isAsyncableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is an AwaitExpression.
     * @param node - Node to check.
     */
    TypeGuards.isAwaitExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.AwaitExpression;
    };
    /**
     * Gets if the node is an AwaitableNode.
     * @param node - Node to check.
     */
    TypeGuards.isAwaitableNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ForOfStatement;
    };
    /**
     * Gets if the node is a BinaryExpression.
     * @param node - Node to check.
     */
    TypeGuards.isBinaryExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.BinaryExpression;
    };
    /**
     * Gets if the node is a BindingNamedNode.
     * @param node - Node to check.
     */
    TypeGuards.isBindingNamedNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.VariableDeclaration;
    };
    /**
     * Gets if the node is a Block.
     * @param node - Node to check.
     */
    TypeGuards.isBlock = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.Block;
    };
    /**
     * Gets if the node is a BodiedNode.
     * @param node - Node to check.
     */
    TypeGuards.isBodiedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.ModuleDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a BodyableNode.
     * @param node - Node to check.
     */
    TypeGuards.isBodyableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.FunctionDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a BooleanKeyword.
     * @param node - Node to check.
     */
    TypeGuards.isBooleanKeyword = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.BooleanKeyword;
    };
    /**
     * Gets if the node is a BooleanLiteral.
     * @param node - Node to check.
     */
    TypeGuards.isBooleanLiteral = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.FalseKeyword:
            case typescript_1.SyntaxKind.TrueKeyword:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a BreakStatement.
     * @param node - Node to check.
     */
    TypeGuards.isBreakStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.BreakStatement;
    };
    /**
     * Gets if the node is a CallExpression.
     * @param node - Node to check.
     */
    TypeGuards.isCallExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.CallExpression;
    };
    /**
     * Gets if the node is a CallSignatureDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isCallSignatureDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.CallSignature;
    };
    /**
     * Gets if the node is a CaseBlock.
     * @param node - Node to check.
     */
    TypeGuards.isCaseBlock = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.CaseBlock;
    };
    /**
     * Gets if the node is a CaseClause.
     * @param node - Node to check.
     */
    TypeGuards.isCaseClause = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.CaseClause;
    };
    /**
     * Gets if the node is a CatchClause.
     * @param node - Node to check.
     */
    TypeGuards.isCatchClause = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.CatchClause;
    };
    /**
     * Gets if the node is a ChildOrderableNode.
     * @param node - Node to check.
     */
    TypeGuards.isChildOrderableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.EnumDeclaration:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.CallSignature:
            case typescript_1.SyntaxKind.ConstructSignature:
            case typescript_1.SyntaxKind.IndexSignature:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.MethodSignature:
            case typescript_1.SyntaxKind.PropertySignature:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.BreakStatement:
            case typescript_1.SyntaxKind.CaseClause:
            case typescript_1.SyntaxKind.ContinueStatement:
            case typescript_1.SyntaxKind.DefaultClause:
            case typescript_1.SyntaxKind.DoStatement:
            case typescript_1.SyntaxKind.ExpressionStatement:
            case typescript_1.SyntaxKind.ForInStatement:
            case typescript_1.SyntaxKind.ForOfStatement:
            case typescript_1.SyntaxKind.ForStatement:
            case typescript_1.SyntaxKind.IfStatement:
            case typescript_1.SyntaxKind.LabeledStatement:
            case typescript_1.SyntaxKind.ReturnStatement:
            case typescript_1.SyntaxKind.SwitchStatement:
            case typescript_1.SyntaxKind.VariableStatement:
            case typescript_1.SyntaxKind.WhileStatement:
            case typescript_1.SyntaxKind.WithStatement:
            case typescript_1.SyntaxKind.TypeAliasDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a ClassDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isClassDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ClassDeclaration;
    };
    /**
     * Gets if the node is a CommaListExpression.
     * @param node - Node to check.
     */
    TypeGuards.isCommaListExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.CommaListExpression;
    };
    /**
     * Gets if the node is a ComputedPropertyName.
     * @param node - Node to check.
     */
    TypeGuards.isComputedPropertyName = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ComputedPropertyName;
    };
    /**
     * Gets if the node is a ConditionalExpression.
     * @param node - Node to check.
     */
    TypeGuards.isConditionalExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ConditionalExpression;
    };
    /**
     * Gets if the node is a ConstructSignatureDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isConstructSignatureDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ConstructSignature;
    };
    /**
     * Gets if the node is a ConstructorDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isConstructorDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.Constructor;
    };
    /**
     * Gets if the node is a ConstructorTypeNode.
     * @param node - Node to check.
     */
    TypeGuards.isConstructorTypeNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ConstructorType;
    };
    /**
     * Gets if the node is a ContinueStatement.
     * @param node - Node to check.
     */
    TypeGuards.isContinueStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ContinueStatement;
    };
    /**
     * Gets if the node is a DebuggerStatement.
     * @param node - Node to check.
     */
    TypeGuards.isDebuggerStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.DebuggerStatement;
    };
    /**
     * Gets if the node is a DeclarationNamedNode.
     * @param node - Node to check.
     */
    TypeGuards.isDeclarationNamedNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.Parameter;
    };
    /**
     * Gets if the node is a DecoratableNode.
     * @param node - Node to check.
     */
    TypeGuards.isDecoratableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.Parameter:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a Decorator.
     * @param node - Node to check.
     */
    TypeGuards.isDecorator = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.Decorator;
    };
    /**
     * Gets if the node is a DefaultClause.
     * @param node - Node to check.
     */
    TypeGuards.isDefaultClause = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.DefaultClause;
    };
    /**
     * Gets if the node is a DeleteExpression.
     * @param node - Node to check.
     */
    TypeGuards.isDeleteExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.DeleteExpression;
    };
    /**
     * Gets if the node is a DoStatement.
     * @param node - Node to check.
     */
    TypeGuards.isDoStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.DoStatement;
    };
    /**
     * Gets if the node is an ElementAccessExpression.
     * @param node - Node to check.
     */
    TypeGuards.isElementAccessExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ElementAccessExpression;
    };
    /**
     * Gets if the node is an EmptyStatement.
     * @param node - Node to check.
     */
    TypeGuards.isEmptyStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.EmptyStatement;
    };
    /**
     * Gets if the node is an EnumDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isEnumDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.EnumDeclaration;
    };
    /**
     * Gets if the node is an EnumMember.
     * @param node - Node to check.
     */
    TypeGuards.isEnumMember = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.EnumMember;
    };
    /**
     * Gets if the node is an ExclamationTokenableNode.
     * @param node - Node to check.
     */
    TypeGuards.isExclamationTokenableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.VariableDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is an ExportAssignment.
     * @param node - Node to check.
     */
    TypeGuards.isExportAssignment = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ExportAssignment;
    };
    /**
     * Gets if the node is an ExportDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isExportDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ExportDeclaration;
    };
    /**
     * Gets if the node is an ExportSpecifier.
     * @param node - Node to check.
     */
    TypeGuards.isExportSpecifier = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ExportSpecifier;
    };
    /**
     * Gets if the node is an ExportableNode.
     * @param node - Node to check.
     */
    TypeGuards.isExportableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.EnumDeclaration:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.VariableStatement:
            case typescript_1.SyntaxKind.TypeAliasDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is an Expression.
     * @param node - Node to check.
     */
    TypeGuards.isExpression = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.AnyKeyword:
            case typescript_1.SyntaxKind.BooleanKeyword:
            case typescript_1.SyntaxKind.NeverKeyword:
            case typescript_1.SyntaxKind.NumberKeyword:
            case typescript_1.SyntaxKind.ObjectKeyword:
            case typescript_1.SyntaxKind.StringKeyword:
            case typescript_1.SyntaxKind.SymbolKeyword:
            case typescript_1.SyntaxKind.UndefinedKeyword:
            case typescript_1.SyntaxKind.Identifier:
            case typescript_1.SyntaxKind.AsExpression:
            case typescript_1.SyntaxKind.AwaitExpression:
            case typescript_1.SyntaxKind.BinaryExpression:
            case typescript_1.SyntaxKind.CallExpression:
            case typescript_1.SyntaxKind.CommaListExpression:
            case typescript_1.SyntaxKind.ConditionalExpression:
            case typescript_1.SyntaxKind.DeleteExpression:
            case typescript_1.SyntaxKind.ElementAccessExpression:
            case typescript_1.SyntaxKind.ImportKeyword:
            case typescript_1.SyntaxKind.MetaProperty:
            case typescript_1.SyntaxKind.NewExpression:
            case typescript_1.SyntaxKind.NonNullExpression:
            case typescript_1.SyntaxKind.OmittedExpression:
            case typescript_1.SyntaxKind.ParenthesizedExpression:
            case typescript_1.SyntaxKind.PartiallyEmittedExpression:
            case typescript_1.SyntaxKind.PostfixUnaryExpression:
            case typescript_1.SyntaxKind.PrefixUnaryExpression:
            case typescript_1.SyntaxKind.PropertyAccessExpression:
            case typescript_1.SyntaxKind.SpreadElement:
            case typescript_1.SyntaxKind.SuperKeyword:
            case typescript_1.SyntaxKind.ThisKeyword:
            case typescript_1.SyntaxKind.TypeAssertionExpression:
            case typescript_1.SyntaxKind.TypeOfExpression:
            case typescript_1.SyntaxKind.VoidKeyword:
            case typescript_1.SyntaxKind.YieldExpression:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.JsxClosingFragment:
            case typescript_1.SyntaxKind.JsxElement:
            case typescript_1.SyntaxKind.JsxExpression:
            case typescript_1.SyntaxKind.JsxFragment:
            case typescript_1.SyntaxKind.JsxOpeningElement:
            case typescript_1.SyntaxKind.JsxOpeningFragment:
            case typescript_1.SyntaxKind.JsxSelfClosingElement:
            case typescript_1.SyntaxKind.FalseKeyword:
            case typescript_1.SyntaxKind.TrueKeyword:
            case typescript_1.SyntaxKind.NullKeyword:
            case typescript_1.SyntaxKind.NumericLiteral:
            case typescript_1.SyntaxKind.RegularExpressionLiteral:
            case typescript_1.SyntaxKind.StringLiteral:
            case typescript_1.SyntaxKind.ArrayLiteralExpression:
            case typescript_1.SyntaxKind.ObjectLiteralExpression:
            case typescript_1.SyntaxKind.NoSubstitutionTemplateLiteral:
            case typescript_1.SyntaxKind.TaggedTemplateExpression:
            case typescript_1.SyntaxKind.TemplateExpression:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is an ExpressionStatement.
     * @param node - Node to check.
     */
    TypeGuards.isExpressionStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ExpressionStatement;
    };
    /**
     * Gets if the node is an ExpressionWithTypeArguments.
     * @param node - Node to check.
     */
    TypeGuards.isExpressionWithTypeArguments = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ExpressionWithTypeArguments;
    };
    /**
     * Gets if the node is an ExpressionedNode.
     * @param node - Node to check.
     */
    TypeGuards.isExpressionedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.AsExpression:
            case typescript_1.SyntaxKind.NonNullExpression:
            case typescript_1.SyntaxKind.ParenthesizedExpression:
            case typescript_1.SyntaxKind.PartiallyEmittedExpression:
            case typescript_1.SyntaxKind.SpreadElement:
            case typescript_1.SyntaxKind.SpreadAssignment:
            case typescript_1.SyntaxKind.TemplateSpan:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is an ExtendsClauseableNode.
     * @param node - Node to check.
     */
    TypeGuards.isExtendsClauseableNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.InterfaceDeclaration;
    };
    /**
     * Gets if the node is an ExternalModuleReference.
     * @param node - Node to check.
     */
    TypeGuards.isExternalModuleReference = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ExternalModuleReference;
    };
    /**
     * Gets if the node is a FalseKeyword.
     * @param node - Node to check.
     */
    TypeGuards.isFalseKeyword = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.FalseKeyword;
    };
    /**
     * Gets if the node is a ForInStatement.
     * @param node - Node to check.
     */
    TypeGuards.isForInStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ForInStatement;
    };
    /**
     * Gets if the node is a ForOfStatement.
     * @param node - Node to check.
     */
    TypeGuards.isForOfStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ForOfStatement;
    };
    /**
     * Gets if the node is a ForStatement.
     * @param node - Node to check.
     */
    TypeGuards.isForStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ForStatement;
    };
    /**
     * Gets if the node is a FunctionDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isFunctionDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.FunctionDeclaration;
    };
    /**
     * Gets if the node is a FunctionExpression.
     * @param node - Node to check.
     */
    TypeGuards.isFunctionExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.FunctionExpression;
    };
    /**
     * Gets if the node is a FunctionLikeDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isFunctionLikeDeclaration = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.FunctionDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a FunctionTypeNode.
     * @param node - Node to check.
     */
    TypeGuards.isFunctionTypeNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.FunctionType;
    };
    /**
     * Gets if the node is a GeneratorableNode.
     * @param node - Node to check.
     */
    TypeGuards.isGeneratorableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.YieldExpression:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a GetAccessorDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isGetAccessorDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.GetAccessor;
    };
    /**
     * Gets if the node is a HeritageClause.
     * @param node - Node to check.
     */
    TypeGuards.isHeritageClause = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.HeritageClause;
    };
    /**
     * Gets if the node is a HeritageClauseableNode.
     * @param node - Node to check.
     */
    TypeGuards.isHeritageClauseableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a Identifier.
     * @param node - Node to check.
     */
    TypeGuards.isIdentifier = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.Identifier;
    };
    /**
     * Gets if the node is a IfStatement.
     * @param node - Node to check.
     */
    TypeGuards.isIfStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.IfStatement;
    };
    /**
     * Gets if the node is a ImplementsClauseableNode.
     * @param node - Node to check.
     */
    TypeGuards.isImplementsClauseableNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ClassDeclaration;
    };
    /**
     * Gets if the node is a ImportDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isImportDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ImportDeclaration;
    };
    /**
     * Gets if the node is a ImportEqualsDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isImportEqualsDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ImportEqualsDeclaration;
    };
    /**
     * Gets if the node is a ImportExpression.
     * @param node - Node to check.
     */
    TypeGuards.isImportExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ImportKeyword;
    };
    /**
     * Gets if the node is a ImportSpecifier.
     * @param node - Node to check.
     */
    TypeGuards.isImportSpecifier = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ImportSpecifier;
    };
    /**
     * Gets if the node is a ImportTypeNode.
     * @param node - Node to check.
     */
    TypeGuards.isImportTypeNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ImportType;
    };
    /**
     * Gets if the node is a IndexSignatureDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isIndexSignatureDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.IndexSignature;
    };
    /**
     * Gets if the node is a InitializerExpressionableNode.
     * @param node - Node to check.
     */
    TypeGuards.isInitializerExpressionableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.EnumMember:
            case typescript_1.SyntaxKind.Parameter:
            case typescript_1.SyntaxKind.PropertySignature:
            case typescript_1.SyntaxKind.VariableDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a InitializerGetExpressionableNode.
     * @param node - Node to check.
     */
    TypeGuards.isInitializerGetExpressionableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.EnumMember:
            case typescript_1.SyntaxKind.Parameter:
            case typescript_1.SyntaxKind.PropertySignature:
            case typescript_1.SyntaxKind.VariableDeclaration:
            case typescript_1.SyntaxKind.PropertyAssignment:
            case typescript_1.SyntaxKind.ShorthandPropertyAssignment:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a InitializerSetExpressionableNode.
     * @param node - Node to check.
     */
    TypeGuards.isInitializerSetExpressionableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.EnumMember:
            case typescript_1.SyntaxKind.Parameter:
            case typescript_1.SyntaxKind.PropertySignature:
            case typescript_1.SyntaxKind.VariableDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a InterfaceDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isInterfaceDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.InterfaceDeclaration;
    };
    /**
     * Gets if the node is a IntersectionTypeNode.
     * @param node - Node to check.
     */
    TypeGuards.isIntersectionTypeNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.IntersectionType;
    };
    /**
     * Gets if the node is a IterationStatement.
     * @param node - Node to check.
     */
    TypeGuards.isIterationStatement = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.DoStatement:
            case typescript_1.SyntaxKind.ForInStatement:
            case typescript_1.SyntaxKind.ForOfStatement:
            case typescript_1.SyntaxKind.ForStatement:
            case typescript_1.SyntaxKind.WhileStatement:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a JSDoc.
     * @param node - Node to check.
     */
    TypeGuards.isJSDoc = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JSDocComment;
    };
    /**
     * Gets if the node is a JSDocAugmentsTag.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocAugmentsTag = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JSDocAugmentsTag;
    };
    /**
     * Gets if the node is a JSDocClassTag.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocClassTag = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JSDocClassTag;
    };
    /**
     * Gets if the node is a JSDocParameterTag.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocParameterTag = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JSDocParameterTag;
    };
    /**
     * Gets if the node is a JSDocPropertyLikeTag.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocPropertyLikeTag = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.JSDocParameterTag:
            case typescript_1.SyntaxKind.JSDocPropertyTag:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a JSDocPropertyTag.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocPropertyTag = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JSDocPropertyTag;
    };
    /**
     * Gets if the node is a JSDocReturnTag.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocReturnTag = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JSDocReturnTag;
    };
    /**
     * Gets if the node is a JSDocTag.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocTag = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.JSDocAugmentsTag:
            case typescript_1.SyntaxKind.JSDocClassTag:
            case typescript_1.SyntaxKind.JSDocParameterTag:
            case typescript_1.SyntaxKind.JSDocPropertyTag:
            case typescript_1.SyntaxKind.JSDocReturnTag:
            case typescript_1.SyntaxKind.JSDocTypedefTag:
            case typescript_1.SyntaxKind.JSDocTypeTag:
            case typescript_1.SyntaxKind.JSDocTag:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a JSDocTypeTag.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocTypeTag = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JSDocTypeTag;
    };
    /**
     * Gets if the node is a JSDocTypedefTag.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocTypedefTag = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JSDocTypedefTag;
    };
    /**
     * Gets if the node is a JSDocUnknownTag.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocUnknownTag = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JSDocTag;
    };
    /**
     * Gets if the node is a JSDocableNode.
     * @param node - Node to check.
     */
    TypeGuards.isJSDocableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.EnumDeclaration:
            case typescript_1.SyntaxKind.EnumMember:
            case typescript_1.SyntaxKind.ImportEqualsDeclaration:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.CallSignature:
            case typescript_1.SyntaxKind.ConstructSignature:
            case typescript_1.SyntaxKind.IndexSignature:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.MethodSignature:
            case typescript_1.SyntaxKind.PropertySignature:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.ExpressionStatement:
            case typescript_1.SyntaxKind.LabeledStatement:
            case typescript_1.SyntaxKind.VariableStatement:
            case typescript_1.SyntaxKind.TypeAliasDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a JsxAttribute.
     * @param node - Node to check.
     */
    TypeGuards.isJsxAttribute = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxAttribute;
    };
    /**
     * Gets if the node is a JsxAttributedNode.
     * @param node - Node to check.
     */
    TypeGuards.isJsxAttributedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.JsxOpeningElement:
            case typescript_1.SyntaxKind.JsxSelfClosingElement:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a JsxClosingElement.
     * @param node - Node to check.
     */
    TypeGuards.isJsxClosingElement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxClosingElement;
    };
    /**
     * Gets if the node is a JsxClosingFragment.
     * @param node - Node to check.
     */
    TypeGuards.isJsxClosingFragment = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxClosingFragment;
    };
    /**
     * Gets if the node is a JsxElement.
     * @param node - Node to check.
     */
    TypeGuards.isJsxElement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxElement;
    };
    /**
     * Gets if the node is a JsxExpression.
     * @param node - Node to check.
     */
    TypeGuards.isJsxExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxExpression;
    };
    /**
     * Gets if the node is a JsxFragment.
     * @param node - Node to check.
     */
    TypeGuards.isJsxFragment = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxFragment;
    };
    /**
     * Gets if the node is a JsxOpeningElement.
     * @param node - Node to check.
     */
    TypeGuards.isJsxOpeningElement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxOpeningElement;
    };
    /**
     * Gets if the node is a JsxOpeningFragment.
     * @param node - Node to check.
     */
    TypeGuards.isJsxOpeningFragment = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxOpeningFragment;
    };
    /**
     * Gets if the node is a JsxSelfClosingElement.
     * @param node - Node to check.
     */
    TypeGuards.isJsxSelfClosingElement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxSelfClosingElement;
    };
    /**
     * Gets if the node is a JsxSpreadAttribute.
     * @param node - Node to check.
     */
    TypeGuards.isJsxSpreadAttribute = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxSpreadAttribute;
    };
    /**
     * Gets if the node is a JsxTagNamedNode.
     * @param node - Node to check.
     */
    TypeGuards.isJsxTagNamedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.JsxClosingElement:
            case typescript_1.SyntaxKind.JsxOpeningElement:
            case typescript_1.SyntaxKind.JsxSelfClosingElement:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a JsxText.
     * @param node - Node to check.
     */
    TypeGuards.isJsxText = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.JsxText;
    };
    /**
     * Gets if the node is a LabeledStatement.
     * @param node - Node to check.
     */
    TypeGuards.isLabeledStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.LabeledStatement;
    };
    /**
     * Gets if the node is a LeftHandSideExpression.
     * @param node - Node to check.
     */
    TypeGuards.isLeftHandSideExpression = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Identifier:
            case typescript_1.SyntaxKind.CallExpression:
            case typescript_1.SyntaxKind.ElementAccessExpression:
            case typescript_1.SyntaxKind.ImportKeyword:
            case typescript_1.SyntaxKind.MetaProperty:
            case typescript_1.SyntaxKind.NewExpression:
            case typescript_1.SyntaxKind.NonNullExpression:
            case typescript_1.SyntaxKind.PropertyAccessExpression:
            case typescript_1.SyntaxKind.SuperKeyword:
            case typescript_1.SyntaxKind.ThisKeyword:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.JsxElement:
            case typescript_1.SyntaxKind.JsxFragment:
            case typescript_1.SyntaxKind.JsxSelfClosingElement:
            case typescript_1.SyntaxKind.FalseKeyword:
            case typescript_1.SyntaxKind.TrueKeyword:
            case typescript_1.SyntaxKind.NullKeyword:
            case typescript_1.SyntaxKind.NumericLiteral:
            case typescript_1.SyntaxKind.RegularExpressionLiteral:
            case typescript_1.SyntaxKind.StringLiteral:
            case typescript_1.SyntaxKind.ArrayLiteralExpression:
            case typescript_1.SyntaxKind.ObjectLiteralExpression:
            case typescript_1.SyntaxKind.NoSubstitutionTemplateLiteral:
            case typescript_1.SyntaxKind.TaggedTemplateExpression:
            case typescript_1.SyntaxKind.TemplateExpression:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a LeftHandSideExpressionedNode.
     * @param node - Node to check.
     */
    TypeGuards.isLeftHandSideExpressionedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.CallExpression:
            case typescript_1.SyntaxKind.ElementAccessExpression:
            case typescript_1.SyntaxKind.NewExpression:
            case typescript_1.SyntaxKind.PropertyAccessExpression:
            case typescript_1.SyntaxKind.ExpressionWithTypeArguments:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a LiteralExpression.
     * @param node - Node to check.
     */
    TypeGuards.isLiteralExpression = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.NumericLiteral:
            case typescript_1.SyntaxKind.RegularExpressionLiteral:
            case typescript_1.SyntaxKind.StringLiteral:
            case typescript_1.SyntaxKind.NoSubstitutionTemplateLiteral:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a LiteralLikeNode.
     * @param node - Node to check.
     */
    TypeGuards.isLiteralLikeNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.NumericLiteral:
            case typescript_1.SyntaxKind.RegularExpressionLiteral:
            case typescript_1.SyntaxKind.StringLiteral:
            case typescript_1.SyntaxKind.NoSubstitutionTemplateLiteral:
            case typescript_1.SyntaxKind.TemplateHead:
            case typescript_1.SyntaxKind.TemplateMiddle:
            case typescript_1.SyntaxKind.TemplateTail:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a LiteralTypeNode.
     * @param node - Node to check.
     */
    TypeGuards.isLiteralTypeNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.LiteralType;
    };
    /**
     * Gets if the node is a MemberExpression.
     * @param node - Node to check.
     */
    TypeGuards.isMemberExpression = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Identifier:
            case typescript_1.SyntaxKind.ElementAccessExpression:
            case typescript_1.SyntaxKind.ImportKeyword:
            case typescript_1.SyntaxKind.MetaProperty:
            case typescript_1.SyntaxKind.NewExpression:
            case typescript_1.SyntaxKind.PropertyAccessExpression:
            case typescript_1.SyntaxKind.SuperKeyword:
            case typescript_1.SyntaxKind.ThisKeyword:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.JsxElement:
            case typescript_1.SyntaxKind.JsxFragment:
            case typescript_1.SyntaxKind.JsxSelfClosingElement:
            case typescript_1.SyntaxKind.FalseKeyword:
            case typescript_1.SyntaxKind.TrueKeyword:
            case typescript_1.SyntaxKind.NullKeyword:
            case typescript_1.SyntaxKind.NumericLiteral:
            case typescript_1.SyntaxKind.RegularExpressionLiteral:
            case typescript_1.SyntaxKind.StringLiteral:
            case typescript_1.SyntaxKind.ArrayLiteralExpression:
            case typescript_1.SyntaxKind.ObjectLiteralExpression:
            case typescript_1.SyntaxKind.NoSubstitutionTemplateLiteral:
            case typescript_1.SyntaxKind.TaggedTemplateExpression:
            case typescript_1.SyntaxKind.TemplateExpression:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a MetaProperty.
     * @param node - Node to check.
     */
    TypeGuards.isMetaProperty = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.MetaProperty;
    };
    /**
     * Gets if the node is a MethodDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isMethodDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.MethodDeclaration;
    };
    /**
     * Gets if the node is a MethodSignature.
     * @param node - Node to check.
     */
    TypeGuards.isMethodSignature = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.MethodSignature;
    };
    /**
     * Gets if the node is a ModifierableNode.
     * @param node - Node to check.
     */
    TypeGuards.isModifierableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.EnumDeclaration:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.Parameter:
            case typescript_1.SyntaxKind.IndexSignature:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.PropertySignature:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.VariableDeclarationList:
            case typescript_1.SyntaxKind.VariableStatement:
            case typescript_1.SyntaxKind.TypeAliasDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a NameableNode.
     * @param node - Node to check.
     */
    TypeGuards.isNameableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a NamedNode.
     * @param node - Node to check.
     */
    TypeGuards.isNamedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.EnumDeclaration:
            case typescript_1.SyntaxKind.MetaProperty:
            case typescript_1.SyntaxKind.PropertyAccessExpression:
            case typescript_1.SyntaxKind.ImportEqualsDeclaration:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.JsxAttribute:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.TypeAliasDeclaration:
            case typescript_1.SyntaxKind.TypeParameter:
            case typescript_1.SyntaxKind.ShorthandPropertyAssignment:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a NamespaceChildableNode.
     * @param node - Node to check.
     */
    TypeGuards.isNamespaceChildableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.EnumDeclaration:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.VariableStatement:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a NamespaceDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isNamespaceDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ModuleDeclaration;
    };
    /**
     * Gets if the node is a NeverKeyword.
     * @param node - Node to check.
     */
    TypeGuards.isNeverKeyword = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.NeverKeyword;
    };
    /**
     * Gets if the node is a NewExpression.
     * @param node - Node to check.
     */
    TypeGuards.isNewExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.NewExpression;
    };
    /**
     * Gets if the node is a NoSubstitutionTemplateLiteral.
     * @param node - Node to check.
     */
    TypeGuards.isNoSubstitutionTemplateLiteral = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.NoSubstitutionTemplateLiteral;
    };
    /**
     * Gets if the node is a NonNullExpression.
     * @param node - Node to check.
     */
    TypeGuards.isNonNullExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.NonNullExpression;
    };
    /**
     * Gets if the node is a NotEmittedStatement.
     * @param node - Node to check.
     */
    TypeGuards.isNotEmittedStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.NotEmittedStatement;
    };
    /**
     * Gets if the node is a NullLiteral.
     * @param node - Node to check.
     */
    TypeGuards.isNullLiteral = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.NullKeyword;
    };
    /**
     * Gets if the node is a NumberKeyword.
     * @param node - Node to check.
     */
    TypeGuards.isNumberKeyword = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.NumberKeyword;
    };
    /**
     * Gets if the node is a NumericLiteral.
     * @param node - Node to check.
     */
    TypeGuards.isNumericLiteral = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.NumericLiteral;
    };
    /**
     * Gets if the node is a ObjectKeyword.
     * @param node - Node to check.
     */
    TypeGuards.isObjectKeyword = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ObjectKeyword;
    };
    /**
     * Gets if the node is a ObjectLiteralExpression.
     * @param node - Node to check.
     */
    TypeGuards.isObjectLiteralExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ObjectLiteralExpression;
    };
    /**
     * Gets if the node is a OmittedExpression.
     * @param node - Node to check.
     */
    TypeGuards.isOmittedExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.OmittedExpression;
    };
    /**
     * Gets if the node is a OverloadableNode.
     * @param node - Node to check.
     */
    TypeGuards.isOverloadableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.FunctionDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a ParameterDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isParameterDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.Parameter;
    };
    /**
     * Gets if the node is a ParameteredNode.
     * @param node - Node to check.
     */
    TypeGuards.isParameteredNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.CallSignature:
            case typescript_1.SyntaxKind.ConstructSignature:
            case typescript_1.SyntaxKind.MethodSignature:
            case typescript_1.SyntaxKind.ConstructorType:
            case typescript_1.SyntaxKind.FunctionType:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a ParenthesizedExpression.
     * @param node - Node to check.
     */
    TypeGuards.isParenthesizedExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ParenthesizedExpression;
    };
    /**
     * Gets if the node is a PartiallyEmittedExpression.
     * @param node - Node to check.
     */
    TypeGuards.isPartiallyEmittedExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.PartiallyEmittedExpression;
    };
    /**
     * Gets if the node is a PostfixUnaryExpression.
     * @param node - Node to check.
     */
    TypeGuards.isPostfixUnaryExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.PostfixUnaryExpression;
    };
    /**
     * Gets if the node is a PrefixUnaryExpression.
     * @param node - Node to check.
     */
    TypeGuards.isPrefixUnaryExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.PrefixUnaryExpression;
    };
    /**
     * Gets if the node is a PrimaryExpression.
     * @param node - Node to check.
     */
    TypeGuards.isPrimaryExpression = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Identifier:
            case typescript_1.SyntaxKind.ImportKeyword:
            case typescript_1.SyntaxKind.MetaProperty:
            case typescript_1.SyntaxKind.NewExpression:
            case typescript_1.SyntaxKind.SuperKeyword:
            case typescript_1.SyntaxKind.ThisKeyword:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.JsxElement:
            case typescript_1.SyntaxKind.JsxFragment:
            case typescript_1.SyntaxKind.JsxSelfClosingElement:
            case typescript_1.SyntaxKind.FalseKeyword:
            case typescript_1.SyntaxKind.TrueKeyword:
            case typescript_1.SyntaxKind.NullKeyword:
            case typescript_1.SyntaxKind.NumericLiteral:
            case typescript_1.SyntaxKind.RegularExpressionLiteral:
            case typescript_1.SyntaxKind.StringLiteral:
            case typescript_1.SyntaxKind.ArrayLiteralExpression:
            case typescript_1.SyntaxKind.ObjectLiteralExpression:
            case typescript_1.SyntaxKind.NoSubstitutionTemplateLiteral:
            case typescript_1.SyntaxKind.TemplateExpression:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a PropertyAccessExpression.
     * @param node - Node to check.
     */
    TypeGuards.isPropertyAccessExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.PropertyAccessExpression;
    };
    /**
     * Gets if the node is a PropertyAssignment.
     * @param node - Node to check.
     */
    TypeGuards.isPropertyAssignment = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.PropertyAssignment;
    };
    /**
     * Gets if the node is a PropertyDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isPropertyDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.PropertyDeclaration;
    };
    /**
     * Gets if the node is a PropertyNamedNode.
     * @param node - Node to check.
     */
    TypeGuards.isPropertyNamedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.EnumMember:
            case typescript_1.SyntaxKind.MethodSignature:
            case typescript_1.SyntaxKind.PropertySignature:
            case typescript_1.SyntaxKind.PropertyAssignment:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a PropertySignature.
     * @param node - Node to check.
     */
    TypeGuards.isPropertySignature = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.PropertySignature;
    };
    /**
     * Gets if the node is a QualifiedName.
     * @param node - Node to check.
     */
    TypeGuards.isQualifiedName = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.QualifiedName;
    };
    /**
     * Gets if the node is a QuestionTokenableNode.
     * @param node - Node to check.
     */
    TypeGuards.isQuestionTokenableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.Parameter:
            case typescript_1.SyntaxKind.MethodSignature:
            case typescript_1.SyntaxKind.PropertySignature:
            case typescript_1.SyntaxKind.PropertyAssignment:
            case typescript_1.SyntaxKind.ShorthandPropertyAssignment:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a ReadonlyableNode.
     * @param node - Node to check.
     */
    TypeGuards.isReadonlyableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.Parameter:
            case typescript_1.SyntaxKind.IndexSignature:
            case typescript_1.SyntaxKind.PropertySignature:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a ReferenceFindableNode.
     * @param node - Node to check.
     */
    TypeGuards.isReferenceFindableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.Identifier:
            case typescript_1.SyntaxKind.EnumDeclaration:
            case typescript_1.SyntaxKind.EnumMember:
            case typescript_1.SyntaxKind.MetaProperty:
            case typescript_1.SyntaxKind.PropertyAccessExpression:
            case typescript_1.SyntaxKind.ImportEqualsDeclaration:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.Parameter:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.MethodSignature:
            case typescript_1.SyntaxKind.PropertySignature:
            case typescript_1.SyntaxKind.JsxAttribute:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.VariableDeclaration:
            case typescript_1.SyntaxKind.TypeAliasDeclaration:
            case typescript_1.SyntaxKind.TypeParameter:
            case typescript_1.SyntaxKind.PropertyAssignment:
            case typescript_1.SyntaxKind.ShorthandPropertyAssignment:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a RegularExpressionLiteral.
     * @param node - Node to check.
     */
    TypeGuards.isRegularExpressionLiteral = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.RegularExpressionLiteral;
    };
    /**
     * Gets if the node is a ReturnStatement.
     * @param node - Node to check.
     */
    TypeGuards.isReturnStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ReturnStatement;
    };
    /**
     * Gets if the node is a ReturnTypedNode.
     * @param node - Node to check.
     */
    TypeGuards.isReturnTypedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.CallSignature:
            case typescript_1.SyntaxKind.ConstructSignature:
            case typescript_1.SyntaxKind.MethodSignature:
            case typescript_1.SyntaxKind.ConstructorType:
            case typescript_1.SyntaxKind.FunctionType:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a ScopeableNode.
     * @param node - Node to check.
     */
    TypeGuards.isScopeableNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.Parameter;
    };
    /**
     * Gets if the node is a ScopedNode.
     * @param node - Node to check.
     */
    TypeGuards.isScopedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a SemicolonToken.
     * @param node - Node to check.
     */
    TypeGuards.isSemicolonToken = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.SemicolonToken;
    };
    /**
     * Gets if the node is a SetAccessorDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isSetAccessorDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.SetAccessor;
    };
    /**
     * Gets if the node is a ShorthandPropertyAssignment.
     * @param node - Node to check.
     */
    TypeGuards.isShorthandPropertyAssignment = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ShorthandPropertyAssignment;
    };
    /**
     * Gets if the node is a SignaturedDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isSignaturedDeclaration = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.CallSignature:
            case typescript_1.SyntaxKind.ConstructSignature:
            case typescript_1.SyntaxKind.MethodSignature:
            case typescript_1.SyntaxKind.ConstructorType:
            case typescript_1.SyntaxKind.FunctionType:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a SourceFile.
     * @param node - Node to check.
     */
    TypeGuards.isSourceFile = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.SourceFile;
    };
    /**
     * Gets if the node is a SpreadAssignment.
     * @param node - Node to check.
     */
    TypeGuards.isSpreadAssignment = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.SpreadAssignment;
    };
    /**
     * Gets if the node is a SpreadElement.
     * @param node - Node to check.
     */
    TypeGuards.isSpreadElement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.SpreadElement;
    };
    /**
     * Gets if the node is a Statement.
     * @param node - Node to check.
     */
    TypeGuards.isStatement = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.EnumDeclaration:
            case typescript_1.SyntaxKind.ExportAssignment:
            case typescript_1.SyntaxKind.ExportDeclaration:
            case typescript_1.SyntaxKind.ImportDeclaration:
            case typescript_1.SyntaxKind.ImportEqualsDeclaration:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.Block:
            case typescript_1.SyntaxKind.BreakStatement:
            case typescript_1.SyntaxKind.ContinueStatement:
            case typescript_1.SyntaxKind.DebuggerStatement:
            case typescript_1.SyntaxKind.DoStatement:
            case typescript_1.SyntaxKind.EmptyStatement:
            case typescript_1.SyntaxKind.ExpressionStatement:
            case typescript_1.SyntaxKind.ForInStatement:
            case typescript_1.SyntaxKind.ForOfStatement:
            case typescript_1.SyntaxKind.ForStatement:
            case typescript_1.SyntaxKind.IfStatement:
            case typescript_1.SyntaxKind.LabeledStatement:
            case typescript_1.SyntaxKind.NotEmittedStatement:
            case typescript_1.SyntaxKind.ReturnStatement:
            case typescript_1.SyntaxKind.SwitchStatement:
            case typescript_1.SyntaxKind.ThrowStatement:
            case typescript_1.SyntaxKind.TryStatement:
            case typescript_1.SyntaxKind.VariableStatement:
            case typescript_1.SyntaxKind.WhileStatement:
            case typescript_1.SyntaxKind.WithStatement:
            case typescript_1.SyntaxKind.TypeAliasDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a StatementedNode.
     * @param node - Node to check.
     */
    TypeGuards.isStatementedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.SourceFile:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.Block:
            case typescript_1.SyntaxKind.CaseClause:
            case typescript_1.SyntaxKind.DefaultClause:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a StaticableNode.
     * @param node - Node to check.
     */
    TypeGuards.isStaticableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a StringKeyword.
     * @param node - Node to check.
     */
    TypeGuards.isStringKeyword = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.StringKeyword;
    };
    /**
     * Gets if the node is a StringLiteral.
     * @param node - Node to check.
     */
    TypeGuards.isStringLiteral = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.StringLiteral;
    };
    /**
     * Gets if the node is a SuperExpression.
     * @param node - Node to check.
     */
    TypeGuards.isSuperExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.SuperKeyword;
    };
    /**
     * Gets if the node is a SwitchStatement.
     * @param node - Node to check.
     */
    TypeGuards.isSwitchStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.SwitchStatement;
    };
    /**
     * Gets if the node is a SymbolKeyword.
     * @param node - Node to check.
     */
    TypeGuards.isSymbolKeyword = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.SymbolKeyword;
    };
    /**
     * Gets if the node is a SyntaxList.
     * @param node - Node to check.
     */
    TypeGuards.isSyntaxList = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.SyntaxList;
    };
    /**
     * Gets if the node is a TaggedTemplateExpression.
     * @param node - Node to check.
     */
    TypeGuards.isTaggedTemplateExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TaggedTemplateExpression;
    };
    /**
     * Gets if the node is a TemplateExpression.
     * @param node - Node to check.
     */
    TypeGuards.isTemplateExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TemplateExpression;
    };
    /**
     * Gets if the node is a TemplateHead.
     * @param node - Node to check.
     */
    TypeGuards.isTemplateHead = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TemplateHead;
    };
    /**
     * Gets if the node is a TemplateMiddle.
     * @param node - Node to check.
     */
    TypeGuards.isTemplateMiddle = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TemplateMiddle;
    };
    /**
     * Gets if the node is a TemplateSpan.
     * @param node - Node to check.
     */
    TypeGuards.isTemplateSpan = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TemplateSpan;
    };
    /**
     * Gets if the node is a TemplateTail.
     * @param node - Node to check.
     */
    TypeGuards.isTemplateTail = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TemplateTail;
    };
    /**
     * Gets if the node is a TextInsertableNode.
     * @param node - Node to check.
     */
    TypeGuards.isTextInsertableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.EnumDeclaration:
            case typescript_1.SyntaxKind.SourceFile:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.ModuleDeclaration:
            case typescript_1.SyntaxKind.Block:
            case typescript_1.SyntaxKind.CaseBlock:
            case typescript_1.SyntaxKind.CaseClause:
            case typescript_1.SyntaxKind.DefaultClause:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a ThisExpression.
     * @param node - Node to check.
     */
    TypeGuards.isThisExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ThisKeyword;
    };
    /**
     * Gets if the node is a ThrowStatement.
     * @param node - Node to check.
     */
    TypeGuards.isThrowStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.ThrowStatement;
    };
    /**
     * Gets if the node is a TrueKeyword.
     * @param node - Node to check.
     */
    TypeGuards.isTrueKeyword = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TrueKeyword;
    };
    /**
     * Gets if the node is a TryStatement.
     * @param node - Node to check.
     */
    TypeGuards.isTryStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TryStatement;
    };
    /**
     * Gets if the node is a TupleTypeNode.
     * @param node - Node to check.
     */
    TypeGuards.isTupleTypeNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TupleType;
    };
    /**
     * Gets if the node is a TypeAliasDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isTypeAliasDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TypeAliasDeclaration;
    };
    /**
     * Gets if the node is a TypeArgumentedNode.
     * @param node - Node to check.
     */
    TypeGuards.isTypeArgumentedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.CallExpression:
            case typescript_1.SyntaxKind.NewExpression:
            case typescript_1.SyntaxKind.ImportType:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a TypeAssertion.
     * @param node - Node to check.
     */
    TypeGuards.isTypeAssertion = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TypeAssertionExpression;
    };
    /**
     * Gets if the node is a TypeElement.
     * @param node - Node to check.
     */
    TypeGuards.isTypeElement = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.CallSignature:
            case typescript_1.SyntaxKind.ConstructSignature:
            case typescript_1.SyntaxKind.IndexSignature:
            case typescript_1.SyntaxKind.MethodSignature:
            case typescript_1.SyntaxKind.PropertySignature:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a TypeElementMemberedNode.
     * @param node - Node to check.
     */
    TypeGuards.isTypeElementMemberedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.TypeLiteral:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a TypeLiteralNode.
     * @param node - Node to check.
     */
    TypeGuards.isTypeLiteralNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TypeLiteral;
    };
    /**
     * Gets if the node is a TypeNode.
     * @param node - Node to check.
     */
    TypeGuards.isTypeNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.TypePredicate:
            case typescript_1.SyntaxKind.ArrayType:
            case typescript_1.SyntaxKind.ConstructorType:
            case typescript_1.SyntaxKind.ExpressionWithTypeArguments:
            case typescript_1.SyntaxKind.FunctionType:
            case typescript_1.SyntaxKind.ImportType:
            case typescript_1.SyntaxKind.IntersectionType:
            case typescript_1.SyntaxKind.LiteralType:
            case typescript_1.SyntaxKind.TupleType:
            case typescript_1.SyntaxKind.TypeLiteral:
            case typescript_1.SyntaxKind.TypeReference:
            case typescript_1.SyntaxKind.UnionType:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a TypeOfExpression.
     * @param node - Node to check.
     */
    TypeGuards.isTypeOfExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TypeOfExpression;
    };
    /**
     * Gets if the node is a TypeParameterDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isTypeParameterDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TypeParameter;
    };
    /**
     * Gets if the node is a TypeParameteredNode.
     * @param node - Node to check.
     */
    TypeGuards.isTypeParameteredNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.ClassDeclaration:
            case typescript_1.SyntaxKind.Constructor:
            case typescript_1.SyntaxKind.GetAccessor:
            case typescript_1.SyntaxKind.MethodDeclaration:
            case typescript_1.SyntaxKind.SetAccessor:
            case typescript_1.SyntaxKind.ArrowFunction:
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.CallSignature:
            case typescript_1.SyntaxKind.ConstructSignature:
            case typescript_1.SyntaxKind.InterfaceDeclaration:
            case typescript_1.SyntaxKind.MethodSignature:
            case typescript_1.SyntaxKind.FunctionType:
            case typescript_1.SyntaxKind.TypeAliasDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a TypeReferenceNode.
     * @param node - Node to check.
     */
    TypeGuards.isTypeReferenceNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.TypeReference;
    };
    /**
     * Gets if the node is a TypedNode.
     * @param node - Node to check.
     */
    TypeGuards.isTypedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.PropertyDeclaration:
            case typescript_1.SyntaxKind.AsExpression:
            case typescript_1.SyntaxKind.TypeAssertionExpression:
            case typescript_1.SyntaxKind.Parameter:
            case typescript_1.SyntaxKind.PropertySignature:
            case typescript_1.SyntaxKind.VariableDeclaration:
            case typescript_1.SyntaxKind.TypeAliasDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a UnaryExpression.
     * @param node - Node to check.
     */
    TypeGuards.isUnaryExpression = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Identifier:
            case typescript_1.SyntaxKind.AwaitExpression:
            case typescript_1.SyntaxKind.CallExpression:
            case typescript_1.SyntaxKind.DeleteExpression:
            case typescript_1.SyntaxKind.ElementAccessExpression:
            case typescript_1.SyntaxKind.ImportKeyword:
            case typescript_1.SyntaxKind.MetaProperty:
            case typescript_1.SyntaxKind.NewExpression:
            case typescript_1.SyntaxKind.NonNullExpression:
            case typescript_1.SyntaxKind.PostfixUnaryExpression:
            case typescript_1.SyntaxKind.PrefixUnaryExpression:
            case typescript_1.SyntaxKind.PropertyAccessExpression:
            case typescript_1.SyntaxKind.SuperKeyword:
            case typescript_1.SyntaxKind.ThisKeyword:
            case typescript_1.SyntaxKind.TypeAssertionExpression:
            case typescript_1.SyntaxKind.TypeOfExpression:
            case typescript_1.SyntaxKind.VoidKeyword:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.JsxElement:
            case typescript_1.SyntaxKind.JsxFragment:
            case typescript_1.SyntaxKind.JsxSelfClosingElement:
            case typescript_1.SyntaxKind.FalseKeyword:
            case typescript_1.SyntaxKind.TrueKeyword:
            case typescript_1.SyntaxKind.NullKeyword:
            case typescript_1.SyntaxKind.NumericLiteral:
            case typescript_1.SyntaxKind.RegularExpressionLiteral:
            case typescript_1.SyntaxKind.StringLiteral:
            case typescript_1.SyntaxKind.ArrayLiteralExpression:
            case typescript_1.SyntaxKind.ObjectLiteralExpression:
            case typescript_1.SyntaxKind.NoSubstitutionTemplateLiteral:
            case typescript_1.SyntaxKind.TaggedTemplateExpression:
            case typescript_1.SyntaxKind.TemplateExpression:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a UnaryExpressionedNode.
     * @param node - Node to check.
     */
    TypeGuards.isUnaryExpressionedNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.AwaitExpression:
            case typescript_1.SyntaxKind.DeleteExpression:
            case typescript_1.SyntaxKind.TypeAssertionExpression:
            case typescript_1.SyntaxKind.TypeOfExpression:
            case typescript_1.SyntaxKind.VoidKeyword:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a UndefinedKeyword.
     * @param node - Node to check.
     */
    TypeGuards.isUndefinedKeyword = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.UndefinedKeyword;
    };
    /**
     * Gets if the node is a UnionTypeNode.
     * @param node - Node to check.
     */
    TypeGuards.isUnionTypeNode = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.UnionType;
    };
    /**
     * Gets if the node is a UnwrappableNode.
     * @param node - Node to check.
     */
    TypeGuards.isUnwrappableNode = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.FunctionDeclaration:
            case typescript_1.SyntaxKind.ModuleDeclaration:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a UpdateExpression.
     * @param node - Node to check.
     */
    TypeGuards.isUpdateExpression = function (node) {
        switch (node.getKind()) {
            case typescript_1.SyntaxKind.Identifier:
            case typescript_1.SyntaxKind.CallExpression:
            case typescript_1.SyntaxKind.ElementAccessExpression:
            case typescript_1.SyntaxKind.ImportKeyword:
            case typescript_1.SyntaxKind.MetaProperty:
            case typescript_1.SyntaxKind.NewExpression:
            case typescript_1.SyntaxKind.NonNullExpression:
            case typescript_1.SyntaxKind.PropertyAccessExpression:
            case typescript_1.SyntaxKind.SuperKeyword:
            case typescript_1.SyntaxKind.ThisKeyword:
            case typescript_1.SyntaxKind.FunctionExpression:
            case typescript_1.SyntaxKind.JsxElement:
            case typescript_1.SyntaxKind.JsxFragment:
            case typescript_1.SyntaxKind.JsxSelfClosingElement:
            case typescript_1.SyntaxKind.FalseKeyword:
            case typescript_1.SyntaxKind.TrueKeyword:
            case typescript_1.SyntaxKind.NullKeyword:
            case typescript_1.SyntaxKind.NumericLiteral:
            case typescript_1.SyntaxKind.RegularExpressionLiteral:
            case typescript_1.SyntaxKind.StringLiteral:
            case typescript_1.SyntaxKind.ArrayLiteralExpression:
            case typescript_1.SyntaxKind.ObjectLiteralExpression:
            case typescript_1.SyntaxKind.NoSubstitutionTemplateLiteral:
            case typescript_1.SyntaxKind.TaggedTemplateExpression:
            case typescript_1.SyntaxKind.TemplateExpression:
                return true;
            default:
                return false;
        }
    };
    /**
     * Gets if the node is a VariableDeclaration.
     * @param node - Node to check.
     */
    TypeGuards.isVariableDeclaration = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.VariableDeclaration;
    };
    /**
     * Gets if the node is a VariableDeclarationList.
     * @param node - Node to check.
     */
    TypeGuards.isVariableDeclarationList = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.VariableDeclarationList;
    };
    /**
     * Gets if the node is a VariableStatement.
     * @param node - Node to check.
     */
    TypeGuards.isVariableStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.VariableStatement;
    };
    /**
     * Gets if the node is a VoidExpression.
     * @param node - Node to check.
     */
    TypeGuards.isVoidExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.VoidKeyword;
    };
    /**
     * Gets if the node is a WhileStatement.
     * @param node - Node to check.
     */
    TypeGuards.isWhileStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.WhileStatement;
    };
    /**
     * Gets if the node is a WithStatement.
     * @param node - Node to check.
     */
    TypeGuards.isWithStatement = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.WithStatement;
    };
    /**
     * Gets if the node is a YieldExpression.
     * @param node - Node to check.
     */
    TypeGuards.isYieldExpression = function (node) {
        return node.getKind() === typescript_1.SyntaxKind.YieldExpression;
    };
    return TypeGuards;
}());
exports.TypeGuards = TypeGuards;
