"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var errors = require("../errors");
var StringUtils = /** @class */ (function () {
    function StringUtils() {
    }
    StringUtils.isNullOrWhitespace = function (str) {
        return typeof str !== "string" || str.trim().length === 0;
    };
    StringUtils.repeat = function (str, times) {
        var newStr = "";
        for (var i = 0; i < times; i++)
            newStr += str;
        return newStr;
    };
    StringUtils.startsWith = function (str, startsWithString) {
        if (typeof String.prototype.startsWith === "function")
            return str.startsWith(startsWithString);
        return Es5StringUtils.startsWith(str, startsWithString);
    };
    StringUtils.endsWith = function (str, endsWithString) {
        if (typeof String.prototype.endsWith === "function")
            return str.endsWith(endsWithString);
        return Es5StringUtils.endsWith(str, endsWithString);
    };
    StringUtils.getLineNumberAtPos = function (str, pos) {
        errors.throwIfOutOfRange(pos, [0, str.length + 1], "pos");
        // do not allocate a string in this method
        var count = 0;
        for (var i = 0; i < pos; i++) {
            if (str[i] === "\n" || (str[i] === "\r" && str[i + 1] !== "\n"))
                count++;
        }
        return count + 1; // convert count to line number
    };
    StringUtils.getColumnAtPos = function (str, pos) {
        errors.throwIfOutOfRange(pos, [0, str.length + 1], "pos");
        var startPos = pos;
        while (pos > 0) {
            var previousChar = str[pos - 1];
            if (previousChar === "\n" || previousChar === "\r")
                break;
            pos--;
        }
        return startPos - pos;
    };
    StringUtils.escapeForWithinString = function (str, quoteKind) {
        return StringUtils.escapeChar(str, quoteKind).replace(/(\r?\n)/g, "\\$1");
    };
    /**
     * Escapes all the occurences of the char in the string.
     */
    StringUtils.escapeChar = function (str, char) {
        if (char.length !== 1)
            throw new errors.InvalidOperationError("Specified char must be one character long.");
        var result = "";
        for (var i = 0; i < str.length; i++) {
            if (str[i] === char)
                result += "\\";
            result += str[i];
        }
        return result;
    };
    return StringUtils;
}());
exports.StringUtils = StringUtils;
var Es5StringUtils = /** @class */ (function () {
    function Es5StringUtils() {
    }
    Es5StringUtils.startsWith = function (str, startsWithString) {
        return str.substr(0, startsWithString.length) === startsWithString;
    };
    Es5StringUtils.endsWith = function (str, endsWithString) {
        return str.substr(str.length - endsWithString.length, endsWithString.length) === endsWithString;
    };
    return Es5StringUtils;
}());
exports.Es5StringUtils = Es5StringUtils;
