"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("../../constants");
var typescript_1 = require("../../typescript");
var utils_1 = require("../../utils");
var textSeek_1 = require("../textSeek");
/**
 * Gets the insert pos from an index.
 */
function getInsertPosFromIndex(index, parent, children) {
    if (index === 0) {
        if (utils_1.TypeGuards.isSourceFile(parent))
            return parent.getFullText()[0] === constants_1.Chars.BOM ? 1 : 0;
        else if (utils_1.TypeGuards.isCaseClause(parent) || utils_1.TypeGuards.isDefaultClause(parent)) {
            var colonToken = parent.getFirstChildByKindOrThrow(typescript_1.SyntaxKind.ColonToken);
            return colonToken.getEnd();
        }
        else {
            var parentContainer = getParentContainer(parent);
            var openBraceToken = parentContainer.getFirstChildByKindOrThrow(typescript_1.SyntaxKind.OpenBraceToken);
            return openBraceToken.getEnd();
        }
    }
    return children[index - 1].getEnd();
}
exports.getInsertPosFromIndex = getInsertPosFromIndex;
function getEndPosFromIndex(index, parent, children, fullText) {
    var endPos;
    if (index === children.length) {
        if (utils_1.TypeGuards.isSourceFile(parent))
            endPos = parent.getEnd();
        else if (utils_1.TypeGuards.isCaseClause(parent) || utils_1.TypeGuards.isDefaultClause(parent))
            endPos = parent.getEnd();
        else {
            var parentContainer = getParentContainer(parent);
            var closeBraceToken = parentContainer.getLastChildByKind(typescript_1.SyntaxKind.CloseBraceToken);
            if (closeBraceToken == null)
                endPos = parent.getEnd();
            else
                endPos = closeBraceToken.getNonWhitespaceStart();
        }
    }
    else
        endPos = children[index].getNonWhitespaceStart();
    // use the start of the current line instead of the end of the previous line so that
    // this works the same for code at the start of the file
    return textSeek_1.getPosAtStartOfLineOrNonWhitespace(fullText, endPos);
}
exports.getEndPosFromIndex = getEndPosFromIndex;
function getParentContainer(parent) {
    if (utils_1.TypeGuards.isBodiedNode(parent))
        return parent.getBody();
    if (utils_1.TypeGuards.isBodyableNode(parent))
        return parent.getBodyOrThrow();
    else
        return parent;
}
