"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var base_1 = require("../base");
var callBaseFill_1 = require("../callBaseFill");
var namespace_1 = require("../namespace");
var Statement_1 = require("./Statement");
exports.VariableStatementBase = base_1.ChildOrderableNode(namespace_1.NamespaceChildableNode(base_1.JSDocableNode(base_1.AmbientableNode(base_1.ExportableNode(base_1.ModifierableNode(Statement_1.Statement))))));
var VariableStatement = /** @class */ (function (_super) {
    tslib_1.__extends(VariableStatement, _super);
    function VariableStatement() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Get variable declaration list.
     */
    VariableStatement.prototype.getDeclarationList = function () {
        return this.getNodeFromCompilerNode(this.compilerNode.declarationList);
    };
    /**
     * Get the variable declarations.
     */
    VariableStatement.prototype.getDeclarations = function () {
        return this.getDeclarationList().getDeclarations();
    };
    /**
     * Gets the variable declaration kind.
     */
    VariableStatement.prototype.getDeclarationKind = function () {
        return this.getDeclarationList().getDeclarationKind();
    };
    /**
     * Gets the variable declaration kind keyword.
     */
    VariableStatement.prototype.getDeclarationKindKeyword = function () {
        return this.getDeclarationList().getDeclarationKindKeyword();
    };
    /**
     * Sets the variable declaration kind.
     * @param type - Type to set.
     */
    VariableStatement.prototype.setDeclarationKind = function (type) {
        return this.getDeclarationList().setDeclarationKind(type);
    };
    /**
     * Add a variable declaration to the statement.
     * @param structure - Structure representing the variable declaration to add.
     */
    VariableStatement.prototype.addDeclaration = function (structure) {
        return this.getDeclarationList().addDeclaration(structure);
    };
    /**
     * Adds variable declarations to the statement.
     * @param structures - Structures representing the variable declarations to add.
     */
    VariableStatement.prototype.addDeclarations = function (structures) {
        return this.getDeclarationList().addDeclarations(structures);
    };
    /**
     * Inserts a variable declaration at the specified index within the statement.
     * @param index - Index to insert.
     * @param structure - Structure representing the variable declaration to insert.
     */
    VariableStatement.prototype.insertDeclaration = function (index, structure) {
        return this.getDeclarationList().insertDeclaration(index, structure);
    };
    /**
     * Inserts variable declarations at the specified index within the statement.
     * @param index - Index to insert.
     * @param structures - Structures representing the variable declarations to insert.
     */
    VariableStatement.prototype.insertDeclarations = function (index, structures) {
        return this.getDeclarationList().insertDeclarations(index, structures);
    };
    /**
     * Fills the node from a structure.
     * @param structure - Structure to fill.
     */
    VariableStatement.prototype.fill = function (structure) {
        callBaseFill_1.callBaseFill(exports.VariableStatementBase.prototype, this, structure);
        if (structure.declarationKind != null)
            this.setDeclarationKind(structure.declarationKind);
        if (structure.declarations != null)
            this.addDeclarations(structure.declarations);
        return this;
    };
    return VariableStatement;
}(exports.VariableStatementBase));
exports.VariableStatement = VariableStatement;
