"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var manipulation_1 = require("../../manipulation");
var getStructureFuncs = require("../../manipulation/helpers/getStructureFunctions");
var typescript_1 = require("../../typescript");
var base_1 = require("../base");
var callBaseFill_1 = require("../callBaseFill");
var common_1 = require("../common");
var namespace_1 = require("../namespace");
var statement_1 = require("../statement");
var FunctionLikeDeclaration_1 = require("./FunctionLikeDeclaration");
var OverloadableNode_1 = require("./OverloadableNode");
exports.FunctionDeclarationBase = base_1.ChildOrderableNode(base_1.UnwrappableNode(base_1.TextInsertableNode(OverloadableNode_1.OverloadableNode(base_1.BodyableNode(base_1.AsyncableNode(base_1.GeneratorableNode(FunctionLikeDeclaration_1.FunctionLikeDeclaration(statement_1.StatementedNode(base_1.AmbientableNode(namespace_1.NamespaceChildableNode(base_1.ExportableNode(base_1.ModifierableNode(base_1.NamedNode(common_1.Node))))))))))))));
var FunctionDeclaration = /** @class */ (function (_super) {
    tslib_1.__extends(FunctionDeclaration, _super);
    function FunctionDeclaration() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Fills the node from a structure.
     * @param structure - Structure to fill.
     */
    FunctionDeclaration.prototype.fill = function (structure) {
        callBaseFill_1.callBaseFill(exports.FunctionDeclarationBase.prototype, this, structure);
        if (structure.overloads != null && structure.overloads.length > 0)
            this.addOverloads(structure.overloads);
        return this;
    };
    /**
     * Adds a function overload.
     * @param structure - Structure of the overload.
     */
    FunctionDeclaration.prototype.addOverload = function (structure) {
        return this.addOverloads([structure])[0];
    };
    /**
     * Adds function overloads.
     * @param structures - Structures of the overloads.
     */
    FunctionDeclaration.prototype.addOverloads = function (structures) {
        return this.insertOverloads(this.getOverloads().length, structures);
    };
    /**
     * Inserts a function overload.
     * @param index - Index to insert.
     * @param structure - Structure of the overload.
     */
    FunctionDeclaration.prototype.insertOverload = function (index, structure) {
        return this.insertOverloads(index, [structure])[0];
    };
    /**
     * Inserts function overloads.
     * @param index - Index to insert.
     * @param structure - Structures of the overloads.
     */
    FunctionDeclaration.prototype.insertOverloads = function (index, structures) {
        var thisName = this.getName();
        var childCodes = structures.map(function (structure) { return "function " + thisName + "();"; });
        return OverloadableNode_1.insertOverloads({
            node: this,
            index: index,
            structures: structures,
            childCodes: childCodes,
            getThisStructure: getStructureFuncs.fromFunctionDeclarationOverload,
            fillNodeFromStructure: function (node, structure) { return node.fill(structure); },
            expectedSyntaxKind: typescript_1.SyntaxKind.FunctionDeclaration
        });
    };
    /**
     * Removes this function declaration.
     */
    FunctionDeclaration.prototype.remove = function () {
        manipulation_1.removeOverloadableStatementedNodeChild(this);
    };
    return FunctionDeclaration;
}(exports.FunctionDeclarationBase));
exports.FunctionDeclaration = FunctionDeclaration;
