"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var manipulation_1 = require("../../manipulation");
var typescript_1 = require("../../typescript");
var utils_1 = require("../../utils");
var base_1 = require("../base");
var callBaseFill_1 = require("../callBaseFill");
var common_1 = require("../common");
exports.EnumMemberBase = base_1.JSDocableNode(base_1.InitializerExpressionableNode(base_1.PropertyNamedNode(common_1.Node)));
var EnumMember = /** @class */ (function (_super) {
    tslib_1.__extends(EnumMember, _super);
    function EnumMember() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Fills the node from a structure.
     * @param structure - Structure to fill.
     */
    EnumMember.prototype.fill = function (structure) {
        callBaseFill_1.callBaseFill(exports.EnumMemberBase.prototype, this, structure);
        if (structure.value != null)
            this.setValue(structure.value);
        return this;
    };
    /**
     * Gets the constant value of the enum.
     */
    EnumMember.prototype.getValue = function () {
        return this.global.typeChecker.getConstantValue(this);
    };
    /**
     * Sets the enum value.
     * @param value - Enum value.
     */
    EnumMember.prototype.setValue = function (value) {
        var text;
        if (typeof value === "string") {
            var quoteKind = this.global.manipulationSettings.getQuoteKind();
            text = quoteKind + utils_1.StringUtils.escapeForWithinString(value, quoteKind) + quoteKind;
        }
        else {
            text = value.toString();
        }
        this.setInitializer(text);
        return this;
    };
    /**
     * Removes this enum member.
     */
    EnumMember.prototype.remove = function () {
        var childrenToRemove = [this];
        var commaToken = this.getNextSiblingIfKind(typescript_1.SyntaxKind.CommaToken);
        if (commaToken != null)
            childrenToRemove.push(commaToken);
        manipulation_1.removeChildrenWithFormatting({
            children: childrenToRemove,
            getSiblingFormatting: function () { return manipulation_1.FormattingKind.Newline; }
        });
    };
    return EnumMember;
}(exports.EnumMemberBase));
exports.EnumMember = EnumMember;
