"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var manipulation_1 = require("../../manipulation");
var textSeek_1 = require("../../manipulation/textSeek");
var utils_1 = require("../../utils");
var common_1 = require("../common");
/**
 * JS doc node.
 */
var JSDoc = /** @class */ (function (_super) {
    tslib_1.__extends(JSDoc, _super);
    function JSDoc() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Gets the tags of the JSDoc.
     */
    JSDoc.prototype.getTags = function () {
        var _this = this;
        var tags = this.compilerNode.tags;
        if (tags == null)
            return [];
        return tags.map(function (t) { return _this.getNodeFromCompilerNode(t); });
    };
    /**
     * Gets the comment.
     */
    JSDoc.prototype.getComment = function () {
        return this.compilerNode.comment;
    };
    /**
     * Gets the JSDoc's text without the surrounding comment.
     */
    JSDoc.prototype.getInnerText = function () {
        var innerTextWithStars = this.getText().replace(/^\/\*\*[^\S\n]*\n?/, "").replace(/(\r?\n)?[^\S\n]*\*\/$/, "");
        return innerTextWithStars.split(/\n/).map(function (line) {
            var starPos = line.indexOf("*");
            if (starPos === -1)
                return line;
            var substringStart = line[starPos + 1] === " " ? starPos + 2 : starPos + 1;
            return line.substring(substringStart);
        }).join("\n");
    };
    JSDoc.prototype.setComment = function (textOrWriterFunction) {
        var tags = this.getTags();
        var startEditPos = this.getStart() + 3;
        var endEditPos = tags.length > 0 ? textSeek_1.getPreviousMatchingPos(this.sourceFile.getFullText(), tags[0].getStart(), function (c) { return c === "*"; }) - 1 : this.getEnd() - 2;
        var indentationText = this.getIndentationText();
        var newLineKind = this.global.manipulationSettings.getNewLineKindAsString();
        var text = utils_1.getTextFromStringOrWriter(this.getWriter(), textOrWriterFunction);
        var newText = newLineKind + text.split(/\r?\n/).map(function (l) { return indentationText + " * " + l; }).join(newLineKind) + newLineKind + indentationText + " ";
        manipulation_1.replaceTextPossiblyCreatingChildNodes({
            parent: this,
            newText: newText,
            replacePos: startEditPos,
            replacingLength: endEditPos - startEditPos
        });
        return this;
    };
    /**
     * Removes this JSDoc.
     */
    JSDoc.prototype.remove = function () {
        manipulation_1.removeChildren({
            children: [this],
            removeFollowingSpaces: true,
            removeFollowingNewLines: true
        });
    };
    return JSDoc;
}(common_1.Node));
exports.JSDoc = JSDoc;
