"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var manipulation_1 = require("../../manipulation");
var getStructureFuncs = require("../../manipulation/helpers/getStructureFunctions");
var typescript_1 = require("../../typescript");
var base_1 = require("../base");
var callBaseFill_1 = require("../callBaseFill");
var common_1 = require("../common");
var function_1 = require("../function");
var base_2 = require("./base");
exports.MethodDeclarationBase = base_1.ChildOrderableNode(base_1.TextInsertableNode(function_1.OverloadableNode(base_1.BodyableNode(base_1.DecoratableNode(base_2.AbstractableNode(base_1.ScopedNode(base_1.StaticableNode(base_1.AsyncableNode(base_1.GeneratorableNode(function_1.FunctionLikeDeclaration(base_1.PropertyNamedNode(common_1.Node))))))))))));
var MethodDeclaration = /** @class */ (function (_super) {
    tslib_1.__extends(MethodDeclaration, _super);
    function MethodDeclaration() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Fills the node from a structure.
     * @param structure - Structure to fill.
     */
    MethodDeclaration.prototype.fill = function (structure) {
        callBaseFill_1.callBaseFill(exports.MethodDeclarationBase.prototype, this, structure);
        if (structure.overloads != null && structure.overloads.length > 0)
            this.addOverloads(structure.overloads);
        return this;
    };
    /**
     * Add a method overload.
     * @param structure - Structure to add.
     */
    MethodDeclaration.prototype.addOverload = function (structure) {
        return this.addOverloads([structure])[0];
    };
    /**
     * Add method overloads.
     * @param structures - Structures to add.
     */
    MethodDeclaration.prototype.addOverloads = function (structures) {
        return this.insertOverloads(this.getOverloads().length, structures);
    };
    /**
     * Inserts a method overload.
     * @param index - Index to insert at.
     * @param structure - Structures to insert.
     */
    MethodDeclaration.prototype.insertOverload = function (index, structure) {
        return this.insertOverloads(index, [structure])[0];
    };
    /**
     * Inserts method overloads.
     * @param index - Index to insert at.
     * @param structures - Structures to insert.
     */
    MethodDeclaration.prototype.insertOverloads = function (index, structures) {
        var thisName = this.getName();
        var childCodes = structures.map(function (structure) { return thisName + "();"; });
        return function_1.insertOverloads({
            node: this,
            index: index,
            structures: structures,
            childCodes: childCodes,
            getThisStructure: getStructureFuncs.fromMethodDeclarationOverload,
            fillNodeFromStructure: function (node, structure) { return node.fill(structure); },
            expectedSyntaxKind: typescript_1.SyntaxKind.MethodDeclaration
        });
    };
    /**
     * Removes the method.
     */
    MethodDeclaration.prototype.remove = function () {
        manipulation_1.removeOverloadableClassMember(this);
    };
    return MethodDeclaration;
}(exports.MethodDeclarationBase));
exports.MethodDeclaration = MethodDeclaration;
