"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var manipulation_1 = require("../../manipulation");
var getStructureFuncs = require("../../manipulation/helpers/getStructureFunctions");
var typescript_1 = require("../../typescript");
var base_1 = require("../base");
var callBaseFill_1 = require("../callBaseFill");
var common_1 = require("../common");
var function_1 = require("../function");
exports.ConstructorDeclarationBase = base_1.ChildOrderableNode(base_1.TextInsertableNode(function_1.OverloadableNode(base_1.ScopedNode(function_1.FunctionLikeDeclaration(base_1.BodyableNode(common_1.Node))))));
var ConstructorDeclaration = /** @class */ (function (_super) {
    tslib_1.__extends(ConstructorDeclaration, _super);
    function ConstructorDeclaration() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Fills the node from a structure.
     * @param structure - Structure to fill.
     */
    ConstructorDeclaration.prototype.fill = function (structure) {
        callBaseFill_1.callBaseFill(exports.ConstructorDeclarationBase.prototype, this, structure);
        if (structure.overloads != null && structure.overloads.length > 0)
            this.addOverloads(structure.overloads);
        return this;
    };
    /**
     * Add a constructor overload.
     * @param structure - Structure to add.
     */
    ConstructorDeclaration.prototype.addOverload = function (structure) {
        return this.addOverloads([structure])[0];
    };
    /**
     * Add constructor overloads.
     * @param structures - Structures to add.
     */
    ConstructorDeclaration.prototype.addOverloads = function (structures) {
        return this.insertOverloads(this.getOverloads().length, structures);
    };
    /**
     * Inserts a constructor overload.
     * @param index - Index to insert at.
     * @param structure - Structures to insert.
     */
    ConstructorDeclaration.prototype.insertOverload = function (index, structure) {
        return this.insertOverloads(index, [structure])[0];
    };
    /**
     * Inserts constructor overloads.
     * @param index - Index to insert at.
     * @param structures - Structures to insert.
     */
    ConstructorDeclaration.prototype.insertOverloads = function (index, structures) {
        var childCodes = structures.map(function (structure) { return "constructor();"; });
        return function_1.insertOverloads({
            node: this,
            index: index,
            structures: structures,
            childCodes: childCodes,
            getThisStructure: getStructureFuncs.fromConstructorDeclarationOverload,
            fillNodeFromStructure: function (node, structure) { return node.fill(structure); },
            expectedSyntaxKind: typescript_1.SyntaxKind.Constructor
        });
    };
    /**
     * Remove the constructor.
     */
    ConstructorDeclaration.prototype.remove = function () {
        manipulation_1.removeOverloadableClassMember(this);
    };
    return ConstructorDeclaration;
}(exports.ConstructorDeclarationBase));
exports.ConstructorDeclaration = ConstructorDeclaration;
