"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var errors = require("../../../errors");
var manipulation_1 = require("../../../manipulation");
var typescript_1 = require("../../../typescript");
var utils_1 = require("../../../utils");
var callBaseFill_1 = require("../../callBaseFill");
var ReferenceFindableNode_1 = require("./ReferenceFindableNode");
function NameableNode(Base) {
    return NameableNodeInternal(ReferenceFindableNode_1.ReferenceFindableNode(Base));
}
exports.NameableNode = NameableNode;
function NameableNodeInternal(Base) {
    return /** @class */ (function (_super) {
        tslib_1.__extends(class_1, _super);
        function class_1() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        class_1.prototype.getNameNode = function () {
            return this.getNodeFromCompilerNodeIfExists(this.compilerNode.name);
        };
        class_1.prototype.getNameNodeOrThrow = function () {
            return errors.throwIfNullOrUndefined(this.getNameNode(), "Expected to have a name node.");
        };
        class_1.prototype.getName = function () {
            var identifier = this.getNameNode();
            return identifier == null ? undefined : identifier.getText();
        };
        class_1.prototype.getNameOrThrow = function () {
            return errors.throwIfNullOrUndefined(this.getName(), "Expected to have a name.");
        };
        class_1.prototype.rename = function (newName) {
            if (newName === this.getName())
                return this;
            var nameNode = this.getNameNode();
            if (utils_1.StringUtils.isNullOrWhitespace(newName)) {
                if (nameNode == null)
                    return this;
                manipulation_1.removeChildren({ children: [nameNode], removePrecedingSpaces: true });
                return this;
            }
            if (nameNode == null) {
                var openParenToken = this.getFirstChildByKindOrThrow(typescript_1.SyntaxKind.OpenParenToken);
                manipulation_1.insertIntoParentTextRange({
                    insertPos: openParenToken.getStart(),
                    newText: " " + newName,
                    parent: this
                });
            }
            else
                nameNode.rename(newName);
            return this;
        };
        class_1.prototype.fill = function (structure) {
            callBaseFill_1.callBaseFill(Base.prototype, this, structure);
            if (structure.name != null)
                this.rename(structure.name);
            return this;
        };
        return class_1;
    }(Base));
}
