"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var errors = require("../../errors");
var manipulation_1 = require("../../manipulation");
var typescript_1 = require("../../typescript");
var utils_1 = require("../../utils");
var callBaseFill_1 = require("../callBaseFill");
function TypeElementMemberedNode(Base) {
    return /** @class */ (function (_super) {
        tslib_1.__extends(class_1, _super);
        function class_1() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        class_1.prototype.addConstructSignature = function (structure) {
            return this.addConstructSignatures([structure])[0];
        };
        class_1.prototype.addConstructSignatures = function (structures) {
            return this.insertConstructSignatures(manipulation_1.getEndIndexFromArray(this.compilerNode.members), structures);
        };
        class_1.prototype.insertConstructSignature = function (index, structure) {
            return this.insertConstructSignatures(index, [structure])[0];
        };
        class_1.prototype.insertConstructSignatures = function (index, structures) {
            var _this = this;
            return insertChildren({
                thisNode: this,
                index: index,
                structures: structures,
                expectedKind: typescript_1.SyntaxKind.ConstructSignature,
                createStructurePrinter: function () { return _this.global.structurePrinterFactory.forConstructSignatureDeclaration(); }
            });
        };
        class_1.prototype.getConstructSignature = function (findFunction) {
            return utils_1.ArrayUtils.find(this.getConstructSignatures(), findFunction);
        };
        class_1.prototype.getConstructSignatureOrThrow = function (findFunction) {
            return errors.throwIfNullOrUndefined(this.getConstructSignature(findFunction), "Expected to find a construct signature with the provided condition.");
        };
        class_1.prototype.getConstructSignatures = function () {
            var _this = this;
            return this.compilerNode.members.filter(function (m) { return m.kind === typescript_1.SyntaxKind.ConstructSignature; })
                .map(function (m) { return _this.getNodeFromCompilerNode(m); });
        };
        class_1.prototype.addCallSignature = function (structure) {
            return this.addCallSignatures([structure])[0];
        };
        class_1.prototype.addCallSignatures = function (structures) {
            return this.insertCallSignatures(manipulation_1.getEndIndexFromArray(this.compilerNode.members), structures);
        };
        class_1.prototype.insertCallSignature = function (index, structure) {
            return this.insertCallSignatures(index, [structure])[0];
        };
        class_1.prototype.insertCallSignatures = function (index, structures) {
            var _this = this;
            return insertChildren({
                thisNode: this,
                index: index,
                structures: structures,
                expectedKind: typescript_1.SyntaxKind.CallSignature,
                createStructurePrinter: function () { return _this.global.structurePrinterFactory.forCallSignatureDeclaration(); }
            });
        };
        class_1.prototype.getCallSignature = function (findFunction) {
            return utils_1.ArrayUtils.find(this.getCallSignatures(), findFunction);
        };
        class_1.prototype.getCallSignatureOrThrow = function (findFunction) {
            return errors.throwIfNullOrUndefined(this.getCallSignature(findFunction), "Expected to find a call signature with the provided condition.");
        };
        class_1.prototype.getCallSignatures = function () {
            var _this = this;
            return this.compilerNode.members.filter(function (m) { return m.kind === typescript_1.SyntaxKind.CallSignature; })
                .map(function (m) { return _this.getNodeFromCompilerNode(m); });
        };
        class_1.prototype.addIndexSignature = function (structure) {
            return this.addIndexSignatures([structure])[0];
        };
        class_1.prototype.addIndexSignatures = function (structures) {
            return this.insertIndexSignatures(manipulation_1.getEndIndexFromArray(this.compilerNode.members), structures);
        };
        class_1.prototype.insertIndexSignature = function (index, structure) {
            return this.insertIndexSignatures(index, [structure])[0];
        };
        class_1.prototype.insertIndexSignatures = function (index, structures) {
            var _this = this;
            return insertChildren({
                thisNode: this,
                index: index,
                structures: structures,
                expectedKind: typescript_1.SyntaxKind.IndexSignature,
                createStructurePrinter: function () { return _this.global.structurePrinterFactory.forIndexSignatureDeclaration(); }
            });
        };
        class_1.prototype.getIndexSignature = function (findFunction) {
            return utils_1.ArrayUtils.find(this.getIndexSignatures(), findFunction);
        };
        class_1.prototype.getIndexSignatureOrThrow = function (findFunction) {
            return errors.throwIfNullOrUndefined(this.getIndexSignature(findFunction), "Expected to find a index signature with the provided condition.");
        };
        class_1.prototype.getIndexSignatures = function () {
            var _this = this;
            return this.compilerNode.members.filter(function (m) { return m.kind === typescript_1.SyntaxKind.IndexSignature; })
                .map(function (m) { return _this.getNodeFromCompilerNode(m); });
        };
        class_1.prototype.addMethod = function (structure) {
            return this.addMethods([structure])[0];
        };
        class_1.prototype.addMethods = function (structures) {
            return this.insertMethods(manipulation_1.getEndIndexFromArray(this.compilerNode.members), structures);
        };
        class_1.prototype.insertMethod = function (index, structure) {
            return this.insertMethods(index, [structure])[0];
        };
        class_1.prototype.insertMethods = function (index, structures) {
            var _this = this;
            return insertChildren({
                thisNode: this,
                index: index,
                structures: structures,
                expectedKind: typescript_1.SyntaxKind.MethodSignature,
                createStructurePrinter: function () { return _this.global.structurePrinterFactory.forMethodSignature(); }
            });
        };
        class_1.prototype.getMethod = function (nameOrFindFunction) {
            return utils_1.getNodeByNameOrFindFunction(this.getMethods(), nameOrFindFunction);
        };
        class_1.prototype.getMethodOrThrow = function (nameOrFindFunction) {
            return errors.throwIfNullOrUndefined(this.getMethod(nameOrFindFunction), function () { return utils_1.getNotFoundErrorMessageForNameOrFindFunction("interface method signature", nameOrFindFunction); });
        };
        class_1.prototype.getMethods = function () {
            var _this = this;
            return this.compilerNode.members.filter(function (m) { return m.kind === typescript_1.SyntaxKind.MethodSignature; })
                .map(function (m) { return _this.getNodeFromCompilerNode(m); });
        };
        class_1.prototype.addProperty = function (structure) {
            return this.addProperties([structure])[0];
        };
        class_1.prototype.addProperties = function (structures) {
            return this.insertProperties(manipulation_1.getEndIndexFromArray(this.compilerNode.members), structures);
        };
        class_1.prototype.insertProperty = function (index, structure) {
            return this.insertProperties(index, [structure])[0];
        };
        class_1.prototype.insertProperties = function (index, structures) {
            var _this = this;
            return insertChildren({
                thisNode: this,
                index: index,
                structures: structures,
                expectedKind: typescript_1.SyntaxKind.PropertySignature,
                createStructurePrinter: function () { return _this.global.structurePrinterFactory.forPropertySignature(); }
            });
        };
        class_1.prototype.getProperty = function (nameOrFindFunction) {
            return utils_1.getNodeByNameOrFindFunction(this.getProperties(), nameOrFindFunction);
        };
        class_1.prototype.getPropertyOrThrow = function (nameOrFindFunction) {
            return errors.throwIfNullOrUndefined(this.getProperty(nameOrFindFunction), function () { return utils_1.getNotFoundErrorMessageForNameOrFindFunction("interface property signature", nameOrFindFunction); });
        };
        class_1.prototype.getProperties = function () {
            var _this = this;
            return this.compilerNode.members.filter(function (m) { return m.kind === typescript_1.SyntaxKind.PropertySignature; })
                .map(function (m) { return _this.getNodeFromCompilerNode(m); });
        };
        class_1.prototype.getMembers = function () {
            var _this = this;
            return this.compilerNode.members.map(function (m) { return _this.getNodeFromCompilerNode(m); });
        };
        class_1.prototype.fill = function (structure) {
            callBaseFill_1.callBaseFill(Base.prototype, this, structure);
            if (structure.callSignatures != null)
                this.addCallSignatures(structure.callSignatures);
            if (structure.constructSignatures != null)
                this.addConstructSignatures(structure.constructSignatures);
            if (structure.indexSignatures != null)
                this.addIndexSignatures(structure.indexSignatures);
            if (structure.properties != null)
                this.addProperties(structure.properties);
            if (structure.methods != null)
                this.addMethods(structure.methods);
            return this;
        };
        return class_1;
    }(Base));
}
exports.TypeElementMemberedNode = TypeElementMemberedNode;
function insertChildren(opts) {
    return manipulation_1.insertIntoBracesOrSourceFileWithGetChildren({
        getIndexedChildren: function () { return opts.thisNode.getMembers(); },
        parent: opts.thisNode,
        index: opts.index,
        structures: opts.structures,
        expectedKind: opts.expectedKind,
        write: function (writer, info) {
            writer.newLineIfLastNot();
            opts.createStructurePrinter().printTexts(writer, opts.structures);
            writer.newLineIfLastNot();
        }
    });
}
